/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sf.juife.JuifeUtils;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.ScanJobInfo;
import org.linuxsampler.lscp.event.InstrumentsDbAdapter;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;

public class JSAddDbInstrumentsProgressDlg
extends JDialog {
    private final JProgressBar progressJobStatus = new JProgressBar(0, 100);
    private final JProgressBar progressFileStatus = new JProgressBar(0, 100);
    private final JButton btnHide = new JButton(StdI18n.i18n.getButtonLabel("JSAddDbInstrumentsProgressDlg.btnHide"));
    private final int jobId;
    private boolean finished = false;
    private final EventHandler eventHandler = new EventHandler();

    public JSAddDbInstrumentsProgressDlg(Frame frame, int n) {
        super(frame, StdI18n.i18n.getLabel("JSAddDbInstrumentsProgressDlg.title"));
        this.jobId = n;
        this.initAddDbInstrumentsProgressDlg();
    }

    public JSAddDbInstrumentsProgressDlg(Dialog dialog, int n) {
        super(dialog, StdI18n.i18n.getLabel("JSAddDbInstrumentsProgressDlg.title"));
        this.jobId = n;
        this.initAddDbInstrumentsProgressDlg();
    }

    private void initAddDbInstrumentsProgressDlg() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.progressJobStatus.setAlignmentX(0.5f);
        jPanel.add(this.progressJobStatus);
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        this.progressFileStatus.setAlignmentX(0.5f);
        jPanel.add(this.progressFileStatus);
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        this.btnHide.setAlignmentX(0.5f);
        jPanel.add(this.btnHide);
        this.progressJobStatus.setStringPainted(true);
        this.progressFileStatus.setStringPainted(true);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(jPanel);
        Dimension dimension = jPanel.getPreferredSize();
        jPanel.setPreferredSize(new Dimension(400, dimension.height));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocation(JuifeUtils.centerLocation(this, this.getOwner()));
        this.btnHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getClient().removeInstrumentsDbListener(JSAddDbInstrumentsProgressDlg.this.getHandler());
                JSAddDbInstrumentsProgressDlg.this.setVisible(false);
            }
        });
        CC.getClient().addInstrumentsDbListener(this.getHandler());
    }

    public void updateStatus() {
        final InstrumentsDb.GetScanJobInfo getScanJobInfo = new InstrumentsDb.GetScanJobInfo(this.jobId);
        getScanJobInfo.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getScanJobInfo.doneWithErrors()) {
                    JSAddDbInstrumentsProgressDlg.this.failed();
                    return;
                }
                JSAddDbInstrumentsProgressDlg.this.updateStatus((ScanJobInfo)getScanJobInfo.getResult());
            }
        });
        CC.scheduleTask(getScanJobInfo);
    }

    private void updateStatus(ScanJobInfo scanJobInfo) {
        if (scanJobInfo.isFinished()) {
            this.finished = true;
            CC.getClient().removeInstrumentsDbListener(this.getHandler());
            if (scanJobInfo.status < 0) {
                this.failed();
                return;
            }
            this.progressJobStatus.setValue(this.progressJobStatus.getMaximum());
            this.progressFileStatus.setValue(this.progressFileStatus.getMaximum());
            this.dispose();
            this.getOwner().setVisible(false);
            return;
        }
        if (this.progressJobStatus.getMaximum() != scanJobInfo.filesTotal * 100) {
            this.progressJobStatus.setMaximum(scanJobInfo.filesTotal * 100);
        }
        String string = StdI18n.i18n.getMessage("JSAddDbInstrumentsProgressDlg.jobStatus", scanJobInfo.filesScanned, scanJobInfo.filesTotal);
        this.progressJobStatus.setString(string);
        this.progressFileStatus.setValue(scanJobInfo.status);
        this.progressFileStatus.setString(scanJobInfo.scanning);
        this.progressJobStatus.setValue(scanJobInfo.filesScanned * 100 + scanJobInfo.status);
    }

    private void failed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSAddDbInstrumentsProgressDlg.this.failed0();
            }
        });
    }

    private void failed0() {
        HF.showErrorMessage(StdI18n.i18n.getMessage("JSAddDbInstrumentsProgressDlg.failed"), (Component)this);
        this.setVisible(false);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    extends InstrumentsDbAdapter {
        private EventHandler() {
        }

        @Override
        public void jobStatusChanged(InstrumentsDbEvent instrumentsDbEvent) {
            if (instrumentsDbEvent.getJobId() != JSAddDbInstrumentsProgressDlg.this.jobId) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSAddDbInstrumentsProgressDlg.this.updateStatus();
                }
            });
        }
    }
}

