﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {

/**
 * <p>Information about a data provider.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DataProviderDescriptorDefinition">AWS
 * API Reference</a></p>
 */
class DataProviderDescriptorDefinition {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptorDefinition() = default;
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptorDefinition(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptorDefinition& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATABASEMIGRATIONSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name or Amazon Resource Name (ARN) of the data provider.</p>
   */
  inline const Aws::String& GetDataProviderIdentifier() const { return m_dataProviderIdentifier; }
  inline bool DataProviderIdentifierHasBeenSet() const { return m_dataProviderIdentifierHasBeenSet; }
  template <typename DataProviderIdentifierT = Aws::String>
  void SetDataProviderIdentifier(DataProviderIdentifierT&& value) {
    m_dataProviderIdentifierHasBeenSet = true;
    m_dataProviderIdentifier = std::forward<DataProviderIdentifierT>(value);
  }
  template <typename DataProviderIdentifierT = Aws::String>
  DataProviderDescriptorDefinition& WithDataProviderIdentifier(DataProviderIdentifierT&& value) {
    SetDataProviderIdentifier(std::forward<DataProviderIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Amazon Web Services Secrets Manager Secret used to
   * store access credentials for the data provider.</p>
   */
  inline const Aws::String& GetSecretsManagerSecretId() const { return m_secretsManagerSecretId; }
  inline bool SecretsManagerSecretIdHasBeenSet() const { return m_secretsManagerSecretIdHasBeenSet; }
  template <typename SecretsManagerSecretIdT = Aws::String>
  void SetSecretsManagerSecretId(SecretsManagerSecretIdT&& value) {
    m_secretsManagerSecretIdHasBeenSet = true;
    m_secretsManagerSecretId = std::forward<SecretsManagerSecretIdT>(value);
  }
  template <typename SecretsManagerSecretIdT = Aws::String>
  DataProviderDescriptorDefinition& WithSecretsManagerSecretId(SecretsManagerSecretIdT&& value) {
    SetSecretsManagerSecretId(std::forward<SecretsManagerSecretIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the role used to access Amazon Web Services Secrets Manager.</p>
   */
  inline const Aws::String& GetSecretsManagerAccessRoleArn() const { return m_secretsManagerAccessRoleArn; }
  inline bool SecretsManagerAccessRoleArnHasBeenSet() const { return m_secretsManagerAccessRoleArnHasBeenSet; }
  template <typename SecretsManagerAccessRoleArnT = Aws::String>
  void SetSecretsManagerAccessRoleArn(SecretsManagerAccessRoleArnT&& value) {
    m_secretsManagerAccessRoleArnHasBeenSet = true;
    m_secretsManagerAccessRoleArn = std::forward<SecretsManagerAccessRoleArnT>(value);
  }
  template <typename SecretsManagerAccessRoleArnT = Aws::String>
  DataProviderDescriptorDefinition& WithSecretsManagerAccessRoleArn(SecretsManagerAccessRoleArnT&& value) {
    SetSecretsManagerAccessRoleArn(std::forward<SecretsManagerAccessRoleArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_dataProviderIdentifier;

  Aws::String m_secretsManagerSecretId;

  Aws::String m_secretsManagerAccessRoleArn;
  bool m_dataProviderIdentifierHasBeenSet = false;
  bool m_secretsManagerSecretIdHasBeenSet = false;
  bool m_secretsManagerAccessRoleArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
