%{
#include <stdio.h>
#include <string.h>

void yyerror(const char *str)
{
	fprintf(stderr,"errore: %s\n",str);
}

int yywrap()
{
	return 1;
}

main()
{
	yyparse();
}

char *stufa="default";

%}

%token TOKSTUFA TOKRISCALDAMENTO TOKOBIETTIVO TOKTEMPERATURA

%union
{
        int numero;
        char *stringa;
}

%token <numero> STATO
%token <numero> NUMERO
%token <stringa> PAROLA

%%

comandi:
	| comandi comando
	;


comando:
	interruttore_stufa | imposta_obiettivo | scegli_stufa

interruttore_stufa:
	TOKRISCALDAMENTO STATO 
	{
		if($2)
			printf("\tStufa '%s' accesa\n", stufa);
		else
			printf("\tStufa '%s' spenta\n", stufa);
	}
	;

imposta_obiettivo:
	TOKOBIETTIVO TOKTEMPERATURA NUMERO
	{
		printf("\tPer stufa '%s' temperatura impostata a %d\n",stufa, $3);
	}
	;

scegli_stufa:
	TOKSTUFA PAROLA
	{
		printf("\tScelta stufa '%s'\n",$2);
		stufa=$2;
	}
	;
