/***************************************************************************
                          ksteak.h  -  description
                             -------------------
    begin                : Sat Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTEAK_H
#define KSTEAK_H

#include "dockwidget.h"
#include "engine.h"
#include "ksteakiface.h"

#include <kapp.h>
#include <kmainwindow.h>
#include <kcombobox.h>
#include <ktoolbar.h>
#include <qtextview.h>
#include <kaction.h>
#include <qclipboard.h>
#include <kglobalaccel.h>

class KToggleAction;

/**
  *@author Michael Heidecke
  */

class KSteak : public KMainWindow, public KSteakIface {
  Q_OBJECT
 public:
	KSteak();
	~KSteak();

	dockwidget *SteakDock;

	QColor textColor;
	QColor bgColor;
	QFont mFont;
	QTextView *display;
	QFrame *pMainWidget;
	QClipboard *Cb;
	KGlobalAccel *ga;

	void applyOptions(void);

 public slots:
	virtual bool queryClose() { SaveConfig(); return true; }

 protected:
	void saveProperties(KConfig *);
	/* DCOP capable functions */
	virtual void translate(const QString & szWord);
	virtual void dock();
	virtual void undock();

	/** the translation engine */
	Engine _engine;
	/** flag (application docked to systray?) */
	bool _fDocked;
	//bool _fPopup;	//false = popup at cursor
	bool _fWatch;

	struct ActionGroup
	{
		/* Actions optionsToolBar */
		KToggleAction * WatchCb;
		KToggleAction * English;
		KToggleAction * German;
		KToggleAction * Context;
		KToggleAction * Case;
		KToggleAction * AND;
		KToggleAction * OR;
		KToggleAction * showToolbar;
		KToggleAction * showMenubar;
		/* Actions searchToolbar */
		KAction *clearLine;
		KAction *search;
		KSelectAction *inputLine;
	} actions;


 signals:
	/** Emitted by a DCOP-call forcing a translation */
	void sigDCOPTranslate( const QString & szWord );

 private:
	KConfig *config;

	KToolBar *mToolbar;
	KToolBar *pToolbar;

	void ReadConfig(void);
	void SaveConfig(void);

 private slots:
	void slotAddHistory(const QString &);
	void slotClearLine();
	void slotStartSearch();
	void slotToggleWatch();
	void slotToggleWatchCb();
	void slotToggleEnglish();
	void slotToggleGerman();
	void slotToggleShowContext();
	void slotToggleCaseSensitive();
	void slotToggleAND();
	void slotToggleOR();

	void slotShowToolbar();
	void slotConfigToolbars();
	void slotConfigKeys();
	void slotConfigOptions();

	void slotQuit(void);
	void slotDock(void);
	void slotUndock(void);
	void slotCbChanged(void);

	/** Uses @ref Engine::translatePopup to translate the clipboard-entry. */
	void slotTranslateDocked( const QString & szWord  );
	/**
	* Uses @ref Engine::translate to translate the given word in @ref KSteak::KSteakWidget 's
	* view (@ref Ksteak::ViewSteak ).
	*/
	void slotTranslateUndocked( const QString & szWord );
	/**
	* Uses @ref Engine::translatePopup or @ref Engine::translate to translate
	* the given word depending on the applications current dock-status.
	*/
	void slotTranslateDCOP( const QString & szWord );
};
#endif
