/***************************************************************************
                          scalebaritem.cpp  -  description
                             -------------------
    begin                : Don Jun 12 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "kgraph.h"
#include "kplchecklistitem.h"
#include "scalebardlg.h"
#include "scalebaritem.h"

ScaleBarItem::ScaleBarItem() : orientation(0), len(1.0)
{
}

ScaleBarItem::ScaleBarItem(Kpl::AutoStruct* aut) :
 orientation(0), len(1.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

ScaleBarItem::ScaleBarItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  orientation = plo->readNumEntry("or");
  len = plo->readDoubleNumEntry("len", 1.0);
  s = plo->readEntry("s", "");
}

ScaleBarItem::ScaleBarItem(bool act, const QString& col, const QString& str,
                           double x, double y, int o, double l,
                           double relSize) :
 DecoItem(act, col, x, y, relSize), orientation(o), len(l), s(str)
{
}

ScaleBarItem::~ScaleBarItem()
{
}

KplItem::ItemTypes ScaleBarItem::iType() const
{
  return ScaleBar;
}

void ScaleBarItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColFrame(color);
    double sav = g->setRelSize(relsiz);
    g->scaleBar(s, x0, y0, orientation, len, &bRect);
    g->setRelSize(sav);
  }
}

void ScaleBarItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                         KplDoc* m) const
{
  plo->writeEntry("Type", "SCALEBARITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("or", orientation);
  plo->writeEntry("len", len);
  plo->writeEntry("s", s);
}

void ScaleBarItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Scale bar"));
  QString s;
  it->setText(2, (orientation ? i18n("Vertical") : i18n("Horizontal")) +
              s.sprintf(", x = %g cm, y = %g cm", x0, y0));
}

int ScaleBarItem::editItem(QWidget* parent, KplDoc* m, int)
{
  ScaleBarDlg dlg(parent, m, this);
  return dlg.exec();
}

KplItem* ScaleBarItem::copy() const
{
  return new ScaleBarItem(*this);
}
