/***************************************************************************
                          refreshdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <klocale.h>
#include "kplspinbox.h"
#include "refreshdlg.h"

RefreshDlg::RefreshDlg(QWidget* _parent, bool* _act, int* _tRef) :
 KDialogBase(Plain, QString::null, Ok | Cancel, Ok, _parent, 0, true, true),
 act(_act), tRef(_tRef)
{
  setPlainCaption(i18n("Reload periodically"));
  QFrame* frame = plainPage();
  QHBoxLayout* hbox = new QHBoxLayout(frame, 0, spacingHint());
  hbox->addWidget(new QLabel(i18n("Interval"), frame));
  hbox->addWidget(dt = new KplSpinBox(1, 600, 1, frame));
  dt->setSuffix(" s");
  dt->setValue(*tRef);
  dt->setEnabled(*act);
  hbox->addWidget(activate = new QCheckBox(i18n("Activate"), frame));
  activate->setChecked(*act);
  connect(activate, SIGNAL(toggled(bool)), dt, SLOT(setEnabled(bool)));
}

RefreshDlg::~RefreshDlg()
{
}

void RefreshDlg::slotOk()
{
  *tRef = dt->interpretedValue();
  *act = activate->isChecked();
  accept();
}
