/***************************************************************************
                          arrowdlg.h  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARROWDLG_H
#define ARROWDLG_H

#include <decodlg.h>

class ArrowItem;

/**
  * Arrow settings dialog class. Provides a dialog for the settings
  * of an arrow decoration item.
  * @author Werner Stille
  */
class ArrowDlg : public DecoDlg
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ad pointer to arrow item.
   */
  ArrowDlg(QWidget* parent, KplDoc* model, ArrowItem* ad);
  /** Destructor. */
  ~ArrowDlg();
  /**
   * Creates direction and length entry widgets.
   * @param parent parent widget.
   * @param ad arrow item.
   * @param grid grid layout.
   * @param eDir direction widget.
   * @param eLen length widget.
   */
  static void initPolarEntries(QWidget* parent, ArrowItem* ad,
                               QGridLayout* grid, KplDoubleEdit** eDir,
                               KplDoubleEdit** eLen);

protected:
  /**
   * Copies settings to arrow item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  ArrowItem* ad;
  KplDoubleEdit *eDir, *eLen;

protected slots:
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
