#include "MethodReturnValueBase.h"

MethodReturnValueBase::MethodReturnValueBase(
	Smoke *smoke, 
	const Smoke::Index meth, 
	const Smoke::Stack stack, 
	zval* &retval
) : _smoke(smoke), 
	_method(meth), 
	_stack(stack),
	_retval(retval)
{
	_st.set(_smoke, method().ret);
}

MethodReturnValueBase::~MethodReturnValueBase()
{
}

const Smoke::Method&
MethodReturnValueBase::method()
{
	return _smoke->methods[_method];
}

Smoke::StackItem&
MethodReturnValueBase::item()
{
	return _stack[0];
}

Smoke *
MethodReturnValueBase::smoke()
{
	return _smoke;
}

SmokeType
MethodReturnValueBase::type()
{
	return _st;
}

void
MethodReturnValueBase::next() {}

bool
MethodReturnValueBase::cleanup()
{
	return false;
}

void
MethodReturnValueBase::unsupported()
{
	php_error(E_ERROR, "Cannot handle '%s' as return-type of %s::%s",
	type().name(),
	_smoke->className(method().classId),
	_smoke->methodNames[method().name]);
}

zval*
MethodReturnValueBase::var()
{
	return _retval;
}

