//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    public enum RenameDialog_Mode {
        M_OVERWRITE = 1,
        M_OVERWRITE_ITSELF = 2,
        M_SKIP = 4,
        M_SINGLE = 8,
        M_MULTI = 16,
        M_RESUME = 32,
        M_NORENAME = 64,
    }
    /// <remarks>
    ///  The result of open_RenameDialog().
    ///  </remarks>        <short>    The result of open_RenameDialog().</short>
    public enum RenameDialog_Result {
        R_RESUME = 6,
        R_RESUME_ALL = 7,
        R_OVERWRITE = 4,
        R_OVERWRITE_ALL = 5,
        R_SKIP = 2,
        R_AUTO_SKIP = 3,
        R_RENAME = 1,
        R_CANCEL = 0,
    }
    /// <remarks>
    ///  Identifiers for KIO informational messages.
    ///   </remarks>        <short>    Identifiers for KIO informational messages.</short>
    public enum Info {
        INF_TOTAL_SIZE = 10,
        INF_PROCESSED_SIZE = 11,
        INF_SPEED = 12,
        INF_REDIRECTION = 20,
        INF_MIME_TYPE = 21,
        INF_ERROR_PAGE = 22,
        INF_WARNING = 23,
        INF_GETTING_FILE = 24,
        INF_UNUSED = 25,
        INF_INFOMESSAGE = 26,
        INF_META_DATA = 27,
        INF_NETWORK_STATUS = 28,
        INF_MESSAGEBOX = 29,
        INF_POSITION = 30,
    }
    /// <remarks>
    ///  Identifiers for KIO data messages.
    ///   </remarks>        <short>    Identifiers for KIO data messages.</short>
    public enum Message {
        MSG_DATA = 100,
        MSG_DATA_REQ = 101,
        MSG_ERROR = 102,
        MSG_CONNECTED = 103,
        MSG_FINISHED = 104,
        MSG_STAT_ENTRY = 105,
        MSG_LIST_ENTRIES = 106,
        MSG_RENAMED = 107,
        MSG_RESUME = 108,
        MSG_SLAVE_STATUS = 109,
        MSG_SLAVE_ACK = 110,
        MSG_NET_REQUEST = 111,
        MSG_NET_DROP = 112,
        MSG_NEED_SUBURL_DATA = 113,
        MSG_CANRESUME = 114,
        MSG_AUTH_KEY = 115,
        MSG_DEL_AUTH_KEY = 116,
        MSG_OPENED = 117,
        MSG_WRITTEN = 118,
    }
    public enum SkipDialog_Result {
        S_SKIP = 1,
        S_AUTO_SKIP = 2,
        S_CANCEL = 0,
    }
    /// <remarks>
    ///  Commands that can be invoked by a job.
    ///  (Move this to a non-public header)
    ///    </remarks>        <short>   </short>
    public enum Command {
        CMD_HOST = '0',
        CMD_CONNECT = '1',
        CMD_DISCONNECT = '2',
        CMD_SLAVE_STATUS = '3',
        CMD_SLAVE_CONNECT = '4',
        CMD_SLAVE_HOLD = '5',
        CMD_NONE = 'A',
        CMD_TESTDIR = 'B',
        CMD_GET = 'C',
        CMD_PUT = 'D',
        CMD_STAT = 'E',
        CMD_MIMETYPE = 'F',
        CMD_LISTDIR = 'G',
        CMD_MKDIR = 'H',
        CMD_RENAME = 'I',
        CMD_COPY = 'J',
        CMD_DEL = 'K',
        CMD_CHMOD = 'L',
        CMD_SPECIAL = 'M',
        CMD_SETMODIFICATIONTIME = 'N',
        CMD_REPARSECONFIGURATION = 'O',
        CMD_META_DATA = 'P',
        CMD_SYMLINK = 'Q',
        CMD_SUBURL = 'R',
        CMD_MESSAGEBOXANSWER = 'S',
        CMD_RESUMEANSWER = 'T',
        CMD_CONFIG = 'U',
        CMD_MULTI_GET = 'V',
        CMD_SETLINKDEST = 'W',
        CMD_OPEN = 'X',
        CMD_CHOWN = 'Y',
        CMD_READ = 'Z',
        CMD_WRITE = 91,
        CMD_SEEK = 92,
        CMD_CLOSE = 93,
    }
    /// <remarks>
    ///  Error codes that can be emitted by KIO.
    ///    </remarks>        <short>    Error codes that can be emitted by KIO.</short>
    public enum Error {
        ERR_CANNOT_OPEN_FOR_READING = KJob.UserDefinedError+1,
        ERR_CANNOT_OPEN_FOR_WRITING = KJob.UserDefinedError+2,
        ERR_CANNOT_LAUNCH_PROCESS = KJob.UserDefinedError+3,
        ERR_INTERNAL = KJob.UserDefinedError+4,
        ERR_MALFORMED_URL = KJob.UserDefinedError+5,
        ERR_UNSUPPORTED_PROTOCOL = KJob.UserDefinedError+6,
        ERR_NO_SOURCE_PROTOCOL = KJob.UserDefinedError+7,
        ERR_UNSUPPORTED_ACTION = KJob.UserDefinedError+8,
        ERR_IS_DIRECTORY = KJob.UserDefinedError+9,
        ERR_IS_FILE = KJob.UserDefinedError+10,
        ERR_DOES_NOT_EXIST = KJob.UserDefinedError+11,
        ERR_FILE_ALREADY_EXIST = KJob.UserDefinedError+12,
        ERR_DIR_ALREADY_EXIST = KJob.UserDefinedError+13,
        ERR_UNKNOWN_HOST = KJob.UserDefinedError+14,
        ERR_ACCESS_DENIED = KJob.UserDefinedError+15,
        ERR_WRITE_ACCESS_DENIED = KJob.UserDefinedError+16,
        ERR_CANNOT_ENTER_DIRECTORY = KJob.UserDefinedError+17,
        ERR_PROTOCOL_IS_NOT_A_FILESYSTEM = KJob.UserDefinedError+18,
        ERR_CYCLIC_LINK = KJob.UserDefinedError+19,
        ERR_USER_CANCELED = KJob.KilledJobError,
        ERR_CYCLIC_COPY = KJob.UserDefinedError+21,
        ERR_COULD_NOT_CREATE_SOCKET = KJob.UserDefinedError+22,
        ERR_COULD_NOT_CONNECT = KJob.UserDefinedError+23,
        ERR_CONNECTION_BROKEN = KJob.UserDefinedError+24,
        ERR_NOT_FILTER_PROTOCOL = KJob.UserDefinedError+25,
        ERR_COULD_NOT_MOUNT = KJob.UserDefinedError+26,
        ERR_COULD_NOT_UNMOUNT = KJob.UserDefinedError+27,
        ERR_COULD_NOT_READ = KJob.UserDefinedError+28,
        ERR_COULD_NOT_WRITE = KJob.UserDefinedError+29,
        ERR_COULD_NOT_BIND = KJob.UserDefinedError+30,
        ERR_COULD_NOT_LISTEN = KJob.UserDefinedError+31,
        ERR_COULD_NOT_ACCEPT = KJob.UserDefinedError+32,
        ERR_COULD_NOT_LOGIN = KJob.UserDefinedError+33,
        ERR_COULD_NOT_STAT = KJob.UserDefinedError+34,
        ERR_COULD_NOT_CLOSEDIR = KJob.UserDefinedError+35,
        ERR_COULD_NOT_MKDIR = KJob.UserDefinedError+37,
        ERR_COULD_NOT_RMDIR = KJob.UserDefinedError+38,
        ERR_CANNOT_RESUME = KJob.UserDefinedError+39,
        ERR_CANNOT_RENAME = KJob.UserDefinedError+40,
        ERR_CANNOT_CHMOD = KJob.UserDefinedError+41,
        ERR_CANNOT_DELETE = KJob.UserDefinedError+42,
        ERR_SLAVE_DIED = KJob.UserDefinedError+43,
        ERR_OUT_OF_MEMORY = KJob.UserDefinedError+44,
        ERR_UNKNOWN_PROXY_HOST = KJob.UserDefinedError+45,
        ERR_COULD_NOT_AUTHENTICATE = KJob.UserDefinedError+46,
        ERR_ABORTED = KJob.UserDefinedError+47,
        ERR_INTERNAL_SERVER = KJob.UserDefinedError+48,
        ERR_SERVER_TIMEOUT = KJob.UserDefinedError+49,
        ERR_SERVICE_NOT_AVAILABLE = KJob.UserDefinedError+50,
        ERR_UNKNOWN = KJob.UserDefinedError+51,
        ERR_UNKNOWN_INTERRUPT = KJob.UserDefinedError+53,
        ERR_CANNOT_DELETE_ORIGINAL = KJob.UserDefinedError+54,
        ERR_CANNOT_DELETE_PARTIAL = KJob.UserDefinedError+55,
        ERR_CANNOT_RENAME_ORIGINAL = KJob.UserDefinedError+56,
        ERR_CANNOT_RENAME_PARTIAL = KJob.UserDefinedError+57,
        ERR_NEED_PASSWD = KJob.UserDefinedError+58,
        ERR_CANNOT_SYMLINK = KJob.UserDefinedError+59,
        ERR_NO_CONTENT = KJob.UserDefinedError+60,
        ERR_DISK_FULL = KJob.UserDefinedError+61,
        ERR_IDENTICAL_FILES = KJob.UserDefinedError+62,
        ERR_SLAVE_DEFINED = KJob.UserDefinedError+63,
        ERR_UPGRADE_REQUIRED = KJob.UserDefinedError+64,
        ERR_POST_DENIED = KJob.UserDefinedError+65,
        ERR_COULD_NOT_SEEK = KJob.UserDefinedError+66,
        ERR_CANNOT_SETTIME = KJob.UserDefinedError+67,
        ERR_CANNOT_CHOWN = KJob.UserDefinedError+68,
    }
    /// <remarks>
    ///  Specifies how to use the cache.
    /// </remarks>        <short>    Specifies how to use the cache.</short>
    ///         <see> parseCacheControl</see>
    ///         <see> getCacheControlString</see>
    public enum CacheControl {
        CC_CacheOnly = 0,
        CC_Cache = 1,
        CC_Verify = 2,
        CC_Refresh = 3,
        CC_Reload = 4,
    }
    /// <remarks>
    ///  Flags for the job properties.
    ///  Not all flags are supported in all cases. Please see documentation of
    ///  the calling function!
    ///      </remarks>        <short>    Flags for the job properties.</short>
    public enum JobFlag {
        DefaultFlags = 0,
        HideProgressInfo = 1,
        Resume = 2,
        Overwrite = 4,
    }
    /// <remarks> HTTP / DAV method *</remarks>        <short>   HTTP / DAV method  </short>
    public enum HTTP_METHOD {
        HTTP_GET = 0,
        HTTP_PUT = 1,
        HTTP_POST = 2,
        HTTP_HEAD = 3,
        HTTP_DELETE = 4,
        HTTP_OPTIONS = 5,
        DAV_PROPFIND = 6,
        DAV_PROPPATCH = 7,
        DAV_MKCOL = 8,
        DAV_COPY = 9,
        DAV_MOVE = 10,
        DAV_LOCK = 11,
        DAV_UNLOCK = 12,
        DAV_SEARCH = 13,
        DAV_SUBSCRIBE = 14,
        DAV_UNSUBSCRIBE = 15,
        DAV_POLL = 16,
        DAV_NOTIFY = 17,
        HTTP_UNKNOWN = -1,
    }
    public enum LoadType {
        Reload = 0,
        NoReload = 1,
    }
    /// <remarks>
    ///  </remarks>        <short> A namespace for KIO globals.</short>
    [SmokeClass("KIO")]
    public class Global {
        private static SmokeInvocation staticInterceptor = null;
        static Global() {
            staticInterceptor = new SmokeInvocation(typeof(Global), null);
        }
        /// <remarks>
        ///  Pastes the content of the clipboard to the given destination URL.
        ///  URLs are treated separately (performing a file copy)
        ///  from other data (which is saved into a file after asking the user
        ///  to choose a filename and the preferred data format)
        /// <param> name="destURL" the URL to receive the data
        /// </param><param> name="widget" parent widget to use for dialogs
        /// </param><param> name="move" true to move the data, false to copy
        /// </param></remarks>        <return> the job that handles the operation
        /// </return>
        ///         <short>    Pastes the content of the clipboard to the given destination URL.</short>
        ///         <see> pasteData</see>
        public static KIO.Job PasteClipboard(KUrl destURL, QWidget widget, bool move) {
            return (KIO.Job) staticInterceptor.Invoke("pasteClipboard##$", "pasteClipboard(const KUrl&, QWidget*, bool)", typeof(KIO.Job), typeof(KUrl), destURL, typeof(QWidget), widget, typeof(bool), move);
        }
        public static KIO.Job PasteClipboard(KUrl destURL, QWidget widget) {
            return (KIO.Job) staticInterceptor.Invoke("pasteClipboard##", "pasteClipboard(const KUrl&, QWidget*)", typeof(KIO.Job), typeof(KUrl), destURL, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Pastes the given <code>data</code> to the given destination URL.
        ///  NOTE: This method is blocking (uses NetAccess for saving the data).
        ///  Please consider using pasteDataAsync instead.
        /// <param> name="destURL" the URL of the directory where the data will be pasted.
        ///  The filename to use in that directory is prompted by this method.
        /// </param><param> name="data" the data to copy
        /// </param><param> name="widget" parent widget to use for dialogs
        /// </param></remarks>        <short>    Pastes the given <code>data</code> to the given destination URL.</short>
        ///         <see> pasteClipboard</see>
        public static void PasteData(KUrl destURL, QByteArray data, QWidget widget) {
            staticInterceptor.Invoke("pasteData###", "pasteData(const KUrl&, const QByteArray&, QWidget*)", typeof(void), typeof(KUrl), destURL, typeof(QByteArray), data, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Pastes the given <code>data</code> to the given destination URL.
        ///  Note that this method requires the caller to have chosen the QByteArray
        ///  to paste before hand, unlike pasteClipboard and pasteMimeSource.
        /// <param> name="destURL" the URL of the directory where the data will be pasted.
        ///  The filename to use in that directory is prompted by this method.
        /// </param><param> name="data" the data to copy
        /// </param><param> name="dialogText" the text to show in the dialog
        /// </param></remarks>        <short>    Pastes the given <code>data</code> to the given destination URL.</short>
        ///         <see> pasteClipboard</see>
        public static KIO.CopyJob PasteDataAsync(KUrl destURL, QByteArray data, QWidget widget, string dialogText) {
            return (KIO.CopyJob) staticInterceptor.Invoke("pasteDataAsync###$", "pasteDataAsync(const KUrl&, const QByteArray&, QWidget*, const QString&)", typeof(KIO.CopyJob), typeof(KUrl), destURL, typeof(QByteArray), data, typeof(QWidget), widget, typeof(string), dialogText);
        }
        public static KIO.CopyJob PasteDataAsync(KUrl destURL, QByteArray data, QWidget widget) {
            return (KIO.CopyJob) staticInterceptor.Invoke("pasteDataAsync###", "pasteDataAsync(const KUrl&, const QByteArray&, QWidget*)", typeof(KIO.CopyJob), typeof(KUrl), destURL, typeof(QByteArray), data, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Save the given mimesource <code>data</code> to the given destination URL
        ///  after offering the user to choose a data format.
        ///  This is the method used when handling drops (of anything else than URLs)
        ///  onto kdesktop and konqueror.
        /// <param> name="data" the QMimeData (from a QDropEvent or from the clipboard when pasting)
        /// </param><param> name="destURL" the URL of the directory where the data will be pasted.
        ///  The filename to use in that directory is prompted by this method.
        /// </param><param> name="dialogText" the text to show in the dialog
        /// </param><param> name="widget" parent widget to use for dialogs
        /// </param><param> name="clipboard" whether the QMimeSource comes from QClipboard. If you
        ///  use pasteClipboard for that case, you never have to worry about this parameter.
        /// </param></remarks>        <short>    Save the given mimesource <code>data</code> to the given destination URL  after offering the user to choose a data format.</short>
        ///         <see> pasteClipboard</see>
        public static KIO.CopyJob PasteMimeSource(QMimeData data, KUrl destURL, string dialogText, QWidget widget, bool clipboard) {
            return (KIO.CopyJob) staticInterceptor.Invoke("pasteMimeSource##$#$", "pasteMimeSource(const QMimeData*, const KUrl&, const QString&, QWidget*, bool)", typeof(KIO.CopyJob), typeof(QMimeData), data, typeof(KUrl), destURL, typeof(string), dialogText, typeof(QWidget), widget, typeof(bool), clipboard);
        }
        public static KIO.CopyJob PasteMimeSource(QMimeData data, KUrl destURL, string dialogText, QWidget widget) {
            return (KIO.CopyJob) staticInterceptor.Invoke("pasteMimeSource##$#", "pasteMimeSource(const QMimeData*, const KUrl&, const QString&, QWidget*)", typeof(KIO.CopyJob), typeof(QMimeData), data, typeof(KUrl), destURL, typeof(string), dialogText, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Returns the text to use for the Paste action, when the application supports
        ///  pasting files, urls, and clipboard data, using pasteClipboard().
        /// </remarks>        <return> a string suitable for KAction.SetText, or an empty string if pasting
        ///  isn't possible right now.
        ///    </return>
        ///         <short>    Returns the text to use for the Paste action, when the application supports  pasting files, urls, and clipboard data, using pasteClipboard().</short>
        public static string PasteActionText() {
            return (string) staticInterceptor.Invoke("pasteActionText", "pasteActionText()", typeof(string));
        }
        /// <remarks>
        ///  Creates a new DavJob that issues a PROPFIND command. PROPFIND retrieves
        ///  the properties of the resource identified by the given <code>url.</code>
        /// <param> name="url" the URL of the resource
        /// </param><param> name="properties" a propfind document that describes the properties that
        ///         should be retrieved
        /// </param><param> name="depth" the depth of the request. Can be "0", "1" or "infinity"
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the new DavJob
        ///     </return>
        ///         <short>    Creates a new DavJob that issues a PROPFIND command.</short>
        public static KIO.DavJob DavPropFind(KUrl url, QDomDocument properties, string depth, uint flags) {
            return (KIO.DavJob) staticInterceptor.Invoke("davPropFind##$$", "davPropFind(const KUrl&, const QDomDocument&, const QString&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(string), depth, typeof(uint), flags);
        }
        public static KIO.DavJob DavPropFind(KUrl url, QDomDocument properties, string depth) {
            return (KIO.DavJob) staticInterceptor.Invoke("davPropFind##$", "davPropFind(const KUrl&, const QDomDocument&, const QString&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(string), depth);
        }
        /// <remarks>
        ///  Creates a new DavJob that issues a PROPPATCH command. PROPPATCH sets
        ///  the properties of the resource identified by the given <code>url.</code>
        /// <param> name="url" the URL of the resource
        /// </param><param> name="properties" a PROPPACTCH document that describes the properties that
        ///         should be modified and its new values
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the new DavJob
        ///     </return>
        ///         <short>    Creates a new DavJob that issues a PROPPATCH command.</short>
        public static KIO.DavJob DavPropPatch(KUrl url, QDomDocument properties, uint flags) {
            return (KIO.DavJob) staticInterceptor.Invoke("davPropPatch##$", "davPropPatch(const KUrl&, const QDomDocument&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(uint), flags);
        }
        public static KIO.DavJob DavPropPatch(KUrl url, QDomDocument properties) {
            return (KIO.DavJob) staticInterceptor.Invoke("davPropPatch##", "davPropPatch(const KUrl&, const QDomDocument&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties);
        }
        /// <remarks>
        ///  Creates a new DavJob that issues a SEARCH command.
        /// <param> name="url" the URL of the resource
        /// </param><param> name="nsURI" the URI of the search method's qualified name
        /// </param><param> name="qName" the local part of the search method's qualified name
        /// </param><param> name="query" the search string
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the new DavJob
        ///     </return>
        ///         <short>    Creates a new DavJob that issues a SEARCH command.</short>
        public static KIO.DavJob DavSearch(KUrl url, string nsURI, string qName, string query, uint flags) {
            return (KIO.DavJob) staticInterceptor.Invoke("davSearch#$$$$", "davSearch(const KUrl&, const QString&, const QString&, const QString&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(string), nsURI, typeof(string), qName, typeof(string), query, typeof(uint), flags);
        }
        public static KIO.DavJob DavSearch(KUrl url, string nsURI, string qName, string query) {
            return (KIO.DavJob) staticInterceptor.Invoke("davSearch#$$$", "davSearch(const KUrl&, const QString&, const QString&, const QString&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(string), nsURI, typeof(string), qName, typeof(string), query);
        }
        /// <remarks>
        ///  Creates a PreviewJob to generate or retrieve a preview image
        ///  for the given URL.
        /// <param> name="items" files to get previews for
        /// </param><param> name="width" the maximum width to use
        /// </param><param> name="height" the maximum height to use, if this is 0, the same
        ///  value as width is used.
        /// </param><param> name="iconSize" the size of the mimetype icon to overlay over the
        ///  preview or zero to not overlay an icon. This has no effect if the
        ///  preview plugin that will be used doesn't use icon overlays.
        /// </param><param> name="iconAlpha" transparency to use for the icon overlay
        /// </param><param> name="scale" if the image is to be scaled to the requested size or
        ///  returned in its original size
        /// </param><param> name="save" if the image should be cached for later use
        /// </param><param> name="enabledPlugins" if non-zero, this points to a list containing
        ///  the names of the plugins that may be used.
        /// </param></remarks>        <return> the new PreviewJob
        /// </return>
        ///         <short>    Creates a PreviewJob to generate or retrieve a preview image  for the given URL.</short>
        ///         <see> PreviewJob.AvailablePlugins</see>
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save, List<string> enabledPlugins) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$$?", "filePreview(const KFileItemList&, int, int, int, int, bool, bool, const QStringList*)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save, typeof(List<string>), enabledPlugins);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$$", "filePreview(const KFileItemList&, int, int, int, int, bool, bool)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$", "filePreview(const KFileItemList&, int, int, int, int, bool)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$", "filePreview(const KFileItemList&, int, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$", "filePreview(const KFileItemList&, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$", "filePreview(const KFileItemList&, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height);
        }
        public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$", "filePreview(const KFileItemList&, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width);
        }
        /// <remarks>
        ///  Creates a PreviewJob to generate or retrieve a preview image
        ///  for the given URL.
        /// <param> name="items" files to get previews for
        /// </param><param> name="width" the maximum width to use
        /// </param><param> name="height" the maximum height to use, if this is 0, the same
        ///  value as width is used.
        /// </param><param> name="iconSize" the size of the mimetype icon to overlay over the
        ///  preview or zero to not overlay an icon. This has no effect if the
        ///  preview plugin that will be used doesn't use icon overlays.
        /// </param><param> name="iconAlpha" transparency to use for the icon overlay
        /// </param><param> name="scale" if the image is to be scaled to the requested size or
        ///  returned in its original size
        /// </param><param> name="save" if the image should be cached for later use
        /// </param><param> name="enabledPlugins" if non-zero, this points to a list containing
        ///  the names of the plugins that may be used.
        /// </param></remarks>        <return> the new PreviewJob
        /// </return>
        ///         <short>    Creates a PreviewJob to generate or retrieve a preview image  for the given URL.</short>
        ///         <see> PreviewJob.AvailablePlugins</see>
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save, List<string> enabledPlugins) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$$?", "filePreview(const KUrl::List&, int, int, int, int, bool, bool, const QStringList*)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save, typeof(List<string>), enabledPlugins);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$$", "filePreview(const KUrl::List&, int, int, int, int, bool, bool)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$", "filePreview(const KUrl::List&, int, int, int, int, bool)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$", "filePreview(const KUrl::List&, int, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$", "filePreview(const KUrl::List&, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$", "filePreview(const KUrl::List&, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height);
        }
        public static KIO.PreviewJob FilePreview(List<KUrl> items, int width) {
            return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$", "filePreview(const KUrl::List&, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width);
        }
        /// <remarks>
        ///  Retrieves meta information for the given items.
        /// <param> name="items" files to get metainfo for
        /// </param></remarks>        <return> the MetaInfoJob to retrieve the items
        ///      </return>
        ///         <short>    Retrieves meta information for the given items.</short>
        public static KIO.MetaInfoJob FileMetaInfo(List<KFileItem> items) {
            return (KIO.MetaInfoJob) staticInterceptor.Invoke("fileMetaInfo#", "fileMetaInfo(const KFileItemList&)", typeof(KIO.MetaInfoJob), typeof(List<KFileItem>), items);
        }
        /// <remarks>
        ///  Retrieves meta information for the given items.
        /// <param> name="items" files to get metainfo for
        /// </param></remarks>        <return> the MetaInfoJob to retrieve the items
        ///      </return>
        ///         <short>    Retrieves meta information for the given items.</short>
        public static KIO.MetaInfoJob FileMetaInfo(List<KUrl> items) {
            return (KIO.MetaInfoJob) staticInterceptor.Invoke("fileMetaInfo?", "fileMetaInfo(const KUrl::List&)", typeof(KIO.MetaInfoJob), typeof(List<KUrl>), items);
        }
        public static QDataStream Write(QDataStream s, KIO.AuthInfo a) {
            return (QDataStream) staticInterceptor.Invoke("operator<<##", "operator<<(QDataStream&, const KIO::AuthInfo&)", typeof(QDataStream), typeof(QDataStream), s, typeof(KIO.AuthInfo), a);
        }
        public static QDataStream Read(QDataStream s, KIO.AuthInfo a) {
            return (QDataStream) staticInterceptor.Invoke("operator>>##", "operator>>(QDataStream&, KIO::AuthInfo&)", typeof(QDataStream), typeof(QDataStream), s, typeof(KIO.AuthInfo), a);
        }
        /// <remarks>
        ///  Converts <code>size</code> from bytes to the string representation.
        /// <param> name="size" size in bytes
        /// </param></remarks>        <return> converted size as a string - e.g. 123.4 KiB , 12.0 MiB
        ///    </return>
        ///         <short>    Converts <code>size</code> from bytes to the string representation.</short>
        public static string ConvertSize(long size) {
            return (string) staticInterceptor.Invoke("convertSize$", "convertSize(KIO::filesize_t)", typeof(string), typeof(long), size);
        }
        /// <remarks>
        ///  Converts a size to a string representation
        ///  Not unlike string.Number(...)
        /// <param> name="size" size in bytes
        /// </param></remarks>        <return> converted size as a string - e.g. 123456789
        ///    </return>
        ///         <short>    Converts a size to a string representation  Not unlike string.Number(.</short>
        public static string Number(long size) {
            return (string) staticInterceptor.Invoke("number$", "number(KIO::filesize_t)", typeof(string), typeof(long), size);
        }
        /// <remarks>
        ///  Converts size from kibi-bytes (2^10) to the string representation.
        /// <param> name="kibSize" size in kibi-bytes (2^10)
        /// </param></remarks>        <return> converted size as a string - e.g. 123.4 KiB , 12.0 MiB
        ///    </return>
        ///         <short>    Converts size from kibi-bytes (2^10) to the string representation.</short>
        public static string ConvertSizeFromKiB(long kibSize) {
            return (string) staticInterceptor.Invoke("convertSizeFromKiB$", "convertSizeFromKiB(KIO::filesize_t)", typeof(string), typeof(long), kibSize);
        }
        /// <remarks>
        ///  Calculates remaining time in seconds from total size, processed size and speed.
        /// <param> name="totalSize" total size in bytes
        /// </param><param> name="processedSize" processed size in bytes
        /// </param><param> name="speed" speed in bytes per second
        /// </param></remarks>        <return> calculated remaining time in seconds
        ///    </return>
        ///         <short>    Calculates remaining time in seconds from total size, processed size and speed.</short>
        public static uint CalculateRemainingSeconds(long totalSize, long processedSize, long speed) {
            return (uint) staticInterceptor.Invoke("calculateRemainingSeconds$$$", "calculateRemainingSeconds(KIO::filesize_t, KIO::filesize_t, KIO::filesize_t)", typeof(uint), typeof(long), totalSize, typeof(long), processedSize, typeof(long), speed);
        }
        /// <remarks>
        ///  Convert <code>seconds</code> to a string representing number of days, hours, minutes and seconds
        /// <param> name="seconds" number of seconds to convert
        /// </param></remarks>        <return> string representation in a locale depending format
        ///    </return>
        ///         <short>    Convert <code>seconds</code> to a string representing number of days, hours, minutes and seconds </short>
        public static string ConvertSeconds(uint seconds) {
            return (string) staticInterceptor.Invoke("convertSeconds$", "convertSeconds(unsigned int)", typeof(string), typeof(uint), seconds);
        }
        /// <remarks>
        ///  Calculates remaining time from total size, processed size and speed.
        ///  Warning: As QTime is limited to 23:59:59, use calculateRemainingSeconds() instead
        /// <param> name="totalSize" total size in bytes
        /// </param><param> name="processedSize" processed size in bytes
        /// </param><param> name="speed" speed in bytes per second
        /// </param></remarks>        <return> calculated remaining time
        ///    </return>
        ///         <short>    Calculates remaining time from total size, processed size and speed.</short>
        public static QTime CalculateRemaining(long totalSize, long processedSize, long speed) {
            return (QTime) staticInterceptor.Invoke("calculateRemaining$$$", "calculateRemaining(KIO::filesize_t, KIO::filesize_t, KIO::filesize_t)", typeof(QTime), typeof(long), totalSize, typeof(long), processedSize, typeof(long), speed);
        }
        /// <remarks>
        ///  Helper for showing information about a set of files and directories
        /// <param> name="items" the number of items (= <code>files</code> + <code>dirs</code> + number of symlinks :)
        /// </param><param> name="files" the number of files
        /// </param><param> name="dirs" the number of dirs
        /// </param><param> name="size" the sum of the size of the <code>files</code>
        /// </param><param> name="showSize" whether to show the size in the result
        /// </param></remarks>        <return> the summary string
        ///    </return>
        ///         <short>    Helper for showing information about a set of files and directories </short>
        public static string ItemsSummaryString(uint items, uint files, uint dirs, long size, bool showSize) {
            return (string) staticInterceptor.Invoke("itemsSummaryString$$$$$", "itemsSummaryString(uint, uint, uint, KIO::filesize_t, bool)", typeof(string), typeof(uint), items, typeof(uint), files, typeof(uint), dirs, typeof(long), size, typeof(bool), showSize);
        }
        /// <remarks>
        ///  Encodes (from the text displayed to the real filename)
        ///  This translates % into %% and / into %2f
        ///  Used by KIO.Link, for instance.
        /// <param> name="str" the file name to encode
        /// </param></remarks>        <return> the encoded file name
        ///    </return>
        ///         <short>    Encodes (from the text displayed to the real filename)  This translates % into %% and / into %2f  Used by KIO.Link, for instance.</short>
        public static string EncodeFileName(string str) {
            return (string) staticInterceptor.Invoke("encodeFileName$", "encodeFileName(const QString&)", typeof(string), typeof(string), str);
        }
        /// <remarks>
        ///  Decodes (from the filename to the text displayed)
        ///  This translates %2[fF] into / and %% into %
        /// <param> name="str" the file name to decode
        /// </param></remarks>        <return> the decoded file name
        ///    </return>
        ///         <short>    Decodes (from the filename to the text displayed)  This translates %2[fF] into / and %% into % </short>
        public static string DecodeFileName(string str) {
            return (string) staticInterceptor.Invoke("decodeFileName$", "decodeFileName(const QString&)", typeof(string), typeof(string), str);
        }
        /// <remarks>
        ///  Returns a translated error message for <code>errorCode</code> using the
        ///  additional error information provided by <code>errorText.</code>
        /// <param> name="errorCode" the error code
        /// </param><param> name="errorText" the additional error text
        /// </param></remarks>        <return> the created error string
        ///    </return>
        ///         <short>    Returns a translated error message for <code>errorCode</code> using the  additional error information provided by <code>errorText.</code></short>
        public static string BuildErrorString(int errorCode, string errorText) {
            return (string) staticInterceptor.Invoke("buildErrorString$$", "buildErrorString(int, const QString&)", typeof(string), typeof(int), errorCode, typeof(string), errorText);
        }
        /// <remarks>
        ///  Returns translated error details for <code>errorCode</code> using the
        ///  additional error information provided by <code>errorText</code> , <code>reqUrl</code>
        ///  (the request URL), and the ioslave <code>method</code> .
        /// <param> name="errorCode" the error code
        /// </param><param> name="errorText" the additional error text
        /// </param><param> name="reqUrl" the request URL
        /// </param><param> name="method" the ioslave method
        /// </param>
        /// <li>
        /// string errorName - the name of the error
        /// </li>
        /// 
        /// <li>
        /// string techName - if not null, the more technical name of the error
        /// </li>
        /// 
        /// <li>
        /// string description - a description of the error
        /// </li>
        /// 
        /// <li>
        /// List<string> causes - a list of possible causes of the error
        /// </li>
        /// 
        /// <li>
        /// List<string> solutions - a liso of solutions for the error
        ///    
        /// </li></remarks>        <return> the following data:
        /// </return>
        ///         <short>    Returns translated error details for <code>errorCode</code> using the  additional error information provided by <code>errorText</code> , <code>reqUrl</code>  (the request URL), and the ioslave <code>method</code> .</short>
        public static QByteArray RawErrorDetail(int errorCode, string errorText, KUrl reqUrl, int method) {
            return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$#$", "rawErrorDetail(int, const QString&, const KUrl*, int)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText, typeof(KUrl), reqUrl, typeof(int), method);
        }
        public static QByteArray RawErrorDetail(int errorCode, string errorText, KUrl reqUrl) {
            return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$#", "rawErrorDetail(int, const QString&, const KUrl*)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText, typeof(KUrl), reqUrl);
        }
        public static QByteArray RawErrorDetail(int errorCode, string errorText) {
            return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$", "rawErrorDetail(int, const QString&)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText);
        }
        /// <remarks>
        ///  Returns an appropriate error message if the given command <code>cmd</code>
        ///  is an unsupported action (ERR_UNSUPPORTED_ACTION).
        /// <param> name="protocol" name of the protocol
        /// </param><param> name="cmd" given command
        /// </param></remarks>        <short>    Returns an appropriate error message if the given command <code>cmd</code>  is an unsupported action (ERR_UNSUPPORTED_ACTION).</short>
        ///         <see> enum</see>
        ///         <see> Command</see>
        public static string UnsupportedActionErrorString(string protocol, int cmd) {
            return (string) staticInterceptor.Invoke("unsupportedActionErrorString$$", "unsupportedActionErrorString(const QString&, int)", typeof(string), typeof(string), protocol, typeof(int), cmd);
        }
        /// <remarks>
        ///  Parses the string representation of the cache control option.
        /// <param> name="cacheControl" the string representation
        /// </param></remarks>        <return> the cache control value
        /// </return>
        ///         <short>    Parses the string representation of the cache control option.</short>
        ///         <see> getCacheControlString</see>
        public static KIO.CacheControl ParseCacheControl(string cacheControl) {
            return (KIO.CacheControl) staticInterceptor.Invoke("parseCacheControl$", "parseCacheControl(const QString&)", typeof(KIO.CacheControl), typeof(string), cacheControl);
        }
        /// <remarks>
        ///  Returns a string representation of the given cache control method.
        /// <param> name="cacheControl" the cache control method
        /// </param></remarks>        <return> the string representation
        /// </return>
        ///         <short>    Returns a string representation of the given cache control method.</short>
        ///         <see> parseCacheControl</see>
        public static string GetCacheControlString(KIO.CacheControl cacheControl) {
            return (string) staticInterceptor.Invoke("getCacheControlString$", "getCacheControlString(KIO::CacheControl)", typeof(string), typeof(KIO.CacheControl), cacheControl);
        }
        /// <remarks>
        ///  Convenience method to find the pixmap for a URL.
        ///  Call this one when you don't know the mimetype.
        /// <param> name="_url" URL for the file.
        /// </param><param> name="_mode" the mode of the file. The mode may modify the icon
        ///               with overlays that show special properties of the
        ///               icon. Use 0 for default
        /// </param><param> name="_group" The icon group where the icon is going to be used.
        /// </param><param> name="_force_size" Override globally configured icon size.
        ///         Use 0 for the default size
        /// </param><param> name="_state" The icon state, one of: KIconLoader.DefaultState,
        ///  KIconLoader.ActiveState or KIconLoader.DisabledState.
        /// </param><param> name="_path" Output parameter to get the full path. Seldom needed.
        ///               Ignored if 0
        /// </param></remarks>        <return> the pixmap of the URL, can be a default icon if not found
        ///    </return>
        ///         <short>    Convenience method to find the pixmap for a URL.</short>
        public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size, int _state, StringBuilder _path) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int, int, QString*)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size, typeof(int), _state, typeof(StringBuilder), _path);
        }
        public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size, int _state) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int, int)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size, typeof(int), _state);
        }
        public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size);
        }
        public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group);
        }
        public static QPixmap PixmapForUrl(KUrl _url, long _mode) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$", "pixmapForUrl(const KUrl&, mode_t)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode);
        }
        public static QPixmap PixmapForUrl(KUrl _url) {
            return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#", "pixmapForUrl(const KUrl&)", typeof(QPixmap), typeof(KUrl), _url);
        }
        public static KJobTrackerInterface GetJobTracker() {
            return (KJobTrackerInterface) staticInterceptor.Invoke("getJobTracker", "getJobTracker()", typeof(KJobTrackerInterface));
        }
        /// <remarks>
        ///  Computes a directory size (by doing a recursive listing).
        ///  Connect to the result signal. Use NetAccess.SynchronousRun for a synchronous version.
        ///  This one lists a single directory.
        ///  </remarks>        <short>    Computes a directory size (by doing a recursive listing).</short>
        public static KIO.DirectorySizeJob DirectorySize(KUrl directory) {
            return (KIO.DirectorySizeJob) staticInterceptor.Invoke("directorySize#", "directorySize(const KUrl&)", typeof(KIO.DirectorySizeJob), typeof(KUrl), directory);
        }
        /// <remarks>
        ///  Computes a directory size (by doing a recursive listing).
        ///  Connect to the result signal. Use NetAccess.SynchronousRun for a synchronous version.
        ///  This one lists the items from <code>lstItems.</code>
        ///  The reason we asks for items instead of just urls, is so that
        ///  we directly know if the item is a file or a directory,
        ///  and in case of a file, we already have its size.
        ///  </remarks>        <short>    Computes a directory size (by doing a recursive listing).</short>
        public static KIO.DirectorySizeJob DirectorySize(List<KFileItem> lstItems) {
            return (KIO.DirectorySizeJob) staticInterceptor.Invoke("directorySize#", "directorySize(const KFileItemList&)", typeof(KIO.DirectorySizeJob), typeof(List<KFileItem>), lstItems);
        }
        /// <remarks>
        ///  Delete a file or directory.
        /// <param> name="src" file to delete
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Delete a file or directory.</short>
        public static KIO.DeleteJob Del(KUrl src, uint flags) {
            return (KIO.DeleteJob) staticInterceptor.Invoke("del#$", "del(const KUrl&, KIO::JobFlags)", typeof(KIO.DeleteJob), typeof(KUrl), src, typeof(uint), flags);
        }
        public static KIO.DeleteJob Del(KUrl src) {
            return (KIO.DeleteJob) staticInterceptor.Invoke("del#", "del(const KUrl&)", typeof(KIO.DeleteJob), typeof(KUrl), src);
        }
        /// <remarks>
        ///  Deletes a list of files or directories.
        /// <param> name="src" the files to delete
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Deletes a list of files or directories.</short>
        public static KIO.DeleteJob Del(List<KUrl> src, uint flags) {
            return (KIO.DeleteJob) staticInterceptor.Invoke("del?$", "del(const KUrl::List&, KIO::JobFlags)", typeof(KIO.DeleteJob), typeof(List<KUrl>), src, typeof(uint), flags);
        }
        public static KIO.DeleteJob Del(List<KUrl> src) {
            return (KIO.DeleteJob) staticInterceptor.Invoke("del?", "del(const KUrl::List&)", typeof(KIO.DeleteJob), typeof(List<KUrl>), src);
        }
        /// <remarks>
        ///  Creates a single directory.
        /// <param> name="url" The URL of the directory to create.
        /// </param><param> name="permissions" The permissions to set after creating the
        ///                     directory (unix-style), -1 for default permissions.
        /// </param></remarks>        <return> A pointer to the job handling the operation.
        ///      </return>
        ///         <short>    Creates a single directory.</short>
        public static KIO.SimpleJob Mkdir(KUrl url, int permissions) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("mkdir#$", "mkdir(const KUrl&, int)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(int), permissions);
        }
        public static KIO.SimpleJob Mkdir(KUrl url) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("mkdir#", "mkdir(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Removes a single directory.
        ///  The directory is assumed to be empty.
        /// <param> name="url" The URL of the directory to remove.
        /// </param></remarks>        <return> A pointer to the job handling the operation.
        ///      </return>
        ///         <short>    Removes a single directory.</short>
        public static KIO.SimpleJob Rmdir(KUrl url) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("rmdir#", "rmdir(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Changes permissions on a file or directory.
        ///  See the other chmod below for changing many files
        ///  or directories.
        /// <param> name="url" The URL of file or directory.
        /// </param><param> name="permissions" The permissions to set.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Changes permissions on a file or directory.</short>
        public static KIO.SimpleJob Chmod(KUrl url, int permissions) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("chmod#$", "chmod(const KUrl&, int)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(int), permissions);
        }
        /// <remarks>
        ///  Changes ownership and group of a file or directory.
        /// <param> name="url" The URL of file or directory.
        /// </param><param> name="owner" the new owner
        /// </param><param> name="group" the new group
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Changes ownership and group of a file or directory.</short>
        public static KIO.SimpleJob Chown(KUrl url, string owner, string group) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("chown#$$", "chown(const KUrl&, const QString&, const QString&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(string), owner, typeof(string), group);
        }
        /// <remarks>
        ///  Changes the modification time on a file or directory.
        /// <param> name="url" The URL of file or directory.
        /// </param><param> name="permissions" The permissions to set.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Changes the modification time on a file or directory.</short>
        public static KIO.SimpleJob SetModificationTime(KUrl url, QDateTime mtime) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("setModificationTime##", "setModificationTime(const KUrl&, const QDateTime&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QDateTime), mtime);
        }
        /// <remarks>
        ///  Rename a file or directory.
        ///  Warning: this operation fails if a direct renaming is not
        ///  possible (like with files or dirs on separate partitions)
        ///  Use move or file_move in this case.
        /// <param> name="src" The original URL
        /// </param><param> name="dest" The final URL
        /// </param><param> name="flags" Can be Overwrite here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Rename a file or directory.</short>
        public static KIO.SimpleJob Rename(KUrl src, KUrl dest, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("rename##$", "rename(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.SimpleJob Rename(KUrl src, KUrl dest) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("rename##", "rename(const KUrl&, const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Create or move a symlink.
        ///  This is the lowlevel operation, similar to file_copy and file_move.
        ///  It doesn't do any check (other than those the slave does)
        ///  and it doesn't show rename and skip dialogs - use KIO.Link for that.
        /// <param> name="target" The string that will become the "target" of the link (can be relative)
        /// </param><param> name="dest" The symlink to create.
        /// </param><param> name="flags" Can be Overwrite and HideProgressInfo
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Create or move a symlink.</short>
        public static KIO.SimpleJob Symlink(string target, KUrl dest, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("symlink$#$", "symlink(const QString&, const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(string), target, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.SimpleJob Symlink(string target, KUrl dest) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("symlink$#", "symlink(const QString&, const KUrl&)", typeof(KIO.SimpleJob), typeof(string), target, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Execute any command that is specific to one slave (protocol).
        ///  Examples are : HTTP POST, mount and unmount (kio_file)
        /// <param> name="url" The URL isn't passed to the slave, but is used to know
        ///         which slave to send it to :-)
        /// </param><param> name="data" Packed data.  The meaning is completely dependent on the
        ///         slave, but usually starts with an int for the command number.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Execute any command that is specific to one slave (protocol).</short>
        public static KIO.SimpleJob Special(KUrl url, QByteArray data, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("special##$", "special(const KUrl&, const QByteArray&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QByteArray), data, typeof(uint), flags);
        }
        public static KIO.SimpleJob Special(KUrl url, QByteArray data) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("special##", "special(const KUrl&, const QByteArray&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Mount filesystem.
        ///  Special job for <code>kio_file.</code>
        /// <param> name="ro" Mount read-only if <code>true.</code>
        /// </param><param> name="fstype" File system type (e.g. "ext2", can be empty).
        /// </param><param> name="dev" Device (e.g. /dev/sda0).
        /// </param><param> name="point" Mount point, can be <code>null.</code>
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Mount filesystem.</short>
        public static KIO.SimpleJob Mount(bool ro, QByteArray fstype, string dev, string point, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("mount$#$$$", "mount(bool, const QByteArray&, const QString&, const QString&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(bool), ro, typeof(QByteArray), fstype, typeof(string), dev, typeof(string), point, typeof(uint), flags);
        }
        public static KIO.SimpleJob Mount(bool ro, QByteArray fstype, string dev, string point) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("mount$#$$", "mount(bool, const QByteArray&, const QString&, const QString&)", typeof(KIO.SimpleJob), typeof(bool), ro, typeof(QByteArray), fstype, typeof(string), dev, typeof(string), point);
        }
        /// <remarks>
        ///  Unmount filesystem.
        ///  Special job for <code>kio_file.</code>
        /// <param> name="point" Point to unmount.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Unmount filesystem.</short>
        public static KIO.SimpleJob Unmount(string point, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("unmount$$", "unmount(const QString&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(string), point, typeof(uint), flags);
        }
        public static KIO.SimpleJob Unmount(string point) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("unmount$", "unmount(const QString&)", typeof(KIO.SimpleJob), typeof(string), point);
        }
        /// <remarks>
        ///  HTTP cache update
        /// <param> name="url" Url to update, protocol must be "http".
        /// </param><param> name="no_cache" If true, cache entry for <code>url</code> is deleted.
        /// </param><param> name="expireDate" Local machine time indicating when the entry is
        ///  supposed to expire.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    HTTP cache update </short>
        public static KIO.SimpleJob Http_update_cache(KUrl url, bool no_cache, int expireDate) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("http_update_cache#$$", "http_update_cache(const KUrl&, bool, time_t)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(bool), no_cache, typeof(int), expireDate);
        }
        /// <remarks>
        ///  Find all details for one file or directory.
        /// <param> name="url" the URL of the file
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Find all details for one file or directory.</short>
        public static KIO.StatJob Stat(KUrl url, uint flags) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#$", "stat(const KUrl&, KIO::JobFlags)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(uint), flags);
        }
        public static KIO.StatJob Stat(KUrl url) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#", "stat(const KUrl&)", typeof(KIO.StatJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Find all details for one file or directory.
        ///  This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>
        /// <param> name="url" the URL of the file
        /// </param><param> name="side" is SourceSide when stating a source file (we will do a get on it if
        ///  the stat works) and DestinationSide when stating a destination file (target of a copy).
        ///  The reason for this parameter is that in some cases the kioslave might not
        ///  be able to determine a file's existence (e.g. HTTP doesn't allow it, FTP
        ///  has issues with case-sensitivity on some systems).
        ///  When the slave can't reliably determine the existence of a file, it will:
        /// </param>
        /// <li>
        /// be optimistic if SourceSide, i.e. it will assume the file exists,
        ///  and if it doesn't this will appear when actually trying to download it
        /// </li>
        /// 
        /// <li>
        /// be pessimistic if DestinationSide, i.e. it will assume the file
        ///  doesn't exist, to prevent showing "about to overwrite" errors to the user.
        ///  If you simply want to check for existence without downloading/uploading afterwards,
        ///  then you should use DestinationSide.
        /// </li>
        /// <param> name="details" selects the level of details we want.
        ///  By default this is 2 (all details wanted, including modification time, size, etc.),
        ///  setDetails(1) is used when deleting: we don't need all the information if it takes
        ///  too much time, no need to follow symlinks etc.
        ///  setDetails(0) is used for very simple probing: we'll only get the answer
        ///  "it's a file or a directory, or it doesn't exist". This is used by KRun.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Find all details for one file or directory.</short>
        public static KIO.StatJob Stat(KUrl url, KIO.StatJob.StatSide side, short details, uint flags) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#$$$", "stat(const KUrl&, KIO::StatJob::StatSide, short int, KIO::JobFlags)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(KIO.StatJob.StatSide), side, typeof(short), details, typeof(uint), flags);
        }
        public static KIO.StatJob Stat(KUrl url, KIO.StatJob.StatSide side, short details) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#$$", "stat(const KUrl&, KIO::StatJob::StatSide, short int)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(KIO.StatJob.StatSide), side, typeof(short), details);
        }
        /// <remarks>
        ///  Find all details for one file or directory.
        ///  This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>
        /// <param> name="url" the URL of the file
        /// </param><param> name="sideIsSource" is true when stating a source file (we will do a get on it if
        ///  the stat works) and false when stating a destination file (target of a copy).
        ///  The reason for this parameter is that in some cases the kioslave might not
        ///  be able to determine a file's existence (e.g. HTTP doesn't allow it, FTP
        ///  has issues with case-sensitivity on some systems).
        ///  When the slave can't reliably determine the existence of a file, it will:
        /// </param>
        /// <li>
        /// be optimistic if sideIsSource=true, i.e. it will assume the file exists,
        ///  and if it doesn't this will appear when actually trying to download it
        /// </li>
        /// 
        /// <li>
        /// be pessimistic if sideIsSource=false, i.e. it will assume the file
        ///  doesn't exist, to prevent showing "about to overwrite" errors to the user.
        ///  If you simply want to check for existence without downloading/uploading afterwards,
        ///  then you should use sideIsSource=false.
        /// </li>
        /// <param> name="details" selects the level of details we want.
        ///  By default this is 2 (all details wanted, including modification time, size, etc.),
        ///  setDetails(1) is used when deleting: we don't need all the information if it takes
        ///  too much time, no need to follow symlinks etc.
        ///  setDetails(0) is used for very simple probing: we'll only get the answer
        ///  "it's a file or a directory, or it doesn't exist". This is used by KRun.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Find all details for one file or directory.</short>
        public static KIO.StatJob Stat(KUrl url, bool sideIsSource, short details, uint flags) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#$$$", "stat(const KUrl&, bool, short int, KIO::JobFlags)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(bool), sideIsSource, typeof(short), details, typeof(uint), flags);
        }
        public static KIO.StatJob Stat(KUrl url, bool sideIsSource, short details) {
            return (KIO.StatJob) staticInterceptor.Invoke("stat#$$", "stat(const KUrl&, bool, short int)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(bool), sideIsSource, typeof(short), details);
        }
        /// <remarks>
        ///  Get (a.k.a. read).
        ///  The slave emits the data through data().
        /// <param> name="url" the URL of the file
        /// </param><param> name="reload" : Reload to reload the file, NoReload if it can be taken from the cache
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Get (a.</short>
        public static KIO.TransferJob Get(KUrl url, KIO.LoadType reload, uint flags) {
            return (KIO.TransferJob) staticInterceptor.Invoke("get#$$", "get(const KUrl&, KIO::LoadType, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload, typeof(uint), flags);
        }
        public static KIO.TransferJob Get(KUrl url, KIO.LoadType reload) {
            return (KIO.TransferJob) staticInterceptor.Invoke("get#$", "get(const KUrl&, KIO::LoadType)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload);
        }
        public static KIO.TransferJob Get(KUrl url) {
            return (KIO.TransferJob) staticInterceptor.Invoke("get#", "get(const KUrl&)", typeof(KIO.TransferJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Open ( random access I/O )
        ///  The file-job emits open() when opened
        /// <param> name="url" the URL of the file
        /// </param><param> name="mode" the access privileges: see \ref OpenMode
        /// </param></remarks>        <return> The file-handling job. It will never return 0. Errors are handled asynchronously
        ///  (emitted as signals).
        ///      </return>
        ///         <short>    Open ( random access I/O ) </short>
        public static KIO.FileJob Open(KUrl url, uint mode) {
            return (KIO.FileJob) staticInterceptor.Invoke("open#$", "open(const KUrl&, QIODevice::OpenMode)", typeof(KIO.FileJob), typeof(KUrl), url, typeof(uint), mode);
        }
        /// <remarks>
        ///  Put (a.k.a. write)
        /// <param> name="url" Where to write data.
        /// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
        ///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
        /// </param></remarks>        <return> the job handling the operation.
        /// </return>
        ///         <short>    Put (a.</short>
        ///         <see> multi_get</see>
        public static KIO.TransferJob Put(KUrl url, int permissions, uint flags) {
            return (KIO.TransferJob) staticInterceptor.Invoke("put#$$", "put(const KUrl&, int, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
        }
        public static KIO.TransferJob Put(KUrl url, int permissions) {
            return (KIO.TransferJob) staticInterceptor.Invoke("put#$", "put(const KUrl&, int)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(int), permissions);
        }
        /// <remarks>
        ///  HTTP POST (for form data).
        ///  Example:
        ///  <pre>
        ///     job = KIO.Http_post( url, postData, KIO.HideProgressInfo );
        ///     job.AddMetaData("content-type", contentType );
        ///     job.AddMetaData("referrer", referrerURL);
        ///  </pre>
        ///  <code>postData</code> is the data that you want to send and
        ///  <code>contentType</code> is the complete HTTP header line that
        ///  specifies the content's MIME type, for example
        ///  "Content-Type: text/xml".
        ///  You MUST specify content-type!
        ///  Often <code>contentType</code> is
        ///  "Content-Type: application/x-www-form-urlencoded" and
        ///  the <code>postData</code> is then an ASCII string (without null-termination!)
        ///  with characters like space, linefeed and percent escaped like %20,
        ///  %0A and %25.
        /// <param> name="url" Where to write the data.
        /// </param><param> name="postData" Encoded data to post.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    HTTP POST (for form data).</short>
        public static KIO.TransferJob Http_post(KUrl url, QByteArray postData, uint flags) {
            return (KIO.TransferJob) staticInterceptor.Invoke("http_post##$", "http_post(const KUrl&, const QByteArray&, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(QByteArray), postData, typeof(uint), flags);
        }
        public static KIO.TransferJob Http_post(KUrl url, QByteArray postData) {
            return (KIO.TransferJob) staticInterceptor.Invoke("http_post##", "http_post(const KUrl&, const QByteArray&)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(QByteArray), postData);
        }
        /// <remarks>
        ///  Get (a.k.a. read), into a single QByteArray.
        /// <param> name="url" the URL of the file
        /// </param><param> name="reload" : Reload to reload the file, NoReload if it can be taken from the cache
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Get (a.</short>
        ///         <see> StoredTransferJob</see>
        public static KIO.StoredTransferJob StoredGet(KUrl url, KIO.LoadType reload, uint flags) {
            return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#$$", "storedGet(const KUrl&, KIO::LoadType, KIO::JobFlags)", typeof(KIO.StoredTransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload, typeof(uint), flags);
        }
        public static KIO.StoredTransferJob StoredGet(KUrl url, KIO.LoadType reload) {
            return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#$", "storedGet(const KUrl&, KIO::LoadType)", typeof(KIO.StoredTransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload);
        }
        public static KIO.StoredTransferJob StoredGet(KUrl url) {
            return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#", "storedGet(const KUrl&)", typeof(KIO.StoredTransferJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Put (a.k.a. write) data from a single QByteArray.
        /// <param> name="arr" The data to write
        /// </param><param> name="url" Where to write data.
        /// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
        ///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Put (a.</short>
        ///         <see> StoredTransferJob</see>
        public static KIO.StoredTransferJob StoredPut(QByteArray arr, KUrl url, int permissions, uint flags) {
            return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedPut##$$", "storedPut(const QByteArray&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.StoredTransferJob), typeof(QByteArray), arr, typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
        }
        public static KIO.StoredTransferJob StoredPut(QByteArray arr, KUrl url, int permissions) {
            return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedPut##$", "storedPut(const QByteArray&, const KUrl&, int)", typeof(KIO.StoredTransferJob), typeof(QByteArray), arr, typeof(KUrl), url, typeof(int), permissions);
        }
        /// <remarks>
        ///  Creates a new multiple get job.
        /// <param> name="id" the id of the get operation
        /// </param><param> name="url" the URL of the file
        /// </param><param> name="metaData" the MetaData associated with the file
        /// </param></remarks>        <return> the job handling the operation.
        /// </return>
        ///         <short>    Creates a new multiple get job.</short>
        ///         <see> get</see>
        public static KIO.MultiGetJob Multi_get(long id, KUrl url, KIO.MetaData metaData) {
            return (KIO.MultiGetJob) staticInterceptor.Invoke("multi_get$##", "multi_get(long, const KUrl&, const KIO::MetaData&)", typeof(KIO.MultiGetJob), typeof(long), id, typeof(KUrl), url, typeof(KIO.MetaData), metaData);
        }
        /// <remarks>
        ///  Find mimetype for one file or directory.
        /// <param> name="url" the URL of the file
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Find mimetype for one file or directory.</short>
        public static KIO.MimetypeJob Mimetype(KUrl url, uint flags) {
            return (KIO.MimetypeJob) staticInterceptor.Invoke("mimetype#$", "mimetype(const KUrl&, KIO::JobFlags)", typeof(KIO.MimetypeJob), typeof(KUrl), url, typeof(uint), flags);
        }
        public static KIO.MimetypeJob Mimetype(KUrl url) {
            return (KIO.MimetypeJob) staticInterceptor.Invoke("mimetype#", "mimetype(const KUrl&)", typeof(KIO.MimetypeJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Copy a single file.
        ///  Uses either SlaveBase.Copy() if the slave supports that
        ///  or get() and put() otherwise.
        /// <param> name="src" Where to get the file.
        /// </param><param> name="dest" Where to put the file.
        /// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
        ///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Copy a single file.</short>
        public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest, int permissions, uint flags) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##$$", "file_copy(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
        }
        public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest, int permissions) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##$", "file_copy(const KUrl&, const KUrl&, int)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions);
        }
        public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##", "file_copy(const KUrl&, const KUrl&)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Move a single file.
        ///  Use either SlaveBase.Rename() if the slave supports that,
        ///  or copy() and del() otherwise, or eventually get() & put() & del()
        /// <param> name="src" Where to get the file.
        /// </param><param> name="dest" Where to put the file.
        /// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
        ///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Move a single file.</short>
        public static KIO.FileCopyJob File_move(KUrl src, KUrl dest, int permissions, uint flags) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##$$", "file_move(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
        }
        public static KIO.FileCopyJob File_move(KUrl src, KUrl dest, int permissions) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##$", "file_move(const KUrl&, const KUrl&, int)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions);
        }
        public static KIO.FileCopyJob File_move(KUrl src, KUrl dest) {
            return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##", "file_move(const KUrl&, const KUrl&)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Delete a single file.
        /// <param> name="src" File to delete.
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    Delete a single file.</short>
        public static KIO.SimpleJob File_delete(KUrl src, uint flags) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("file_delete#$", "file_delete(const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(uint), flags);
        }
        public static KIO.SimpleJob File_delete(KUrl src) {
            return (KIO.SimpleJob) staticInterceptor.Invoke("file_delete#", "file_delete(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), src);
        }
        /// <remarks>
        ///  List the contents of <code>url</code>, which is assumed to be a directory.
        ///  "." and ".." are returned, filter them out if you don't want them.
        /// <param> name="url" the url of the directory
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param><param> name="includeHidden" true for all files, false to cull out UNIX hidden
        ///                       files/dirs (whose names start with dot)
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    List the contents of <code>url</code>, which is assumed to be a directory.</short>
        public static KIO.ListJob ListDir(KUrl url, uint flags, bool includeHidden) {
            return (KIO.ListJob) staticInterceptor.Invoke("listDir#$$", "listDir(const KUrl&, KIO::JobFlags, bool)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags, typeof(bool), includeHidden);
        }
        public static KIO.ListJob ListDir(KUrl url, uint flags) {
            return (KIO.ListJob) staticInterceptor.Invoke("listDir#$", "listDir(const KUrl&, KIO::JobFlags)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags);
        }
        public static KIO.ListJob ListDir(KUrl url) {
            return (KIO.ListJob) staticInterceptor.Invoke("listDir#", "listDir(const KUrl&)", typeof(KIO.ListJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  The same as the previous method, but recurses subdirectories.
        ///  Directory links are not followed.
        ///  "." and ".." are returned but only for the toplevel directory.
        ///  Filter them out if you don't want them.
        /// <param> name="url" the url of the directory
        /// </param><param> name="flags" Can be HideProgressInfo here
        /// </param><param> name="includeHidden" true for all files, false to cull out UNIX hidden
        ///                       files/dirs (whose names start with dot)
        /// </param></remarks>        <return> the job handling the operation.
        ///      </return>
        ///         <short>    The same as the previous method, but recurses subdirectories.</short>
        public static KIO.ListJob ListRecursive(KUrl url, uint flags, bool includeHidden) {
            return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#$$", "listRecursive(const KUrl&, KIO::JobFlags, bool)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags, typeof(bool), includeHidden);
        }
        public static KIO.ListJob ListRecursive(KUrl url, uint flags) {
            return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#$", "listRecursive(const KUrl&, KIO::JobFlags)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags);
        }
        public static KIO.ListJob ListRecursive(KUrl url) {
            return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#", "listRecursive(const KUrl&)", typeof(KIO.ListJob), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Copy a file or directory <code>src</code> into the destination <code>dest</code>,
        ///  which can be a file (including the final filename) or a directory
        ///  (into which <code>src</code> will be copied).
        ///  This emulates the cp command completely.
        /// <param> name="src" the file or directory to copy
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which can be a file (including the final filename) or a directory  (into which <code>src</code> will be copied).</short>
        ///         <see> copyAs</see>
        public static KIO.CopyJob Copy(KUrl src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copy##$", "copy(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob Copy(KUrl src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copy##", "copy(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Copy a file or directory <code>src</code> into the destination <code>dest</code>,
        ///  which is the destination name in any case, even for a directory.
        ///  As opposed to copy(), this doesn't emulate cp, but is the only
        ///  way to copy a directory, giving it a new name and getting an error
        ///  box if a directory already exists with the same name.
        /// <param> name="src" the file or directory to copy
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which is the destination name in any case, even for a directory.</short>
        public static KIO.CopyJob CopyAs(KUrl src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copyAs##$", "copyAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob CopyAs(KUrl src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copyAs##", "copyAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>
        /// <param> name="src" the list of files and/or directories
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code></short>
        public static KIO.CopyJob Copy(List<KUrl> src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copy?#$", "copy(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob Copy(List<KUrl> src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("copy?#", "copy(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Moves a file or directory <code>src</code> to the given destination <code>dest.</code>
        /// <param> name="src" the file or directory to copy
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Moves a file or directory <code>src</code> to the given destination <code>dest.</code></short>
        ///         <see> copy</see>
        ///         <see> moveAs</see>
        public static KIO.CopyJob Move(KUrl src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("move##$", "move(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob Move(KUrl src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("move##", "move(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Moves a file or directory <code>src</code> to the given destination <code>dest.</code> Unlike move()
        ///  this operation will fail when the directory already exists.
        /// <param> name="src" the file or directory to copy
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Moves a file or directory <code>src</code> to the given destination <code>dest.</code></short>
        ///         <see> copyAs</see>
        public static KIO.CopyJob MoveAs(KUrl src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("moveAs##$", "moveAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob MoveAs(KUrl src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("moveAs##", "moveAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code>
        /// <param> name="src" the list of files or directories to copy
        /// </param><param> name="dest" the destination
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code></short>
        ///         <see> copy</see>
        public static KIO.CopyJob Move(List<KUrl> src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("move?#$", "move(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob Move(List<KUrl> src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("move?#", "move(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Create a link.
        ///  If the protocols and hosts are the same, a Unix symlink will be created.
        ///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
        /// <param> name="src" The existing file or directory, 'target' of the link.
        /// </param><param> name="destDir" Destination directory where the link will be created.
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Create a link.</short>
        public static KIO.CopyJob Link(KUrl src, KUrl destDir, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("link##$", "link(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), destDir, typeof(uint), flags);
        }
        public static KIO.CopyJob Link(KUrl src, KUrl destDir) {
            return (KIO.CopyJob) staticInterceptor.Invoke("link##", "link(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), destDir);
        }
        /// <remarks>
        ///  Create several links
        ///  If the protocols and hosts are the same, a Unix symlink will be created.
        ///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
        /// <param> name="src" The existing files or directories, 'targets' of the link.
        /// </param><param> name="destDir" Destination directory where the links will be created.
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Create several links  If the protocols and hosts are the same, a Unix symlink will be created.</short>
        ///         <see> link</see>
        public static KIO.CopyJob Link(List<KUrl> src, KUrl destDir, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("link?#$", "link(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), destDir, typeof(uint), flags);
        }
        public static KIO.CopyJob Link(List<KUrl> src, KUrl destDir) {
            return (KIO.CopyJob) staticInterceptor.Invoke("link?#", "link(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), destDir);
        }
        /// <remarks>
        ///  Create a link. Unlike link() this operation will fail when the directory already
        ///  exists.
        ///  If the protocols and hosts are the same, a Unix symlink will be created.
        ///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
        /// <param> name="src" The existing file or directory, 'target' of the link.
        /// </param><param> name="dest" Destination directory where the link will be created.
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        /// </return>
        ///         <short>    Create a link.</short>
        ///         <see> link</see>
        ///         <see> copyAs</see>
        public static KIO.CopyJob LinkAs(KUrl src, KUrl dest, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("linkAs##$", "linkAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        public static KIO.CopyJob LinkAs(KUrl src, KUrl dest) {
            return (KIO.CopyJob) staticInterceptor.Invoke("linkAs##", "linkAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
        }
        /// <remarks>
        ///  Trash a file or directory.
        ///  This is currently only supported for local files and directories.
        ///  Use "KUrl src; src.setPath( path );" to create a URL from a path.
        /// <param> name="src" file to delete
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Trash a file or directory.</short>
        public static KIO.CopyJob Trash(KUrl src, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("trash#$", "trash(const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(uint), flags);
        }
        public static KIO.CopyJob Trash(KUrl src) {
            return (KIO.CopyJob) staticInterceptor.Invoke("trash#", "trash(const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src);
        }
        /// <remarks>
        ///  Trash a list of files or directories.
        ///  This is currently only supported for local files and directories.
        /// <param> name="src" the files to delete
        /// </param><param> name="flags" : We support HideProgressInfo here
        /// </param></remarks>        <return> the job handling the operation
        ///      </return>
        ///         <short>    Trash a list of files or directories.</short>
        public static KIO.CopyJob Trash(List<KUrl> src, uint flags) {
            return (KIO.CopyJob) staticInterceptor.Invoke("trash?$", "trash(const KUrl::List&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(uint), flags);
        }
        public static KIO.CopyJob Trash(List<KUrl> src) {
            return (KIO.CopyJob) staticInterceptor.Invoke("trash?", "trash(const KUrl::List&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src);
        }
    }
}
