/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.qtproject.qt5.android.CachedDocumentFile;
import org.qtproject.qt5.android.ContentUriPermission;
import org.qtproject.qt5.android.FileError;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.SAFFile;
import org.qtproject.qt5.android.SAFUtils;

public class SAFFileManager {
    private static final String TAG = "SAFFileManager";
    private static final String PATH_TREE = "tree";
    @SuppressLint(value={"StaticFieldLeak"})
    private static SAFFileManager sSafFileManager;
    private final Context mCtx;
    private final HashMap<Uri, CachedDocumentFile> mCachedDocumentFiles = new HashMap();
    private final HashMap<Integer, ParcelFileDescriptor> m_parcelFileDescriptors = new HashMap();
    private final FileError mError = new FileError();
    private List<ContentUriPermission> mCachedPermissions = new ArrayList<ContentUriPermission>();
    private final ArrayList<Uri> mCachedListDocumentFiles = new ArrayList();

    SAFFileManager(Context context) {
        this.mCtx = context;
    }

    public static SAFFileManager instance() {
        if (sSafFileManager == null) {
            sSafFileManager = new SAFFileManager(QtNative.getContext());
        }
        return sSafFileManager;
    }

    public static SAFFileManager instance(Context context) {
        if (sSafFileManager == null) {
            sSafFileManager = new SAFFileManager(context);
        }
        return sSafFileManager;
    }

    private boolean checkImplicitUriPermission(Uri uri, String string2) {
        int n = 0;
        if (string2.startsWith("r")) {
            n = 1;
        }
        if (!"r".equals(string2)) {
            n |= 2;
        }
        return this.mCtx.checkCallingOrSelfUriPermission(uri, n) == 0;
    }

    void resetCachedPermission() {
        List list = this.mCtx.getContentResolver().getPersistedUriPermissions();
        for (UriPermission uriPermission : list) {
            this.mCachedPermissions.add(new ContentUriPermission(uriPermission.getUri(), uriPermission.isReadPermission(), uriPermission.isWritePermission()));
        }
    }

    Uri getProperlyEncodedUriWithPermissions(Uri uri, String string2) {
        if (this.mCachedPermissions.isEmpty()) {
            this.resetCachedPermission();
        }
        String string3 = uri.getPath();
        for (int i = 0; i < this.mCachedPermissions.size(); ++i) {
            Uri uri2 = this.mCachedPermissions.get(i).getUri();
            boolean bl = this.mCachedPermissions.get(i).isReadPermission();
            if (!string2.equals("r")) {
                bl = this.mCachedPermissions.get(i).isWritePermission();
            }
            if (!uri2.getPath().equals(string3) || !bl) continue;
            return uri2;
        }
        return QtNative.activity() != null && QtNative.activity().getIntent() != null && this.checkImplicitUriPermission(uri, string2) ? uri : null;
    }

    private CachedDocumentFile getDocumentFileWithValidPermissions(String string2, String string3, boolean bl) {
        Uri uri = Uri.parse((String)string2);
        if (this.isTreeUri(uri)) {
            SAFFile sAFFile = this.nearestTreeUri(uri);
            if (sAFFile == null) {
                this.mError.setError(13);
                this.mError.setErrorString("No permission to access the Document Tree");
                return null;
            }
            CachedDocumentFile cachedDocumentFile = this.findFileInTree(sAFFile);
            if (cachedDocumentFile != null) {
                return cachedDocumentFile;
            }
            if ("r".equals(string3) || bl) {
                return null;
            }
            return this.createFile(sAFFile, false);
        }
        Uri uri2 = this.getProperlyEncodedUriWithPermissions(uri, string3);
        if (uri2 != null) {
            return CachedDocumentFile.fromFileUri(this.mCtx, uri2);
        }
        this.mError.setError(13);
        this.mError.setErrorString("No permission to access the Uri");
        return null;
    }

    private CachedDocumentFile getDocumentFileWithValidPermissions(String string2, String string3) {
        return this.getDocumentFileWithValidPermissions(string2, string3, false);
    }

    private boolean launchUri(String string2, String string3) {
        Uri uri;
        if (string2.startsWith("content:")) {
            uri = this.getDocumentFileWithValidPermissions(string2, "r").getUri();
            if (uri == null) {
                Log.e((String)TAG, (String)"launchUri(): No permissions to open Uri");
                return false;
            }
        } else {
            uri = Uri.parse((String)string2);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(1);
            if (!string3.isEmpty()) {
                intent.setDataAndType(uri, string3);
            }
            QtNative.activity().startActivity(intent);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)"launchUri(): Invalid Uri");
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)TAG, (String)"launchUri(): Unsupported operation for given Uri");
            return false;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            activityNotFoundException.printStackTrace();
            return false;
        }
    }

    public synchronized int openFileDescriptor(String string2, String string3) {
        for (int i = 0; i < 2; ++i) {
            CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, string3);
            if (cachedDocumentFile == null) {
                return -1;
            }
            try {
                ContentResolver contentResolver = this.mCtx.getContentResolver();
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(cachedDocumentFile.getUri(), string3);
                this.m_parcelFileDescriptors.put(parcelFileDescriptor.getFd(), parcelFileDescriptor);
                this.mError.unsetError();
                return parcelFileDescriptor.getFd();
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("openFileDescriptor(): Failed query: " + exception));
                this.mCachedDocumentFiles.remove(cachedDocumentFile.getUri());
                continue;
            }
        }
        this.mError.setError(2);
        this.mError.setErrorString("Couldn't open file for writing");
        return -1;
    }

    public boolean closeFileDescriptor(int n) {
        ParcelFileDescriptor parcelFileDescriptor = this.m_parcelFileDescriptors.get(n);
        if (parcelFileDescriptor == null) {
            Log.wtf((String)TAG, (String)"File descriptor doesn't exist in cache");
            return false;
        }
        try {
            this.mError.unsetError();
            parcelFileDescriptor.close();
            return true;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"closeFileDescriptor(): Failed to close the FD", (Throwable)iOException);
            this.mError.setUnknownError();
            return false;
        }
    }

    public long getSize(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "r");
        if (cachedDocumentFile != null) {
            return cachedDocumentFile.getSize();
        }
        this.mError.setUnknownError();
        return 0L;
    }

    public boolean exists(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "r");
        if (cachedDocumentFile != null && cachedDocumentFile.exists()) {
            this.mError.unsetError();
            return true;
        }
        return false;
    }

    public boolean canWrite(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "w", true);
        if (cachedDocumentFile != null) {
            if (cachedDocumentFile.canWrite()) {
                this.mError.unsetError();
                return true;
            }
            if (SAFFileManager.isArc()) {
                return true;
            }
        }
        return false;
    }

    public String getFileName(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "r");
        if (cachedDocumentFile != null) {
            this.mError.unsetError();
            return cachedDocumentFile.getName();
        }
        return null;
    }

    private String stringJoin(String string2, List<String> list) {
        if (list.size() < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i)).append(string2);
        }
        stringBuilder.delete(stringBuilder.length() - string2.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    private Uri uriAppend(Uri uri, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(uri.toString());
        for (String string2 : list) {
            stringBuilder.append(Uri.encode((String)File.separator)).append(string2);
        }
        return Uri.parse((String)stringBuilder.toString());
    }

    private SAFFile nearestTreeUri(Uri uri) {
        List list = uri.getPathSegments();
        List list2 = list.subList(1, list.size());
        for (int i = list2.size(); i > 0; --i) {
            Uri uri2 = new Uri.Builder().scheme("content").authority(uri.getAuthority()).appendPath(PATH_TREE).appendPath((String)list2.get(0)).build();
            Uri uri3 = this.getProperlyEncodedUriWithPermissions(this.uriAppend(uri2, list2.subList(1, i)), "rw");
            if (uri3 == null) continue;
            if (i < list2.size()) {
                return new SAFFile(uri3, list2.subList(i, list2.size()));
            }
            return new SAFFile(uri3, new ArrayList<String>());
        }
        Log.d((String)TAG, (String)("nearestTreeUri(): No permissions to Uri: " + uri));
        return null;
    }

    public synchronized boolean delete(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "rw", true);
        if (cachedDocumentFile == null) {
            return false;
        }
        this.mCachedDocumentFiles.remove(cachedDocumentFile.getUri());
        if (cachedDocumentFile.isDirectory()) {
            this.invalidateCachedDocuments(cachedDocumentFile.getUri());
        }
        return this.deleteFile(cachedDocumentFile.getUri());
    }

    public String[] listFileNames(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "r");
        if (cachedDocumentFile == null || !cachedDocumentFile.isDirectory()) {
            return null;
        }
        List<CachedDocumentFile> list = this.listFiles(cachedDocumentFile.getUri());
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CachedDocumentFile cachedDocumentFile2 = list.get(i);
            stringArray[i] = cachedDocumentFile2.getName();
            this.mCachedDocumentFiles.put(cachedDocumentFile2.getUri(), cachedDocumentFile2);
            this.mCachedListDocumentFiles.add(cachedDocumentFile2.getUri());
        }
        return stringArray;
    }

    void resetListCache() {
        for (Uri uri : this.mCachedListDocumentFiles) {
            this.mCachedDocumentFiles.remove(uri);
        }
        this.mCachedListDocumentFiles.clear();
    }

    private void invalidateCachedDocuments(Uri uri) {
        String string2 = uri.getLastPathSegment();
        Iterator<Map.Entry<Uri, CachedDocumentFile>> iterator = this.mCachedDocumentFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Uri, CachedDocumentFile> entry = iterator.next();
            if (!entry.getKey().getPath().contains(string2)) continue;
            iterator.remove();
        }
    }

    public boolean isDir(String string2) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "rw", true);
        if (cachedDocumentFile == null) {
            return false;
        }
        this.mError.unsetError();
        return cachedDocumentFile.isDirectory();
    }

    private boolean isTreeUri(Uri uri) {
        if (Build.VERSION.SDK_INT >= 24) {
            return DocumentsContract.isTreeUri((Uri)uri);
        }
        List list = uri.getPathSegments();
        return list.size() >= 2 && PATH_TREE.equals(list.get(0));
    }

    public boolean isTreeUri(String string2) {
        return this.isTreeUri(Uri.parse((String)string2));
    }

    public synchronized boolean rename(String string2, String string3) {
        CachedDocumentFile cachedDocumentFile = this.getDocumentFileWithValidPermissions(string2, "rw", true);
        if (cachedDocumentFile == null) {
            return false;
        }
        Uri uri = cachedDocumentFile.getUri();
        if (cachedDocumentFile.rename(string3)) {
            this.mCachedDocumentFiles.remove(uri);
            this.invalidateCachedDocuments(uri);
            this.mCachedDocumentFiles.put(cachedDocumentFile.getUri(), cachedDocumentFile);
            this.resetCachedPermission();
            return true;
        }
        return false;
    }

    public synchronized boolean mkdir(String string2, boolean bl) {
        if (this.isDir(string2)) {
            return true;
        }
        Uri uri = Uri.parse((String)string2);
        if (uri.getPathSegments().size() > 3 && !bl) {
            return false;
        }
        SAFFile sAFFile = this.nearestTreeUri(uri);
        if (sAFFile == null) {
            this.mError.setError(13);
            this.mError.setErrorString("No permission to access the Document Tree");
            return false;
        }
        if (this.createDirectories(sAFFile) != null) {
            this.mError.unsetError();
            return true;
        }
        return false;
    }

    Uri createDirectories(SAFFile sAFFile) {
        Uri uri = sAFFile.getBaseUri();
        List<String> list = sAFFile.getSegments();
        Log.d((String)TAG, (String)("Creating directory: " + uri.toString() + ", segments = " + this.stringJoin("/", list)));
        Uri uri2 = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)DocumentsContract.getTreeDocumentId((Uri)uri));
        for (String string2 : list) {
            CachedDocumentFile cachedDocumentFile = this.findFile(uri2, string2);
            if (cachedDocumentFile != null) {
                Log.d((String)TAG, (String)("Exists: " + cachedDocumentFile.getUri().toString()));
                if (cachedDocumentFile.isFile()) {
                    this.mError.setError(8);
                    this.mError.setErrorString("Couldn't create a directory at the specified path, because a file with same name exists");
                    return null;
                }
                uri2 = cachedDocumentFile.getUri();
                continue;
            }
            CachedDocumentFile cachedDocumentFile2 = this.createDirectory(uri2, string2);
            if (cachedDocumentFile2 == null) {
                return null;
            }
            uri2 = cachedDocumentFile2.getUri();
            this.mCachedDocumentFiles.put(cachedDocumentFile2.getUri(), cachedDocumentFile2);
        }
        this.mError.unsetError();
        return uri2;
    }

    private synchronized CachedDocumentFile createFile(SAFFile sAFFile, boolean bl) {
        List<String> list = sAFFile.getSegments();
        Log.d((String)TAG, (String)("Creating new file: " + sAFFile.getBaseUri() + ", filename = " + this.stringJoin(File.separator, list)));
        Uri uri = this.createDirectories(new SAFFile(sAFFile.getBaseUri(), list.subList(0, list.size() - 1)));
        if (uri == null) {
            return null;
        }
        String string2 = list.get(list.size() - 1);
        String string3 = this.getMimeTypeFromFilename(string2);
        CachedDocumentFile cachedDocumentFile = this.findFile(uri, string2);
        if (cachedDocumentFile != null && cachedDocumentFile.isFile() && !bl) {
            return cachedDocumentFile;
        }
        CachedDocumentFile cachedDocumentFile2 = this.createDocumentImpl(uri, string2, string3);
        if (cachedDocumentFile2 == null) {
            return null;
        }
        this.mCachedDocumentFiles.put(cachedDocumentFile2.getUri(), cachedDocumentFile2);
        return cachedDocumentFile2;
    }

    private String getMimeTypeFromFilename(String string2) {
        int n = string2.lastIndexOf(".");
        String string3 = n == -1 || n == string2.length() - 1 ? "" : string2.substring(n + 1);
        if (string3.isEmpty()) {
            return "application/octet-stream";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CachedDocumentFile> listFiles(Uri uri) {
        Log.d((String)TAG, (String)("listFiles(): Uri = " + uri));
        ArrayList<CachedDocumentFile> arrayList = new ArrayList<CachedDocumentFile>();
        String[] stringArray = new String[]{"_display_name", "document_id", "mime_type", "_size"};
        try (Cursor cursor = null;){
            ContentResolver contentResolver = this.mCtx.getContentResolver();
            Uri uri2 = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)uri, (String)DocumentsContract.getDocumentId((Uri)uri));
            cursor = contentResolver.query(uri2, stringArray, null, null, null);
            if (cursor == null) {
                ArrayList<CachedDocumentFile> arrayList2 = arrayList;
                return arrayList2;
            }
            while (cursor.moveToNext()) {
                String string2 = SAFUtils.getColumnValStringOrNull(cursor, "document_id");
                Uri uri3 = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)string2);
                arrayList.add(new CachedDocumentFile(this.mCtx, SAFUtils.getColumnValStringOrNull(cursor, "_display_name"), string2, SAFUtils.getColumnValStringOrNull(cursor, "mime_type"), SAFUtils.getColumnValIntegerOrDefault(cursor, "_size", -1), uri3));
            }
        }
        return arrayList;
    }

    private CachedDocumentFile findFileInTree(SAFFile sAFFile) {
        CachedDocumentFile cachedDocumentFile;
        List<String> list = sAFFile.getSegments();
        Uri uri = DocumentsContract.buildDocumentUriUsingTree((Uri)sAFFile.getBaseUri(), (String)DocumentsContract.getTreeDocumentId((Uri)sAFFile.getBaseUri()));
        if (this.mCachedDocumentFiles.containsKey(uri)) {
            cachedDocumentFile = this.mCachedDocumentFiles.get(uri);
        } else {
            cachedDocumentFile = CachedDocumentFile.fromFileUri(this.mCtx, uri);
            if (cachedDocumentFile != null) {
                this.mCachedDocumentFiles.put(cachedDocumentFile.getUri(), cachedDocumentFile);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            cachedDocumentFile = this.findFile(uri, list.get(i));
            if (cachedDocumentFile == null) {
                return null;
            }
            if (cachedDocumentFile.isFile()) {
                if (i == list.size() - 1) {
                    return cachedDocumentFile;
                }
                return null;
            }
            uri = cachedDocumentFile.getUri();
        }
        return cachedDocumentFile;
    }

    private CachedDocumentFile findFile(Uri uri, String string2) {
        Object object = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)(DocumentsContract.getDocumentId((Uri)uri) + "/" + string2));
        if (this.mCachedDocumentFiles.containsKey(object)) {
            return this.mCachedDocumentFiles.get(object);
        }
        object = this.listFiles(uri);
        CachedDocumentFile cachedDocumentFile = null;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            CachedDocumentFile cachedDocumentFile2 = (CachedDocumentFile)iterator.next();
            this.mCachedDocumentFiles.put(cachedDocumentFile2.getUri(), cachedDocumentFile2);
            if (!string2.equals(cachedDocumentFile2.getName())) continue;
            cachedDocumentFile = cachedDocumentFile2;
        }
        return cachedDocumentFile;
    }

    private CachedDocumentFile createDocumentImpl(Uri uri, String string2, String string3) {
        try {
            Uri uri2 = DocumentsContract.createDocument((ContentResolver)this.mCtx.getContentResolver(), (Uri)uri, (String)string3, (String)string2);
            return new CachedDocumentFile(this.mCtx, string2, DocumentsContract.getDocumentId((Uri)uri2), string3, uri2);
        }
        catch (Exception exception) {
            this.mError.setUnknownError();
            Log.e((String)TAG, (String)("Error creating a file: uri = " + uri + ", displayName = " + string2 + ", mimeType = " + string3));
            return null;
        }
    }

    private boolean deleteFile(Uri uri) {
        try {
            return DocumentsContract.deleteDocument((ContentResolver)this.mCtx.getContentResolver(), (Uri)uri);
        }
        catch (Exception exception) {
            this.mError.setUnknownError();
            Log.e((String)TAG, (String)("Error deleting a file: uri = " + uri));
            return false;
        }
    }

    private CachedDocumentFile createDirectory(Uri uri, String string2) {
        return this.createDocumentImpl(uri, string2, "vnd.android.document/directory");
    }

    public static boolean isArc() {
        return Build.DEVICE != null && Build.DEVICE.matches(".+_cheets|cheets_.+");
    }
}

