/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.MotionEvent;

public class QtInputEventDispatcher
extends Thread {
    private static final String TAG = "QtInputEventDispatcher";
    private Handler mEventHandler;

    QtInputEventDispatcher() {
        super(TAG);
    }

    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mEventHandler = new Handler(Looper.myLooper(), new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    MotionEvent motionEvent = (MotionEvent)message.obj;
                    if (motionEvent != null) {
                        QtInputEventDispatcher.dispatchMotionEvent(message.arg1, message.arg2 == 1, motionEvent);
                        motionEvent.recycle();
                    }
                    return true;
                }
            });
            Looper.loop();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Looper halted, error = " + exception));
            exception.printStackTrace();
        }
    }

    public void onCommonEvent(MotionEvent motionEvent, int n) {
        if (this.mEventHandler == null) {
            return;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        Message.obtain((Handler)this.mEventHandler, (int)0, (int)n, (int)0, (Object)motionEvent2).sendToTarget();
    }

    public void onTouchEvent(MotionEvent motionEvent, int n) {
        if (this.mEventHandler == null) {
            return;
        }
        int n2 = 1;
        if (motionEvent.getToolType(0) == 3) {
            n2 = 0;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        Message.obtain((Handler)this.mEventHandler, (int)0, (int)n, (int)n2, (Object)motionEvent2).sendToTarget();
    }

    public void onLongPress(final MotionEvent motionEvent, final int n) {
        if (this.mEventHandler == null) {
            return;
        }
        Message.obtain((Handler)this.mEventHandler, (Runnable)new Runnable(){

            @Override
            public void run() {
                QtInputEventDispatcher.longPress(n, (int)motionEvent.getX(), (int)motionEvent.getY());
            }
        }).sendToTarget();
    }

    public boolean sendGenericMotionEvent(MotionEvent motionEvent, int n) {
        if (!motionEvent.isFromSource(2)) {
            return false;
        }
        if (motionEvent.isFromSource(8194)) {
            this.onCommonEvent(motionEvent, n);
            return QtInputEventDispatcher.canHandleMouseAction(motionEvent);
        }
        if ((motionEvent.getSource() & 0x10500A) != 0) {
            this.onTouchEvent(motionEvent, n);
            return true;
        }
        return false;
    }

    private static boolean canHandleMouseAction(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static native void dispatchMotionEvent(int var0, boolean var1, MotionEvent var2);

    private static native void longPress(int var0, int var1, int var2);
}

