/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mac;

import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class TestOfHMacMD5
implements Testlet {
    private static final byte[][][] TEST_VECTOR = new byte[][][]{new byte[][]{"Jefe".getBytes(), "what do ya want for nothing?".getBytes(), Util.toBytesFromString((String)"750c783e6ab0b503eaa86e310a5db738")}, new byte[][]{Util.toBytesFromString((String)"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b"), "Hi There".getBytes(), Util.toBytesFromString((String)"9294727a3638bb1c13f48ef8158bfc9d")}, new byte[][]{Util.toBytesFromString((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), new byte[50], Util.toBytesFromString((String)"56be34521d144c88dbb8c733f0e8b3f6")}, new byte[][]{Util.toBytesFromString((String)"0102030405060708090a0b0c0d0e0f10111213141516171819"), new byte[50], Util.toBytesFromString((String)"697eaf0aca3a3aea3a75164746ffaa79")}, new byte[][]{Util.toBytesFromString((String)"0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c"), "Test With Truncation".getBytes(), Util.toBytesFromString((String)"56461ef2342edc00f9bab995690efd4c")}, new byte[][]{new byte[80], "Test Using Larger Than Block-Size Key - Hash Key First".getBytes(), Util.toBytesFromString((String)"6b1ab7fe4bd7bf8f0b62e6ce61b9d0cd")}, new byte[][]{new byte[80], "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data".getBytes(), Util.toBytesFromString((String)"6f630fad67cda0ee1fb1f562db3aa53e")}};
    private HashMap attr = new HashMap();
    private IMac mac;

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfHMacMD5");
        this.mac = MacFactory.getInstance((String)"hmac-md5");
        try {
            this.attr.put("gnu.crypto.mac.key.material", TEST_VECTOR[0][0]);
            this.mac.init((Map)this.attr);
            this.mac.update(TEST_VECTOR[0][1], 0, TEST_VECTOR[0][1].length);
            harness.check(Util.areEqual((byte[])this.mac.digest(), (byte[])TEST_VECTOR[0][2]));
            harness.fail("#0 - SHOULD have caused a Key too short exception but didn't");
        }
        catch (InvalidKeyException x) {
            harness.check(true, "#0");
        }
        int i = 1;
        while (i < TEST_VECTOR.length) {
            try {
                this.attr.put("gnu.crypto.mac.key.material", TEST_VECTOR[i][0]);
                this.mac.init((Map)this.attr);
                this.mac.update(TEST_VECTOR[i][1], 0, TEST_VECTOR[i][1].length);
                harness.check(Util.areEqual((byte[])this.mac.digest(), (byte[])TEST_VECTOR[i][2]), "#" + i);
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("#" + i + " - " + String.valueOf(x));
            }
            ++i;
        }
    }

    static {
        int i = 0;
        while (i < 50) {
            TestOfHMacMD5.TEST_VECTOR[2][1][i] = -35;
            TestOfHMacMD5.TEST_VECTOR[3][1][i] = -51;
            TestOfHMacMD5.TEST_VECTOR[5][0][i] = -86;
            TestOfHMacMD5.TEST_VECTOR[6][0][i] = -86;
            ++i;
        }
        while (i < 80) {
            TestOfHMacMD5.TEST_VECTOR[5][0][i] = -86;
            TestOfHMacMD5.TEST_VECTOR[6][0][i] = -86;
            ++i;
        }
    }
}

