/* Function erff vectorized with SSE4.
   Copyright (C) 2021-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   https://www.gnu.org/licenses/.  */

/*
 * ALGORITHM DESCRIPTION:
 *
 *   Basic formula is
 *    erf(x) ~ erf(x0) +
 *              + exp(-x0*x0)*D*(1+c0+T*P1(T)+D^2*P3(T)+D^4*p5)
 *   where D=x-x0, T=x0*D
 *   x0 is x rounded to a specified number of fractional bits (in this case 8),
 *    except that x0=0 for |x|<3.5/256.0 (using x0=0 for first 4 table entries)
 *
 *   Data table packs both erf(x0)_high and a few bits of erf(x0)_low in one
 *   entry (in place of redundant exponent bits)
 *
 */

/* Offsets for data table __svml_serf_data_internal
 */
#define _erf_tbl			0
#define _AbsMask			4032
#define _MaxThreshold			4048
#define _SRound				4064
#define _U2Threshold			4080
#define _poly3_0			4096

/* Lookup bias for data table __svml_serf_data_internal.  */
#define Table_Lookup_Bias		-0x3c000000

#include <sysdep.h>

	.section .text.sse4, "ax", @progbits
ENTRY(_ZGVbN4v_erff_sse4)
	lea	Table_Lookup_Bias+__svml_serf_data_internal(%rip), %rdi
	movups	_AbsMask+__svml_serf_data_internal(%rip), %xmm9
	andps	%xmm0, %xmm9

	/*
	 * erf(x) rounds to 1.0 for x>_MaxThreshold (3.9375)
	 * can compute all results in the main path
	 */
	movaps	%xmm9, %xmm12

	/* save sign */
	pxor	%xmm9, %xmm0
	minps	_MaxThreshold+__svml_serf_data_internal(%rip), %xmm12

	/*
	 * vector gather:
	 * erf(x0), exp(-x0*x0)*2.0/sqrt(pi)
	 */
	movups	_SRound+__svml_serf_data_internal(%rip), %xmm1
	movaps	%xmm1, %xmm4
	movups	_U2Threshold+__svml_serf_data_internal(%rip), %xmm11
	addps	%xmm12, %xmm4
	cmpltps	%xmm12, %xmm11
	movaps	%xmm4, %xmm10
	pslld	$3, %xmm4
	pshufd	$1, %xmm4, %xmm2
	subps	%xmm1, %xmm10
	movd	%xmm4, %eax
	movd	%xmm2, %edx
	pshufd	$2, %xmm4, %xmm3
	subps	%xmm10, %xmm12
	movd	%xmm3, %ecx
	andps	%xmm12, %xmm11

	/* D2 = Diff^2 */
	mulps	%xmm11, %xmm11
	mulps	%xmm12, %xmm10

	/* NaN fixup */
	minps	%xmm9, %xmm12

	/*
	 * Start polynomial evaluation
	 * P1
	 */
	mulps	_poly3_0+__svml_serf_data_internal(%rip), %xmm11
	pshufd	$3, %xmm4, %xmm5
	subps	%xmm10, %xmm11
	movd	%xmm5, %esi

	/*
	 * branch-free
	 * (exp_h(x0) * Diff) * (poly + 1.0)
	 */
	mulps	%xmm12, %xmm11
	movslq	%eax, %rax
	addps	%xmm11, %xmm12
	movslq	%edx, %rdx
	movslq	%ecx, %rcx
	movslq	%esi, %rsi
	movq	(%rdi, %rax), %xmm13
	movq	(%rdi, %rdx), %xmm6
	movq	(%rdi, %rcx), %xmm8
	movq	(%rdi, %rsi), %xmm7
	unpcklps %xmm6, %xmm13
	unpcklps %xmm7, %xmm8
	movaps	%xmm13, %xmm14
	shufps	$238, %xmm8, %xmm13

	/* Final result */
	mulps	%xmm12, %xmm13
	movlhps	%xmm8, %xmm14
	addps	%xmm13, %xmm14

	/* set sign */
	orps	%xmm14, %xmm0
	ret

END(_ZGVbN4v_erff_sse4)

	.section .rodata, "a"
	.align	16

#ifdef __svml_serf_data_internal_typedef
typedef unsigned int VUINT32;
typedef struct {
	__declspec(align(16)) VUINT32 _erf_tbl[1008][1];
	__declspec(align(16)) VUINT32 _AbsMask[4][1];
	__declspec(align(16)) VUINT32 _MaxThreshold[4][1];
	__declspec(align(16)) VUINT32 _SRound[4][1];
	__declspec(align(16)) VUINT32 _U2Threshold[4][1];
	__declspec(align(16)) VUINT32 _poly3_0[4][1];
} __svml_serf_data_internal;
#endif
__svml_serf_data_internal:
	/* _erf_tbl */
	.long	0x00000000, 0x3f906ebb
	.long	0x3c106dfa, 0x3f906c79
	.long	0x3c906bb8, 0x3f9065b4
	.long	0x3cd89bf0, 0x3f905a6c
	.long	0x3d1062b2, 0x3f904aa3
	.long	0x3d3472ea, 0x3f90365a
	.long	0x3d587d7f, 0x3f901d93
	.long	0x3d7c8154, 0x3f900050
	.long	0x3d903ea4, 0x3f8fde94
	.long	0x3da2381f, 0x3f8fb862
	.long	0x3db42c8d, 0x3f8f8dbd
	.long	0x3dc61b5f, 0x3f8f5eab
	.long	0x3dd80409, 0x3f8f2b2e
	.long	0x3de9e5fc, 0x3f8ef34c
	.long	0x3dfbc0ad, 0x3f8eb70a
	.long	0x3e06c9c8, 0x3f8e766e
	.long	0x3e0faf0d, 0x3f8e317d
	.long	0x3e188fe1, 0x3f8de83e
	.long	0x3e216bfe, 0x3f8d9ab9
	.long	0x3e2a4321, 0x3f8d48f3
	.long	0x3e331506, 0x3f8cf2f5
	.long	0x3e3be169, 0x3f8c98c6
	.long	0x3e44a808, 0x3f8c3a6f
	.long	0x3e4d68a1, 0x3f8bd7f8
	.long	0x3e5622f2, 0x3f8b716c
	.long	0x3e5ed6b9, 0x3f8b06d2
	.long	0x3e6783b7, 0x3f8a9834
	.long	0x3e7029aa, 0x3f8a259e
	.long	0x3e78c855, 0x3f89af18
	.long	0x3e80afbc, 0x3f8934af
	.long	0x3e84f76b, 0x3f88b66c
	.long	0x3e893b19, 0x3f88345d
	.long	0x3e8d7aa7, 0x3f87ae8b
	.long	0x3e91b5f8, 0x3f872504
	.long	0x3e95ecee, 0x3f8697d3
	.long	0x3e9a1f6b, 0x3f860705
	.long	0x3e9e4d54, 0x3f8572a8
	.long	0x3ea2768c, 0x3f84dac8
	.long	0x3ea69af8, 0x3f843f72
	.long	0x3eaaba7a, 0x3f83a0b6
	.long	0x3eaed4fa, 0x3f82fe9f
	.long	0x3eb2ea5c, 0x3f82593e
	.long	0x3eb6fa85, 0x3f81b0a0
	.long	0x3ebb055d, 0x3f8104d3
	.long	0x3ebf0aca, 0x3f8055e8
	.long	0x3ec30ab3, 0x3f7f47d8
	.long	0x3ec70501, 0x3f7ddddf
	.long	0x3ecaf99b, 0x3f7c6e05
	.long	0x3ecee869, 0x3f7af867
	.long	0x3ed2d156, 0x3f797d26
	.long	0x3ed6b44b, 0x3f77fc62
	.long	0x3eda9132, 0x3f76763c
	.long	0x3ede67f6, 0x3f74ead4
	.long	0x3ee23882, 0x3f735a4c
	.long	0x3ee602c2, 0x3f71c4c4
	.long	0x3ee9c6a2, 0x3f702a5f
	.long	0x3eed840e, 0x3f6e8b3e
	.long	0x3ef13af5, 0x3f6ce783
	.long	0x3ef4eb45, 0x3f6b3f51
	.long	0x3ef894ea, 0x3f6992c9
	.long	0x3efc37d5, 0x3f67e20f
	.long	0x3effd3f5, 0x3f662d45
	.long	0x3f01b49d, 0x3f64748e
	.long	0x3f037bca, 0x3f62b80d
	.long	0x3f053f7b, 0x3f60f7e5
	.long	0x3f06ffa8, 0x3f5f3439
	.long	0x3f08bc4a, 0x3f5d6d2d
	.long	0x3f0a755a, 0x3f5ba2e3
	.long	0x3f0c2ad3, 0x3f59d57e
	.long	0x3f0ddcae, 0x3f580523
	.long	0x3f0f8ae6, 0x3f5631f4
	.long	0x3f113574, 0x3f545c14
	.long	0x3f12dc54, 0x3f5283a7
	.long	0x3f147f81, 0x3f50a8cf
	.long	0x3f161ef6, 0x3f4ecbb1
	.long	0x3f17baae, 0x3f4cec6d
	.long	0x3f1952a6, 0x3f4b0b28
	.long	0x3f1ae6da, 0x3f492804
	.long	0x3f1c7745, 0x3f474323
	.long	0x3f1e03e5, 0x3f455ca8
	.long	0x3f1f8cb7, 0x3f4374b5
	.long	0x3f2111b7, 0x3f418b6b
	.long	0x3f2292e4, 0x3f3fa0ee
	.long	0x3f24103a, 0x3f3db55e
	.long	0x3f2589b9, 0x3f3bc8dc
	.long	0x3f26ff5d, 0x3f39db8a
	.long	0x3f287126, 0x3f37ed89
	.long	0x3f29df13, 0x3f35fef8
	.long	0x3f2b4922, 0x3f340ff9
	.long	0x3f2caf53, 0x3f3220ab
	.long	0x3f2e11a4, 0x3f30312e
	.long	0x3f2f7017, 0x3f2e41a1
	.long	0x3f30caab, 0x3f2c5223
	.long	0x3f322160, 0x3f2a62d3
	.long	0x3f337437, 0x3f2873cf
	.long	0x3f34c32f, 0x3f268534
	.long	0x3f360e4c, 0x3f249721
	.long	0x3f37558c, 0x3f22a9b3
	.long	0x3f3898f3, 0x3f20bd06
	.long	0x3f39d881, 0x3f1ed137
	.long	0x3f3b1438, 0x3f1ce661
	.long	0x3f3c4c1b, 0x3f1afca0
	.long	0x3f3d802c, 0x3f19140f
	.long	0x3f3eb06c, 0x3f172cc9
	.long	0x3f3fdce0, 0x3f1546e7
	.long	0x3f410589, 0x3f136284
	.long	0x3f422a6b, 0x3f117fb9
	.long	0x3f434b89, 0x3f0f9e9e
	.long	0x3f4468e7, 0x3f0dbf4c
	.long	0x3f458287, 0x3f0be1db
	.long	0x3f46986f, 0x3f0a0662
	.long	0x3f47aaa2, 0x3f082cf7
	.long	0x3f48b925, 0x3f0655b1
	.long	0x3f49c3fb, 0x3f0480a6
	.long	0x3f4acb29, 0x3f02adeb
	.long	0x3f4bceb4, 0x3f00dd96
	.long	0x3f4ccea1, 0x3efe1f73
	.long	0x3f4dcaf4, 0x3efa88d5
	.long	0x3f4ec3b4, 0x3ef6f777
	.long	0x3f4fb8e5, 0x3ef36b80
	.long	0x3f50aa8d, 0x3eefe513
	.long	0x3f5198b1, 0x3eec6455
	.long	0x3f528358, 0x3ee8e968
	.long	0x3f536a86, 0x3ee5746d
	.long	0x3f544e43, 0x3ee20584
	.long	0x3f552e93, 0x3ede9ccc
	.long	0x3f560b7e, 0x3edb3a64
	.long	0x3f56e50a, 0x3ed7de6a
	.long	0x3f57bb3d, 0x3ed488f8
	.long	0x3f588e1e, 0x3ed13a2b
	.long	0x3f595db4, 0x3ecdf21c
	.long	0x3f5a2a05, 0x3ecab0e4
	.long	0x3f5af318, 0x3ec7769b
	.long	0x3f5bb8f4, 0x3ec44359
	.long	0x3f5c7ba1, 0x3ec11733
	.long	0x3f5d3b25, 0x3ebdf23d
	.long	0x3f5df788, 0x3ebad48d
	.long	0x3f5eb0d1, 0x3eb7be35
	.long	0x3f5f6707, 0x3eb4af46
	.long	0x3f601a32, 0x3eb1a7d3
	.long	0x3f60ca59, 0x3eaea7ea
	.long	0x3f617784, 0x3eabaf9a
	.long	0x3f6221bb, 0x3ea8bef3
	.long	0x3f62c905, 0x3ea5d600
	.long	0x3f636d69, 0x3ea2f4ce
	.long	0x3f640ef1, 0x3ea01b68
	.long	0x3f64ada3, 0x3e9d49d9
	.long	0x3f654987, 0x3e9a8029
	.long	0x3f65e2a6, 0x3e97be62
	.long	0x3f667906, 0x3e95048b
	.long	0x3f670cb1, 0x3e9252aa
	.long	0x3f679dae, 0x3e8fa8c5
	.long	0x3f682c06, 0x3e8d06e3
	.long	0x3f68b7bf, 0x3e8a6d05
	.long	0x3f6940e2, 0x3e87db31
	.long	0x3f69c778, 0x3e855168
	.long	0x3f6a4b88, 0x3e82cfad
	.long	0x3f6acd1a, 0x3e805600
	.long	0x3f6b4c36, 0x3e7bc8c2
	.long	0x3f6bc8e5, 0x3e76f5a0
	.long	0x3f6c432f, 0x3e723298
	.long	0x3f6cbb1b, 0x3e6d7fa5
	.long	0x3f6d30b1, 0x3e68dcc1
	.long	0x3f6da3fa, 0x3e6449e7
	.long	0x3f6e14fe, 0x3e5fc70e
	.long	0x3f6e83c4, 0x3e5b542b
	.long	0x3f6ef055, 0x3e56f136
	.long	0x3f6f5ab8, 0x3e529e21
	.long	0x3f6fc2f5, 0x3e4e5adf
	.long	0x3f702915, 0x3e4a2761
	.long	0x3f708d1f, 0x3e460399
	.long	0x3f70ef1b, 0x3e41ef75
	.long	0x3f714f11, 0x3e3deae4
	.long	0x3f71ad09, 0x3e39f5d2
	.long	0x3f72090a, 0x3e36102b
	.long	0x3f72631c, 0x3e3239db
	.long	0x3f72bb46, 0x3e2e72cb
	.long	0x3f731191, 0x3e2abae4
	.long	0x3f736604, 0x3e27120f
	.long	0x3f73b8a5, 0x3e237833
	.long	0x3f74097e, 0x3e1fed36
	.long	0x3f745895, 0x3e1c70fd
	.long	0x3f74a5f2, 0x3e19036e
	.long	0x3f74f19b, 0x3e15a46d
	.long	0x3f753b98, 0x3e1253dc
	.long	0x3f7583f1, 0x3e0f119f
	.long	0x3f75caac, 0x3e0bdd96
	.long	0x3f760fd1, 0x3e08b7a4
	.long	0x3f765366, 0x3e059fa9
	.long	0x3f769573, 0x3e029586
	.long	0x3f76d5fe, 0x3dff3230
	.long	0x3f77150f, 0x3df95481
	.long	0x3f7752ab, 0x3df391b9
	.long	0x3f778eda, 0x3dede995
	.long	0x3f77c9a2, 0x3de85bd0
	.long	0x3f78030a, 0x3de2e825
	.long	0x3f783b18, 0x3ddd8e4c
	.long	0x3f7871d3, 0x3dd84dfe
	.long	0x3f78a741, 0x3dd326f3
	.long	0x3f78db68, 0x3dce18e3
	.long	0x3f790e50, 0x3dc92385
	.long	0x3f793ffc, 0x3dc4468f
	.long	0x3f797075, 0x3dbf81b6
	.long	0x3f799fbf, 0x3dbad4b0
	.long	0x3f79cde1, 0x3db63f32
	.long	0x3f79fae1, 0x3db1c0f1
	.long	0x3f7a26c4, 0x3dad59a1
	.long	0x3f7a518f, 0x3da908f6
	.long	0x3f7a7b4a, 0x3da4cea4
	.long	0x3f7aa3f9, 0x3da0aa5e
	.long	0x3f7acba1, 0x3d9c9bd9
	.long	0x3f7af248, 0x3d98a2c7
	.long	0x3f7b17f4, 0x3d94bedd
	.long	0x3f7b3ca9, 0x3d90efcd
	.long	0x3f7b606e, 0x3d8d354b
	.long	0x3f7b8346, 0x3d898f0a
	.long	0x3f7ba537, 0x3d85fcbf
	.long	0x3f7bc646, 0x3d827e1d
	.long	0x3f7be677, 0x3d7e25af
	.long	0x3f7c05d1, 0x3d777546
	.long	0x3f7c2456, 0x3d70ea68
	.long	0x3f7c420d, 0x3d6a847d
	.long	0x3f7c5ef9, 0x3d6442f0
	.long	0x3f7c7b1f, 0x3d5e252a
	.long	0x3f7c9684, 0x3d582a98
	.long	0x3f7cb12b, 0x3d5252a5
	.long	0x3f7ccb1a, 0x3d4c9cbd
	.long	0x3f7ce454, 0x3d47084e
	.long	0x3f7cfcdd, 0x3d4194c7
	.long	0x3f7d14ba, 0x3d3c4196
	.long	0x3f7d2bef, 0x3d370e2c
	.long	0x3f7d427f, 0x3d31f9fb
	.long	0x3f7d586f, 0x3d2d0474
	.long	0x3f7d6dc2, 0x3d282d0c
	.long	0x3f7d827b, 0x3d237336
	.long	0x3f7d96a0, 0x3d1ed669
	.long	0x3f7daa32, 0x3d1a561b
	.long	0x3f7dbd36, 0x3d15f1c6
	.long	0x3f7dcfb0, 0x3d11a8e1
	.long	0x3f7de1a2, 0x3d0d7ae9
	.long	0x3f7df30f, 0x3d09675a
	.long	0x3f7e03fd, 0x3d056db0
	.long	0x3f7e146c, 0x3d018d6b
	.long	0x3f7e2461, 0x3cfb8c15
	.long	0x3f7e33de, 0x3cf42e22
	.long	0x3f7e42e8, 0x3ced0003
	.long	0x3f7e517f, 0x3ce600c0
	.long	0x3f7e5fa9, 0x3cdf2f67
	.long	0x3f7e6d66, 0x3cd88b05
	.long	0x3f7e7abb, 0x3cd212ad
	.long	0x3f7e87aa, 0x3ccbc574
	.long	0x3f7e9435, 0x3cc5a273
	.long	0x3f7ea05f, 0x3cbfa8c4
	.long	0x3f7eac2b, 0x3cb9d786
	.long	0x3f7eb79a, 0x3cb42ddb
	.long	0x3f7ec2b1, 0x3caeaae6
	.long	0x3f7ecd71, 0x3ca94dcf
	.long	0x3f7ed7dc, 0x3ca415c2
	.long	0x3f7ee1f4, 0x3c9f01ec
	.long	0x3f7eebbd, 0x3c9a117f
	.long	0x3f7ef537, 0x3c9543ae
	.long	0x3f7efe66, 0x3c9097b1
	.long	0x3f7f074b, 0x3c8c0cc2
	.long	0x3f7f0fe8, 0x3c87a21f
	.long	0x3f7f1840, 0x3c83570a
	.long	0x3f7f2053, 0x3c7e558a
	.long	0x3f7f2826, 0x3c763931
	.long	0x3f7f2fb8, 0x3c6e579b
	.long	0x3f7f370c, 0x3c66af65
	.long	0x3f7f3e23, 0x3c5f3f2d
	.long	0x3f7f4500, 0x3c58059c
	.long	0x3f7f4ba4, 0x3c51015f
	.long	0x3f7f5211, 0x3c4a3127
	.long	0x3f7f5848, 0x3c4393af
	.long	0x3f7f5e4b, 0x3c3d27b5
	.long	0x3f7f641b, 0x3c36ebff
	.long	0x3f7f69ba, 0x3c30df57
	.long	0x3f7f6f29, 0x3c2b008e
	.long	0x3f7f746a, 0x3c254e7b
	.long	0x3f7f797f, 0x3c1fc7fb
	.long	0x3f7f7e67, 0x3c1a6bee
	.long	0x3f7f8326, 0x3c15393d
	.long	0x3f7f87bb, 0x3c102ed6
	.long	0x3f7f8c29, 0x3c0b4bab
	.long	0x3f7f9070, 0x3c068eb5
	.long	0x3f7f9492, 0x3c01f6f1
	.long	0x3f7f9890, 0x3bfb06c5
	.long	0x3f7f9c6b, 0x3bf26625
	.long	0x3f7fa024, 0x3bea0a1d
	.long	0x3f7fa3bc, 0x3be1f0d3
	.long	0x3f7fa734, 0x3bda1876
	.long	0x3f7faa8d, 0x3bd27f42
	.long	0x3f7fadc8, 0x3bcb237a
	.long	0x3f7fb0e6, 0x3bc4036c
	.long	0x3f7fb3e8, 0x3bbd1d6f
	.long	0x3f7fb6cf, 0x3bb66fe6
	.long	0x3f7fb99c, 0x3baff93b
	.long	0x3f7fbc4f, 0x3ba9b7e1
	.long	0x3f7fbeea, 0x3ba3aa56
	.long	0x3f7fc16d, 0x3b9dcf20
	.long	0x3f7fc3d9, 0x3b9824ce
	.long	0x3f7fc62e, 0x3b92a9f7
	.long	0x3f7fc86e, 0x3b8d5d3c
	.long	0x3f7fca99, 0x3b883d46
	.long	0x3f7fccb0, 0x3b8348c6
	.long	0x3f7fceb4, 0x3b7cfce8
	.long	0x3f7fd0a5, 0x3b73ba24
	.long	0x3f7fd283, 0x3b6ac6d3
	.long	0x3f7fd450, 0x3b622096
	.long	0x3f7fd60c, 0x3b59c51d
	.long	0x3f7fd7b7, 0x3b51b22a
	.long	0x3f7fd953, 0x3b49e589
	.long	0x3f7fdadf, 0x3b425d18
	.long	0x3f7fdc5c, 0x3b3b16c2
	.long	0x3f7fddcc, 0x3b341080
	.long	0x3f7fdf2d, 0x3b2d4858
	.long	0x3f7fe081, 0x3b26bc5e
	.long	0x3f7fe1c8, 0x3b206ab2
	.long	0x3f7fe303, 0x3b1a5183
	.long	0x3f7fe431, 0x3b146f09
	.long	0x3f7fe554, 0x3b0ec18c
	.long	0x3f7fe66c, 0x3b09475d
	.long	0x3f7fe77a, 0x3b03feda
	.long	0x3f7fe87d, 0x3afdccdc
	.long	0x3f7fe975, 0x3af3f919
	.long	0x3f7fea65, 0x3aea7f6c
	.long	0x3f7feb4b, 0x3ae15ce8
	.long	0x3f7fec27, 0x3ad88eb8
	.long	0x3f7fecfc, 0x3ad0121b
	.long	0x3f7fedc8, 0x3ac7e464
	.long	0x3f7fee8c, 0x3ac002f8
	.long	0x3f7fef48, 0x3ab86b52
	.long	0x3f7feffd, 0x3ab11afe
	.long	0x3f7ff0aa, 0x3aaa0f9a
	.long	0x3f7ff151, 0x3aa346d7
	.long	0x3f7ff1f1, 0x3a9cbe77
	.long	0x3f7ff28a, 0x3a96744c
	.long	0x3f7ff31e, 0x3a90663b
	.long	0x3f7ff3ab, 0x3a8a9237
	.long	0x3f7ff433, 0x3a84f643
	.long	0x3f7ff4b5, 0x3a7f20e7
	.long	0x3f7ff532, 0x3a74bdd2
	.long	0x3f7ff5aa, 0x3a6abfa9
	.long	0x3f7ff61d, 0x3a6122ea
	.long	0x3f7ff68b, 0x3a57e42f
	.long	0x3f7ff6f5, 0x3a4f002c
	.long	0x3f7ff75a, 0x3a4673af
	.long	0x3f7ff7bb, 0x3a3e3ba2
	.long	0x3f7ff819, 0x3a365507
	.long	0x3f7ff872, 0x3a2ebcf6
	.long	0x3f7ff8c7, 0x3a2770a1
	.long	0x3f7ff919, 0x3a206d52
	.long	0x3f7ff968, 0x3a19b066
	.long	0x3f7ff9b3, 0x3a133754
	.long	0x3f7ff9fb, 0x3a0cffa3
	.long	0x3f7ffa40, 0x3a0706f4
	.long	0x3f7ffa82, 0x3a014af8
	.long	0x3f7ffac1, 0x39f792ea
	.long	0x3f7ffafe, 0x39ed0088
	.long	0x3f7ffb38, 0x39e2daa1
	.long	0x3f7ffb6f, 0x39d91d2d
	.long	0x3f7ffba5, 0x39cfc44a
	.long	0x3f7ffbd7, 0x39c6cc35
	.long	0x3f7ffc08, 0x39be314d
	.long	0x3f7ffc36, 0x39b5f011
	.long	0x3f7ffc63, 0x39ae051c
	.long	0x3f7ffc8e, 0x39a66d2a
	.long	0x3f7ffcb6, 0x399f2512
	.long	0x3f7ffcdd, 0x399829c8
	.long	0x3f7ffd02, 0x3991785a
	.long	0x3f7ffd26, 0x398b0df2
	.long	0x3f7ffd48, 0x3984e7d2
	.long	0x3f7ffd68, 0x397e06ab
	.long	0x3f7ffd87, 0x3972bbde
	.long	0x3f7ffda5, 0x3967ea53
	.long	0x3f7ffdc1, 0x395d8d4b
	.long	0x3f7ffddc, 0x3953a034
	.long	0x3f7ffdf6, 0x394a1ea5
	.long	0x3f7ffe0f, 0x3941045e
	.long	0x3f7ffe27, 0x39384d47
	.long	0x3f7ffe3d, 0x392ff56d
	.long	0x3f7ffe53, 0x3927f904
	.long	0x3f7ffe67, 0x39205461
	.long	0x3f7ffe7b, 0x391903fe
	.long	0x3f7ffe8d, 0x39120475
	.long	0x3f7ffe9f, 0x390b5281
	.long	0x3f7ffeb0, 0x3904eafc
	.long	0x3f7ffec0, 0x38fd95bd
	.long	0x3f7ffed0, 0x38f1de7a
	.long	0x3f7ffedf, 0x38e6aa94
	.long	0x3f7ffeed, 0x38dbf4a3
	.long	0x3f7ffefa, 0x38d1b776
	.long	0x3f7fff07, 0x38c7ee0e
	.long	0x3f7fff13, 0x38be939c
	.long	0x3f7fff1f, 0x38b5a381
	.long	0x3f7fff2a, 0x38ad194e
	.long	0x3f7fff34, 0x38a4f0bc
	.long	0x3f7fff3f, 0x389d25b0
	.long	0x3f7fff48, 0x3895b43b
	.long	0x3f7fff51, 0x388e9890
	.long	0x3f7fff5a, 0x3887cf0e
	.long	0x3f7fff62, 0x38815434
	.long	0x3f7fff6a, 0x3876494d
	.long	0x3f7fff72, 0x386a7a5a
	.long	0x3f7fff79, 0x385f355e
	.long	0x3f7fff80, 0x38547466
	.long	0x3f7fff86, 0x384a31bf
	.long	0x3f7fff8c, 0x384067ee
	.long	0x3f7fff92, 0x383711b4
	.long	0x3f7fff98, 0x382e2a06
	.long	0x3f7fff9d, 0x3825ac0e
	.long	0x3f7fffa2, 0x381d9329
	.long	0x3f7fffa7, 0x3815dae6
	.long	0x3f7fffab, 0x380e7f01
	.long	0x3f7fffb0, 0x38077b62
	.long	0x3f7fffb4, 0x3800cc21
	.long	0x3f7fffb8, 0x37f4daf4
	.long	0x3f7fffbc, 0x37e8b7ac
	.long	0x3f7fffbf, 0x37dd2782
	.long	0x3f7fffc2, 0x37d223dc
	.long	0x3f7fffc6, 0x37c7a666
	.long	0x3f7fffc9, 0x37bda912
	.long	0x3f7fffcc, 0x37b42611
	.long	0x3f7fffce, 0x37ab17d6
	.long	0x3f7fffd1, 0x37a2790f
	.long	0x3f7fffd3, 0x379a44a5
	.long	0x3f7fffd6, 0x379275b9
	.long	0x3f7fffd8, 0x378b07a2
	.long	0x3f7fffda, 0x3783f5e9
	.long	0x3f7fffdc, 0x377a7897
	.long	0x3f7fffde, 0x376dad68
	.long	0x3f7fffe0, 0x37618278
	.long	0x3f7fffe2, 0x3755f04f
	.long	0x3f7fffe3, 0x374aefcc
	.long	0x3f7fffe5, 0x37407a1d
	.long	0x3f7fffe6, 0x373688bc
	.long	0x3f7fffe8, 0x372d1570
	.long	0x3f7fffe9, 0x37241a44
	.long	0x3f7fffea, 0x371b9188
	.long	0x3f7fffeb, 0x371375cf
	.long	0x3f7fffec, 0x370bc1e7
	.long	0x3f7fffee, 0x370470dd
	.long	0x3f7fffef, 0x36fafbec
	.long	0x3f7fffef, 0x36edc95b
	.long	0x3f7ffff0, 0x36e14167
	.long	0x3f7ffff1, 0x36d55bd6
	.long	0x3f7ffff2, 0x36ca10ce
	.long	0x3f7ffff3, 0x36bf58d1
	.long	0x3f7ffff4, 0x36b52cb9
	.long	0x3f7ffff4, 0x36ab85b5
	.long	0x3f7ffff5, 0x36a25d43
	.long	0x3f7ffff5, 0x3699ad31
	.long	0x3f7ffff6, 0x36916f95
	.long	0x3f7ffff7, 0x36899ecb
	.long	0x3f7ffff7, 0x36823575
	.long	0x3f7ffff8, 0x36765ce8
	.long	0x3f7ffff8, 0x366909cc
	.long	0x3f7ffff9, 0x365c684a
	.long	0x3f7ffff9, 0x36506f88
	.long	0x3f7ffff9, 0x36451713
	.long	0x3f7ffffa, 0x363a56e4
	.long	0x3f7ffffa, 0x36302754
	.long	0x3f7ffffa, 0x36268119
	.long	0x3f7ffffb, 0x361d5d43
	.long	0x3f7ffffb, 0x3614b538
	.long	0x3f7ffffb, 0x360c82b1
	.long	0x3f7ffffc, 0x3604bfb1
	.long	0x3f7ffffc, 0x35facd10
	.long	0x3f7ffffc, 0x35ece39b
	.long	0x3f7ffffc, 0x35dfb8b6
	.long	0x3f7ffffd, 0x35d34296
	.long	0x3f7ffffd, 0x35c777ec
	.long	0x3f7ffffd, 0x35bc4fdc
	.long	0x3f7ffffd, 0x35b1c1fc
	.long	0x3f7ffffd, 0x35a7c64b
	.long	0x3f7ffffd, 0x359e5531
	.long	0x3f7ffffe, 0x35956771
	.long	0x3f7ffffe, 0x358cf630
	.long	0x3f7ffffe, 0x3584fae8
	.long	0x3f7ffffe, 0x357adecb
	.long	0x3f7ffffe, 0x356c9b8f
	.long	0x3f7ffffe, 0x355f20ef
	.long	0x3f7ffffe, 0x3552644f
	.long	0x3f7ffffe, 0x35465b9c
	.long	0x3f7fffff, 0x353afd47
	.long	0x3f7fffff, 0x3530403c
	.long	0x3f7fffff, 0x35261be0
	.long	0x3f7fffff, 0x351c8807
	.long	0x3f7fffff, 0x35137cf0
	.long	0x3f7fffff, 0x350af341
	.long	0x3f7fffff, 0x3502e402
	.long	0x3f7fffff, 0x34f6912a
	.long	0x3f7fffff, 0x34e8356b
	.long	0x3f7fffff, 0x34daa8e4
	.long	0x3f7fffff, 0x34cde050
	.long	0x3f7fffff, 0x34c1d100
	.long	0x3f7fffff, 0x34b670d5
	.long	0x3f7fffff, 0x34abb639
	.long	0x3f7fffff, 0x34a19816
	.long	0x3f7fffff, 0x34980dd1
	.long	0x3f7fffff, 0x348f0f43
	.long	0x3f7fffff, 0x348694b3
	.long	0x3f800000, 0x347d2da8
	.long	0x3f800000, 0x346e1d72
	.align	16
	.long	0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff /* _AbsMask */
	.align	16
	.long	0x407b8000, 0x407b8000, 0x407b8000, 0x407b8000 /* _MaxThreshold */
	.align	16
	.long	0x47800000, 0x47800000, 0x47800000, 0x47800000 /* _SRound */
	.align	16
	.long	0x2f800000, 0x2f800000, 0x2f800000, 0x2f800000 /* _U2THreshold */
	.align	16
	.long	0xbeaaaade, 0xbeaaaade, 0xbeaaaade, 0xbeaaaade /* _poly_3_0 */
	.align	16
	.type	__svml_serf_data_internal, @object
	.size	__svml_serf_data_internal, .-__svml_serf_data_internal
