/* valaunresolvedtype.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valaunresolvedtype.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>




struct _ValaUnresolvedTypePrivate {
	ValaUnresolvedSymbol* _unresolved_symbol;
	gint _array_rank;
	gint _pointer_level;
	gboolean _is_weak;
};
#define VALA_UNRESOLVED_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypePrivate))
enum  {
	VALA_UNRESOLVED_TYPE_DUMMY_PROPERTY,
	VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL,
	VALA_UNRESOLVED_TYPE_ARRAY_RANK,
	VALA_UNRESOLVED_TYPE_POINTER_LEVEL,
	VALA_UNRESOLVED_TYPE_IS_WEAK
};
static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base);
static char* vala_unresolved_type_real_to_string (ValaCodeNode* base);
static gpointer vala_unresolved_type_parent_class = NULL;
static void vala_unresolved_type_dispose (GObject * obj);



ValaUnresolvedType* vala_unresolved_type_new (void) {
	ValaUnresolvedType * self;
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	return self;
}


/**
 * Creates a new type reference.
 *
 * @param symbol    unresolved type symbol
 * @param source    reference to source code
 * @return          newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_symbol (ValaUnresolvedSymbol* symbol, ValaSourceReference* source) {
	ValaUnresolvedType * self;
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (symbol), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	vala_unresolved_type_set_unresolved_symbol (self, symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


/**
 * Creates a new type reference from a code expression.
 *
 * @param expr   member access expression
 * @param source reference to source code
 * @return       newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_expression (ValaExpression* expr) {
	char* ns;
	char* type_name;
	gpointer _tmp8;
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	ns = NULL;
	type_name = NULL;
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaUnresolvedType* type_ref;
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* ma;
		type_ref = NULL;
		_tmp0 = NULL;
		ma = (_tmp0 = VALA_MEMBER_ACCESS (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_member_access_get_inner (ma) != NULL) {
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (ma))) {
				ValaMemberAccess* _tmp1;
				ValaMemberAccess* simple;
				ValaUnresolvedType* _tmp4;
				ValaUnresolvedSymbol* _tmp3;
				ValaUnresolvedSymbol* _tmp2;
				_tmp1 = NULL;
				simple = (_tmp1 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				type_ref = (_tmp4 = vala_unresolved_type_new_from_symbol ((_tmp3 = vala_unresolved_symbol_new ((_tmp2 = vala_unresolved_symbol_new (NULL, vala_member_access_get_member_name (simple), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp4);
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(simple == NULL ? NULL : (simple = (g_object_unref (simple), NULL)));
			}
		} else {
			ValaUnresolvedType* _tmp6;
			ValaUnresolvedSymbol* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			type_ref = (_tmp6 = vala_unresolved_type_new_from_symbol ((_tmp5 = vala_unresolved_symbol_new (NULL, vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp6);
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		}
		if (type_ref != NULL) {
			GeeCollection* type_args;
			ValaUnresolvedType* _tmp7;
			type_args = vala_member_access_get_type_arguments (ma);
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = type_args;
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaDataType* arg;
					arg = ((ValaDataType*) gee_iterator_get (arg_it));
					{
						vala_data_type_add_type_argument (VALA_DATA_TYPE (type_ref), arg);
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
					}
				}
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			_tmp7 = NULL;
			return (_tmp7 = type_ref, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp7);
		}
		(type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	}
	vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Type reference must be simple name or member access expression");
	return (_tmp8 = NULL, (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp8);
}


static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base) {
	ValaUnresolvedType * self;
	ValaUnresolvedType* result;
	ValaUnresolvedSymbol* _tmp0;
	self = VALA_UNRESOLVED_TYPE (base);
	result = vala_unresolved_type_new ();
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_transfers_ownership (VALA_DATA_TYPE (result), vala_data_type_get_transfers_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_takes_ownership (VALA_DATA_TYPE (result), vala_data_type_get_takes_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	_tmp0 = NULL;
	vala_unresolved_type_set_unresolved_symbol (result, (_tmp0 = vala_unresolved_symbol_copy (self->priv->_unresolved_symbol)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_unresolved_type_set_array_rank (result, self->priv->_array_rank);
	vala_unresolved_type_set_pointer_level (result, self->priv->_pointer_level);
	vala_unresolved_type_set_is_weak (result, self->priv->_is_weak);
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaDataType* arg;
			arg = ((ValaDataType*) gee_iterator_get (arg_it));
			{
				ValaDataType* _tmp1;
				_tmp1 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp1 = vala_data_type_copy (arg)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_unresolved_type_real_to_string (ValaCodeNode* base) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (base);
	return vala_code_node_to_string (VALA_CODE_NODE (self->priv->_unresolved_symbol));
}


ValaUnresolvedSymbol* vala_unresolved_type_get_unresolved_symbol (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), NULL);
	return self->priv->_unresolved_symbol;
}


void vala_unresolved_type_set_unresolved_symbol (ValaUnresolvedType* self, ValaUnresolvedSymbol* value) {
	ValaUnresolvedSymbol* _tmp2;
	ValaUnresolvedSymbol* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_unresolved_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_unresolved_symbol == NULL ? NULL : (self->priv->_unresolved_symbol = (g_object_unref (self->priv->_unresolved_symbol), NULL))), _tmp2);
}


gint vala_unresolved_type_get_array_rank (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), 0);
	return self->priv->_array_rank;
}


void vala_unresolved_type_set_array_rank (ValaUnresolvedType* self, gint value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_array_rank = value;
}


gint vala_unresolved_type_get_pointer_level (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), 0);
	return self->priv->_pointer_level;
}


void vala_unresolved_type_set_pointer_level (ValaUnresolvedType* self, gint value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_pointer_level = value;
}


gboolean vala_unresolved_type_get_is_weak (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_is_weak;
}


void vala_unresolved_type_set_is_weak (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_is_weak = value;
}


static void vala_unresolved_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL:
		g_value_set_object (value, vala_unresolved_type_get_unresolved_symbol (self));
		break;
		case VALA_UNRESOLVED_TYPE_ARRAY_RANK:
		g_value_set_int (value, vala_unresolved_type_get_array_rank (self));
		break;
		case VALA_UNRESOLVED_TYPE_POINTER_LEVEL:
		g_value_set_int (value, vala_unresolved_type_get_pointer_level (self));
		break;
		case VALA_UNRESOLVED_TYPE_IS_WEAK:
		g_value_set_boolean (value, vala_unresolved_type_get_is_weak (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL:
		vala_unresolved_type_set_unresolved_symbol (self, g_value_get_object (value));
		break;
		case VALA_UNRESOLVED_TYPE_ARRAY_RANK:
		vala_unresolved_type_set_array_rank (self, g_value_get_int (value));
		break;
		case VALA_UNRESOLVED_TYPE_POINTER_LEVEL:
		vala_unresolved_type_set_pointer_level (self, g_value_get_int (value));
		break;
		case VALA_UNRESOLVED_TYPE_IS_WEAK:
		vala_unresolved_type_set_is_weak (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_class_init (ValaUnresolvedTypeClass * klass) {
	vala_unresolved_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaUnresolvedTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_unresolved_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_unresolved_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_unresolved_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_unresolved_type_real_copy;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_unresolved_type_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL, g_param_spec_object ("unresolved-symbol", "unresolved-symbol", "unresolved-symbol", VALA_TYPE_UNRESOLVED_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_ARRAY_RANK, g_param_spec_int ("array-rank", "array-rank", "array-rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_POINTER_LEVEL, g_param_spec_int ("pointer-level", "pointer-level", "pointer-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_IS_WEAK, g_param_spec_boolean ("is-weak", "is-weak", "is-weak", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_unresolved_type_init (ValaUnresolvedType * self) {
	self->priv = VALA_UNRESOLVED_TYPE_GET_PRIVATE (self);
}


static void vala_unresolved_type_dispose (GObject * obj) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (obj);
	(self->priv->_unresolved_symbol == NULL ? NULL : (self->priv->_unresolved_symbol = (g_object_unref (self->priv->_unresolved_symbol), NULL)));
	G_OBJECT_CLASS (vala_unresolved_type_parent_class)->dispose (obj);
}


GType vala_unresolved_type_get_type (void) {
	static GType vala_unresolved_type_type_id = 0;
	if (G_UNLIKELY (vala_unresolved_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnresolvedTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unresolved_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnresolvedType), 0, (GInstanceInitFunc) vala_unresolved_type_init };
		vala_unresolved_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaUnresolvedType", &g_define_type_info, 0);
	}
	return vala_unresolved_type_type_id;
}




