/* valaliteral.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaliteral.h>




enum  {
	VALA_LITERAL_DUMMY_PROPERTY
};
static gboolean vala_literal_real_is_pure (ValaExpression* base);
static gpointer vala_literal_parent_class = NULL;



static gboolean vala_literal_real_is_pure (ValaExpression* base) {
	ValaLiteral * self;
	self = VALA_LITERAL (base);
	return TRUE;
}


/**
 * Base class for all literals in the source code.
 */
ValaLiteral* vala_literal_new (void) {
	ValaLiteral * self;
	self = g_object_newv (VALA_TYPE_LITERAL, 0, NULL);
	return self;
}


static void vala_literal_class_init (ValaLiteralClass * klass) {
	vala_literal_parent_class = g_type_class_peek_parent (klass);
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_literal_real_is_pure;
}


static void vala_literal_init (ValaLiteral * self) {
}


GType vala_literal_get_type (void) {
	static GType vala_literal_type_id = 0;
	if (G_UNLIKELY (vala_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLiteral), 0, (GInstanceInitFunc) vala_literal_init };
		vala_literal_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLiteral", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_literal_type_id;
}




