/* valabasicblock.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALABASICBLOCK_H__
#define __VALA_VALABASICBLOCK_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_BASIC_BLOCK (vala_basic_block_get_type ())
#define VALA_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlock))
#define VALA_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))
#define VALA_IS_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASIC_BLOCK))
#define VALA_IS_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASIC_BLOCK))
#define VALA_BASIC_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))

typedef struct _ValaBasicBlockPrivate ValaBasicBlockPrivate;

/**
 * Represents a basic block, i.e. a straight-line piece of code without any
 * jumps or jump targets.
 */
struct _ValaBasicBlock {
	GObject parent_instance;
	ValaBasicBlockPrivate * priv;
};
struct _ValaBasicBlockClass {
	GObjectClass parent_class;
};

ValaBasicBlock* vala_basic_block_new (void);
ValaBasicBlock* vala_basic_block_new_entry (void);
ValaBasicBlock* vala_basic_block_new_exit (void);
void vala_basic_block_add_node (ValaBasicBlock* self, ValaCodeNode* node);
void vala_basic_block_connect (ValaBasicBlock* self, ValaBasicBlock* target);
GeeList* vala_basic_block_get_predecessors (ValaBasicBlock* self);
GeeList* vala_basic_block_get_successors (ValaBasicBlock* self);
GType vala_basic_block_get_type (void);


G_END_DECLS

#endif
