/* valaattribute.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaattribute.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valanamedargument.h>
#include <vala/valasourcereference.h>
#include <vala/valastringliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valaunaryexpression.h>
#include <vala/valabooleanliteral.h>




struct _ValaAttributePrivate {
	char* _name;
};
#define VALA_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ATTRIBUTE, ValaAttributePrivate))
enum  {
	VALA_ATTRIBUTE_DUMMY_PROPERTY,
	VALA_ATTRIBUTE_NAME
};
static gpointer vala_attribute_parent_class = NULL;
static void vala_attribute_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new attribute.
 *
 * @param name             attribute type name
 * @param source_reference reference to source code
 * @return                 newly created attribute
 */
ValaAttribute* vala_attribute_new (const char* name, ValaSourceReference* source_reference) {
	ValaAttribute * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_ATTRIBUTE, 0, NULL);
	vala_attribute_set_name (self, name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


/**
 * Adds an attribute argument.
 *
 * @param arg named argument
 */
void vala_attribute_add_argument (ValaAttribute* self, ValaNamedArgument* arg) {
	g_return_if_fail (VALA_IS_ATTRIBUTE (self));
	g_return_if_fail (VALA_IS_NAMED_ARGUMENT (arg));
	gee_collection_add (GEE_COLLECTION (self->args), arg);
}


/**
 * Returns whether this attribute has the specified named argument.
 *
 * @param name argument name
 * @return     true if the argument has been found, false otherwise
 */
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	/* FIXME: use hash table*/
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = self->args;
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaNamedArgument* arg;
			arg = ((ValaNamedArgument*) gee_iterator_get (arg_it));
			{
				if (_vala_strcmp0 (vala_named_argument_get_name (arg), name) == 0) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp0);
				}
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return FALSE;
}


/**
 * Returns the string value of the specified named argument.
 *
 * @param name argument name
 * @return     string value
 */
char* vala_attribute_get_string (ValaAttribute* self, const char* name) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	/* FIXME: use hash table*/
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = self->args;
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaNamedArgument* arg;
			arg = ((ValaNamedArgument*) gee_iterator_get (arg_it));
			{
				if (_vala_strcmp0 (vala_named_argument_get_name (arg), name) == 0) {
					ValaStringLiteral* _tmp1;
					ValaExpression* _tmp0;
					ValaStringLiteral* lit;
					_tmp1 = NULL;
					_tmp0 = NULL;
					lit = (_tmp1 = (_tmp0 = vala_named_argument_get_argument (arg), (VALA_IS_STRING_LITERAL (_tmp0) ? ((ValaStringLiteral*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
					if (lit != NULL) {
						char* _tmp2;
						_tmp2 = NULL;
						return (_tmp2 = vala_string_literal_eval (lit), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp2);
					}
					(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
				}
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return NULL;
}


/**
 * Returns the integer value of the specified named argument.
 *
 * @param name argument name
 * @return     integer value
 */
gint vala_attribute_get_integer (ValaAttribute* self, const char* name) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), 0);
	g_return_val_if_fail (name != NULL, 0);
	/* FIXME: use hash table*/
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = self->args;
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaNamedArgument* arg;
			arg = ((ValaNamedArgument*) gee_iterator_get (arg_it));
			{
				if (_vala_strcmp0 (vala_named_argument_get_name (arg), name) == 0) {
					ValaIntegerLiteral* _tmp1;
					ValaExpression* _tmp0;
					ValaIntegerLiteral* lit;
					_tmp1 = NULL;
					_tmp0 = NULL;
					lit = (_tmp1 = (_tmp0 = vala_named_argument_get_argument (arg), (VALA_IS_INTEGER_LITERAL (_tmp0) ? ((ValaIntegerLiteral*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
					if (lit != NULL) {
						gint _tmp2;
						return (_tmp2 = atoi (vala_integer_literal_get_value (lit)), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp2);
					}
					(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
				}
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return 0;
}


/**
 * Returns the double value of the specified named argument.
 *
 * @param name argument name
 * @return     double value
 */
double vala_attribute_get_double (ValaAttribute* self, const char* name) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	/* FIXME: use hash table*/
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = self->args;
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaNamedArgument* arg;
			arg = ((ValaNamedArgument*) gee_iterator_get (arg_it));
			{
				if (_vala_strcmp0 (vala_named_argument_get_name (arg), name) == 0) {
					if (VALA_IS_REAL_LITERAL (vala_named_argument_get_argument (arg))) {
						ValaRealLiteral* _tmp0;
						ValaRealLiteral* lit;
						double _tmp1;
						_tmp0 = NULL;
						lit = (_tmp0 = VALA_REAL_LITERAL (vala_named_argument_get_argument (arg)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
						return (_tmp1 = strtod (vala_real_literal_get_value (lit), NULL), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp1);
					} else {
						if (VALA_IS_INTEGER_LITERAL (vala_named_argument_get_argument (arg))) {
							ValaIntegerLiteral* _tmp2;
							ValaIntegerLiteral* lit;
							gint _tmp3;
							_tmp2 = NULL;
							lit = (_tmp2 = VALA_INTEGER_LITERAL (vala_named_argument_get_argument (arg)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
							return ((double) (_tmp3 = atoi (vala_integer_literal_get_value (lit)), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp3));
						} else {
							if (VALA_IS_UNARY_EXPRESSION (vala_named_argument_get_argument (arg))) {
								ValaUnaryExpression* _tmp4;
								ValaUnaryExpression* unary;
								_tmp4 = NULL;
								unary = (_tmp4 = VALA_UNARY_EXPRESSION (vala_named_argument_get_argument (arg)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
								if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_MINUS) {
									if (VALA_IS_REAL_LITERAL (vala_unary_expression_get_inner (unary))) {
										ValaRealLiteral* _tmp5;
										ValaRealLiteral* lit;
										double _tmp6;
										_tmp5 = NULL;
										lit = (_tmp5 = VALA_REAL_LITERAL (vala_unary_expression_get_inner (unary)), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
										return (_tmp6 = -strtod (vala_real_literal_get_value (lit), NULL), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp6);
									} else {
										if (VALA_IS_INTEGER_LITERAL (vala_unary_expression_get_inner (unary))) {
											ValaIntegerLiteral* _tmp7;
											ValaIntegerLiteral* lit;
											gint _tmp8;
											_tmp7 = NULL;
											lit = (_tmp7 = VALA_INTEGER_LITERAL (vala_unary_expression_get_inner (unary)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
											return ((double) (_tmp8 = -atoi (vala_integer_literal_get_value (lit)), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp8));
										}
									}
								}
								(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							}
						}
					}
				}
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return ((double) 0);
}


/**
 * Returns the boolean value of the specified named argument.
 *
 * @param name argument name
 * @return     boolean value
 */
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	/* FIXME: use hash table*/
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = self->args;
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaNamedArgument* arg;
			arg = ((ValaNamedArgument*) gee_iterator_get (arg_it));
			{
				if (_vala_strcmp0 (vala_named_argument_get_name (arg), name) == 0) {
					ValaBooleanLiteral* _tmp1;
					ValaExpression* _tmp0;
					ValaBooleanLiteral* lit;
					_tmp1 = NULL;
					_tmp0 = NULL;
					lit = (_tmp1 = (_tmp0 = vala_named_argument_get_argument (arg), (VALA_IS_BOOLEAN_LITERAL (_tmp0) ? ((ValaBooleanLiteral*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
					if (lit != NULL) {
						gboolean _tmp2;
						return (_tmp2 = vala_boolean_literal_get_value (lit), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL))), _tmp2);
					}
					(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
				}
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return FALSE;
}


char* vala_attribute_get_name (ValaAttribute* self) {
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), NULL);
	return self->priv->_name;
}


void vala_attribute_set_name (ValaAttribute* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_ATTRIBUTE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


static void vala_attribute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaAttribute * self;
	self = VALA_ATTRIBUTE (object);
	switch (property_id) {
		case VALA_ATTRIBUTE_NAME:
		g_value_set_string (value, vala_attribute_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_attribute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaAttribute * self;
	self = VALA_ATTRIBUTE (object);
	switch (property_id) {
		case VALA_ATTRIBUTE_NAME:
		vala_attribute_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_attribute_class_init (ValaAttributeClass * klass) {
	vala_attribute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaAttributePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_attribute_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_attribute_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_attribute_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ATTRIBUTE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_attribute_init (ValaAttribute * self) {
	self->priv = VALA_ATTRIBUTE_GET_PRIVATE (self);
	self->args = GEE_LIST (gee_array_list_new (VALA_TYPE_NAMED_ARGUMENT, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_attribute_dispose (GObject * obj) {
	ValaAttribute * self;
	self = VALA_ATTRIBUTE (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->args == NULL ? NULL : (self->args = (g_object_unref (self->args), NULL)));
	G_OBJECT_CLASS (vala_attribute_parent_class)->dispose (obj);
}


GType vala_attribute_get_type (void) {
	static GType vala_attribute_type_id = 0;
	if (G_UNLIKELY (vala_attribute_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttribute), 0, (GInstanceInitFunc) vala_attribute_init };
		vala_attribute_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaAttribute", &g_define_type_info, 0);
	}
	return vala_attribute_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




