/* valaarraytype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraytype.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valacodenode.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valanamespace.h>
#include <vala/valavaluetype.h>
#include <vala/valascope.h>
#include <vala/valatypesymbol.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valavoidtype.h>
#include <vala/valaformalparameter.h>
#include <vala/valapointertype.h>




struct _ValaArrayTypePrivate {
	ValaDataType* _element_type;
	gint _rank;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY,
	VALA_ARRAY_TYPE_ELEMENT_TYPE,
	VALA_ARRAY_TYPE_RANK
};
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static char* vala_array_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
static char* vala_array_type_real_to_string (ValaCodeNode* base);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static gpointer vala_array_type_parent_class = NULL;
static void vala_array_type_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaArrayType * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (element_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "element-type";
	g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE);
	g_value_set_object (&__params_it->value, element_type);
	__params_it++;
	__params_it->name = "rank";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, rank);
	__params_it++;
	self = g_object_newv (VALA_TYPE_ARRAY_TYPE, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (base);
	g_return_val_if_fail (member_name != NULL, NULL);
	if (_vala_strcmp0 (member_name, "length") == 0) {
		return VALA_SYMBOL (vala_array_type_get_length_field (self));
	} else {
		if (_vala_strcmp0 (member_name, "move") == 0) {
			return VALA_SYMBOL (vala_array_type_get_move_method (self));
		} else {
			if (_vala_strcmp0 (member_name, "resize") == 0) {
				return VALA_SYMBOL (vala_array_type_get_resize_method (self));
			}
		}
	}
	return NULL;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* _tmp7;
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	if (self->priv->length_field == NULL) {
		ValaArrayLengthField* _tmp0;
		ValaNamespace* _tmp1;
		ValaNamespace* root_symbol;
		_tmp0 = NULL;
		self->priv->length_field = (_tmp0 = vala_array_length_field_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL))), _tmp0);
		vala_symbol_set_access (VALA_SYMBOL (self->priv->length_field), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp1 = NULL;
		root_symbol = (_tmp1 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (self->priv->_rank > 1) {
			ValaTypesymbol* _tmp2;
			ValaValueType* _tmp3;
			ValaValueType* integer;
			ValaArrayType* _tmp4;
			/* length is an int[] containing the dimensions of the array, starting at 0*/
			_tmp2 = NULL;
			_tmp3 = NULL;
			integer = (_tmp3 = vala_value_type_new ((_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
			_tmp4 = NULL;
			vala_field_set_type_reference (VALA_FIELD (self->priv->length_field), VALA_DATA_TYPE ((_tmp4 = vala_array_type_new (VALA_DATA_TYPE (integer), 1, vala_code_node_get_source_reference (VALA_CODE_NODE (self))))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
			vala_data_type_add_type_argument (vala_field_get_type_reference (VALA_FIELD (self->priv->length_field)), VALA_DATA_TYPE (integer));
			(integer == NULL ? NULL : (integer = (g_object_unref (integer), NULL)));
		} else {
			ValaValueType* _tmp6;
			ValaTypesymbol* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_field_set_type_reference (VALA_FIELD (self->priv->length_field), VALA_DATA_TYPE ((_tmp6 = vala_value_type_new ((_tmp5 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int")))))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		}
		(root_symbol == NULL ? NULL : (root_symbol = (g_object_unref (root_symbol), NULL)));
	}
	_tmp7 = NULL;
	return (_tmp7 = self->priv->length_field, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* _tmp6;
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	if (self->priv->resize_method == NULL) {
		ValaArrayResizeMethod* _tmp0;
		ValaVoidType* _tmp1;
		ValaNamespace* _tmp2;
		ValaNamespace* root_symbol;
		ValaTypesymbol* _tmp3;
		ValaValueType* _tmp4;
		ValaValueType* int_type;
		ValaFormalParameter* _tmp5;
		_tmp0 = NULL;
		self->priv->resize_method = (_tmp0 = vala_array_resize_method_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL))), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type (VALA_METHOD (self->priv->resize_method), VALA_DATA_TYPE ((_tmp1 = vala_void_type_new ())));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_symbol_set_access (VALA_SYMBOL (self->priv->resize_method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname (VALA_METHOD (self->priv->resize_method), "g_renew");
		_tmp2 = NULL;
		root_symbol = (_tmp2 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
		_tmp3 = NULL;
		_tmp4 = NULL;
		int_type = (_tmp4 = vala_value_type_new ((_tmp3 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
		_tmp5 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->resize_method), (_tmp5 = vala_formal_parameter_new ("length", VALA_DATA_TYPE (int_type), NULL)));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		vala_method_set_returns_modified_pointer (VALA_METHOD (self->priv->resize_method), TRUE);
		(root_symbol == NULL ? NULL : (root_symbol = (g_object_unref (root_symbol), NULL)));
		(int_type == NULL ? NULL : (int_type = (g_object_unref (int_type), NULL)));
	}
	_tmp6 = NULL;
	return (_tmp6 = self->priv->resize_method, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* _tmp8;
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	if (self->priv->move_method == NULL) {
		ValaArrayMoveMethod* _tmp0;
		ValaVoidType* _tmp1;
		ValaNamespace* _tmp2;
		ValaNamespace* root_symbol;
		ValaTypesymbol* _tmp3;
		ValaValueType* _tmp4;
		ValaValueType* int_type;
		ValaFormalParameter* _tmp5;
		ValaFormalParameter* _tmp6;
		ValaFormalParameter* _tmp7;
		_tmp0 = NULL;
		self->priv->move_method = (_tmp0 = vala_array_move_method_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->move_method == NULL ? NULL : (self->priv->move_method = (g_object_unref (self->priv->move_method), NULL))), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type (VALA_METHOD (self->priv->move_method), VALA_DATA_TYPE ((_tmp1 = vala_void_type_new ())));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_symbol_set_access (VALA_SYMBOL (self->priv->move_method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname (VALA_METHOD (self->priv->move_method), "_vala_array_move");
		_tmp2 = NULL;
		root_symbol = (_tmp2 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
		_tmp3 = NULL;
		_tmp4 = NULL;
		int_type = (_tmp4 = vala_value_type_new ((_tmp3 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
		_tmp5 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp5 = vala_formal_parameter_new ("src", VALA_DATA_TYPE (int_type), NULL)));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp6 = vala_formal_parameter_new ("dest", VALA_DATA_TYPE (int_type), NULL)));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		_tmp7 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp7 = vala_formal_parameter_new ("length", VALA_DATA_TYPE (int_type), NULL)));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		(root_symbol == NULL ? NULL : (root_symbol = (g_object_unref (root_symbol), NULL)));
		(int_type == NULL ? NULL : (int_type = (g_object_unref (int_type), NULL)));
	}
	_tmp8 = NULL;
	return (_tmp8 = self->priv->move_method, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaArrayType* result;
	self = VALA_ARRAY_TYPE (base);
	result = vala_array_type_new (self->priv->_element_type, self->priv->_rank, vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_transfers_ownership (VALA_DATA_TYPE (result), vala_data_type_get_transfers_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_takes_ownership (VALA_DATA_TYPE (result), vala_data_type_get_takes_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaDataType* arg;
			arg = ((ValaDataType*) gee_iterator_get (arg_it));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_array_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type) {
	ValaArrayType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_ARRAY_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat ((_tmp0 = vala_data_type_get_cname (self->priv->_element_type, FALSE, FALSE)), "*", NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (base);
	return TRUE;
}


static char* vala_array_type_real_to_string (ValaCodeNode* base) {
	ValaArrayType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_ARRAY_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat ((_tmp0 = vala_code_node_to_string (VALA_CODE_NODE (self->priv->_element_type))), "[]", NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	ValaArrayType* _tmp5;
	ValaDataType* _tmp4;
	ValaArrayType* target_array_type;
	gboolean _tmp8;
	self = VALA_ARRAY_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_POINTER_TYPE (target_type) || (vala_data_type_get_data_type (target_type) != NULL && (_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (vala_data_type_get_data_type (target_type)), "PointerType")) != NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
		/* any array type can be cast to a generic pointer */
		return TRUE;
	}
	/* temporarily ignore type parameters */
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		return TRUE;
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	target_array_type = (_tmp5 = (_tmp4 = target_type, (VALA_IS_ARRAY_TYPE (_tmp4) ? ((ValaArrayType*) _tmp4) : NULL)), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	if (target_array_type == NULL) {
		gboolean _tmp6;
		return (_tmp6 = FALSE, (target_array_type == NULL ? NULL : (target_array_type = (g_object_unref (target_array_type), NULL))), _tmp6);
	}
	if (vala_data_type_compatible (self->priv->_element_type, target_array_type->priv->_element_type) && vala_data_type_compatible (target_array_type->priv->_element_type, self->priv->_element_type)) {
		gboolean _tmp7;
		return (_tmp7 = TRUE, (target_array_type == NULL ? NULL : (target_array_type = (g_object_unref (target_array_type), NULL))), _tmp7);
	}
	return (_tmp8 = FALSE, (target_array_type == NULL ? NULL : (target_array_type = (g_object_unref (target_array_type), NULL))), _tmp8);
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (base);
	return TRUE;
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	return self->priv->_element_type;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	g_return_if_fail (VALA_IS_ARRAY_TYPE (self));
	self->priv->_element_type = value;
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), 0);
	return self->priv->_rank;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (VALA_IS_ARRAY_TYPE (self));
	self->priv->_rank = value;
}


static void vala_array_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_type_get_element_type (self));
		break;
		case VALA_ARRAY_TYPE_RANK:
		g_value_set_int (value, vala_array_type_get_rank (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		vala_array_type_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_TYPE_RANK:
		vala_array_type_set_rank (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_array_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_array_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_array_type_real_to_string;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_array_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_array_type_real_is_reference_type_or_type_parameter;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_TYPE_ELEMENT_TYPE, g_param_spec_object ("element-type", "element-type", "element-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_TYPE_RANK, g_param_spec_int ("rank", "rank", "rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_type_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_dispose (GObject * obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	(self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL)));
	(self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL)));
	(self->priv->move_method == NULL ? NULL : (self->priv->move_method = (g_object_unref (self->priv->move_method), NULL)));
	G_OBJECT_CLASS (vala_array_type_parent_class)->dispose (obj);
}


GType vala_array_type_get_type (void) {
	static GType vala_array_type_type_id = 0;
	if (G_UNLIKELY (vala_array_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_init };
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	}
	return vala_array_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




