/* valaccodetypesymbolbinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodetypesymbolbinding.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaenum.h>
#include <vala/valacodenode.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valasymbol.h>
#include <gee/collection.h>
#include <gee/list.h>
#include <vala/valapointertype.h>
#include <vala/valaerrortype.h>
#include <vala/valaformalparameter.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_TYPESYMBOL_BINDING_DUMMY_PROPERTY
};
static gpointer vala_ccode_typesymbol_binding_parent_class = NULL;



ValaCCodeFunctionCall* vala_ccode_typesymbol_binding_get_param_spec (ValaCCodeTypesymbolBinding* self, ValaProperty* prop) {
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp2;
	char* _tmp1;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* pflags;
	ValaCCodeConstant* _tmp57;
	ValaCCodeFunctionCall* _tmp58;
	g_return_val_if_fail (VALA_IS_CCODE_TYPESYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp0 = vala_property_get_canonical_cconstant (prop))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("\"%s\"", vala_property_get_nick (prop)))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = g_strdup_printf ("\"%s\"", vala_property_get_blurb (prop)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if ((VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_type_reference (prop))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_property_get_type_reference (prop))))), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* _tmp5;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_param_spec_object"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_property_get_type_reference (prop)), "TYPE_"))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
	} else {
		if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeConstant* _tmp9;
			_tmp8 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			_tmp9 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
			(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaEnum* _tmp11;
				ValaTypesymbol* _tmp10;
				ValaEnum* e;
				_tmp11 = NULL;
				_tmp10 = NULL;
				e = (_tmp11 = (_tmp10 = vala_data_type_get_data_type (vala_property_get_type_reference (prop)), (VALA_IS_ENUM (_tmp10) ? ((ValaEnum*) _tmp10) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
				if (vala_enum_get_has_type_id (e)) {
					ValaCCodeIdentifier* _tmp15;
					char* _tmp14;
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp12;
						_tmp12 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_param_spec_flags"))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp13;
						_tmp13 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_param_spec_enum"))));
						(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					}
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (e)))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					_tmp14 = (g_free (_tmp14), NULL);
				} else {
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeConstant* _tmp17;
						ValaCCodeConstant* _tmp18;
						_tmp16 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("g_param_spec_uint"))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("0"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("G_MAXUINT"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp19;
						ValaCCodeConstant* _tmp20;
						ValaCCodeConstant* _tmp21;
						_tmp19 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("g_param_spec_int"))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("G_MININT"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("G_MAXINT"))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					}
				}
				if (vala_property_get_default_expression (prop) != NULL) {
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
				} else {
					ValaCCodeConstant* _tmp23;
					char* _tmp22;
					_tmp23 = NULL;
					_tmp22 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ((_tmp22 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_property_get_type_reference (prop))))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					_tmp22 = (g_free (_tmp22), NULL);
				}
				(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
			} else {
				if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type)) {
					ValaCCodeIdentifier* _tmp24;
					ValaCCodeConstant* _tmp25;
					ValaCCodeConstant* _tmp26;
					_tmp24 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_param_spec_int"))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp25 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("G_MININT"))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					_tmp26 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ("G_MAXINT"))));
					(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
					if (vala_property_get_default_expression (prop) != NULL) {
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
					} else {
						ValaCCodeConstant* _tmp27;
						_tmp27 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("0"))));
						(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
					}
				} else {
					if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->uint_type)) {
						ValaCCodeIdentifier* _tmp28;
						ValaCCodeConstant* _tmp29;
						ValaCCodeConstant* _tmp30;
						_tmp28 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("g_param_spec_uint"))));
						(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
						_tmp29 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("0"))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						_tmp30 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("G_MAXUINT"))));
						(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
						if (vala_property_get_default_expression (prop) != NULL) {
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
						} else {
							ValaCCodeConstant* _tmp31;
							_tmp31 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("0U"))));
							(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
						}
					} else {
						if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->long_type)) {
							ValaCCodeIdentifier* _tmp32;
							ValaCCodeConstant* _tmp33;
							ValaCCodeConstant* _tmp34;
							_tmp32 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("g_param_spec_long"))));
							(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
							_tmp33 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("G_MINLONG"))));
							(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
							_tmp34 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("G_MAXLONG"))));
							(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
							if (vala_property_get_default_expression (prop) != NULL) {
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
							} else {
								ValaCCodeConstant* _tmp35;
								_tmp35 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("0L"))));
								(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
							}
						} else {
							if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->ulong_type)) {
								ValaCCodeIdentifier* _tmp36;
								ValaCCodeConstant* _tmp37;
								ValaCCodeConstant* _tmp38;
								_tmp36 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
								(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
								_tmp37 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("0"))));
								(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
								_tmp38 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_constant_new ("G_MAXULONG"))));
								(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
								if (vala_property_get_default_expression (prop) != NULL) {
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
								} else {
									ValaCCodeConstant* _tmp39;
									_tmp39 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new ("0UL"))));
									(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
								}
							} else {
								if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->bool_type)) {
									ValaCCodeIdentifier* _tmp40;
									_tmp40 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
									(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
									if (vala_property_get_default_expression (prop) != NULL) {
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
									} else {
										ValaCCodeConstant* _tmp41;
										_tmp41 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("FALSE"))));
										(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
									}
								} else {
									if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->float_type)) {
										ValaCCodeIdentifier* _tmp42;
										ValaCCodeConstant* _tmp43;
										ValaCCodeConstant* _tmp44;
										_tmp42 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("g_param_spec_float"))));
										(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
										_tmp43 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
										(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
										_tmp44 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_constant_new ("G_MAXFLOAT"))));
										(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
										if (vala_property_get_default_expression (prop) != NULL) {
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
										} else {
											ValaCCodeConstant* _tmp45;
											_tmp45 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_constant_new ("0.0F"))));
											(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
										}
									} else {
										if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->double_type)) {
											ValaCCodeIdentifier* _tmp46;
											ValaCCodeConstant* _tmp47;
											ValaCCodeConstant* _tmp48;
											_tmp46 = NULL;
											vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("g_param_spec_double"))));
											(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
											_tmp47 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
											(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
											_tmp48 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
											(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
											if (vala_property_get_default_expression (prop) != NULL) {
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
											} else {
												ValaCCodeConstant* _tmp49;
												_tmp49 = NULL;
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("0.0"))));
												(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
											}
										} else {
											if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtype_type) {
												ValaCCodeIdentifier* _tmp50;
												_tmp50 = NULL;
												vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("g_param_spec_gtype"))));
												(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
												if (vala_property_get_default_expression (prop) != NULL) {
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
												} else {
													ValaCCodeConstant* _tmp51;
													_tmp51 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_constant_new ("G_TYPE_NONE"))));
													(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
												}
											} else {
												ValaCCodeIdentifier* _tmp52;
												_tmp52 = NULL;
												vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
												(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp53;
		_tmp53 = NULL;
		pflags = (_tmp53 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), _tmp53);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp54;
		_tmp54 = NULL;
		pflags = (_tmp54 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), _tmp54);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp55;
				_tmp55 = NULL;
				pflags = (_tmp55 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), _tmp55);
			} else {
				char* _tmp56;
				_tmp56 = NULL;
				pflags = (_tmp56 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), _tmp56);
			}
		}
	}
	_tmp57 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_constant_new (pflags))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	_tmp58 = NULL;
	return (_tmp58 = cspec, (pflags = (g_free (pflags), NULL)), _tmp58);
}


ValaCCodeFunctionCall* vala_ccode_typesymbol_binding_get_signal_creation (ValaCCodeTypesymbolBinding* self, ValaSignal* sig, ValaTypesymbol* type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	GeeList* _tmp10;
	char* _tmp11;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gint params_len;
	ValaCCodeConstant* _tmp18;
	char* _tmp17;
	ValaCCodeFunctionCall* _tmp23;
	g_return_val_if_fail (VALA_IS_CCODE_TYPESYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_signal_new")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ((_tmp2 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (sig))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_upper_case_cname (type, "TYPE_"))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	_tmp11 = NULL;
	marshaller = (_tmp11 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_COLLECTION ((_tmp10 = vala_signal_get_parameters (sig))), vala_signal_get_return_type (sig), NULL), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp11);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_signal_get_parameters (sig);
	params_len = gee_collection_get_size (GEE_COLLECTION (params));
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig)) || vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp12;
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp13;
			_tmp13 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp14;
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("G_TYPE_NONE"))));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			} else {
				ValaCCodeConstant* _tmp16;
				char* _tmp15;
				_tmp16 = NULL;
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ((_tmp15 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))))));
				(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				_tmp15 = (g_free (_tmp15), NULL);
			}
		}
	}
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ((_tmp17 = g_strdup_printf ("%d", params_len))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp17 = (g_free (_tmp17), NULL);
	{
		GeeList* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL || vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					ValaCCodeConstant* _tmp19;
					_tmp19 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				} else {
					if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_type_reference (param))) {
						ValaCCodeConstant* _tmp20;
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
					} else {
						ValaCCodeConstant* _tmp22;
						char* _tmp21;
						_tmp22 = NULL;
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ((_tmp21 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
						(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
						_tmp21 = (g_free (_tmp21), NULL);
					}
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp23 = NULL;
	return (_tmp23 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp23);
}


ValaCCodeTypesymbolBinding* vala_ccode_typesymbol_binding_new (void) {
	ValaCCodeTypesymbolBinding * self;
	self = g_object_newv (VALA_TYPE_CCODE_TYPESYMBOL_BINDING, 0, NULL);
	return self;
}


static void vala_ccode_typesymbol_binding_class_init (ValaCCodeTypesymbolBindingClass * klass) {
	vala_ccode_typesymbol_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_typesymbol_binding_init (ValaCCodeTypesymbolBinding * self) {
}


GType vala_ccode_typesymbol_binding_get_type (void) {
	static GType vala_ccode_typesymbol_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_typesymbol_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeTypesymbolBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_typesymbol_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeTypesymbolBinding), 0, (GInstanceInitFunc) vala_ccode_typesymbol_binding_init };
		vala_ccode_typesymbol_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeTypesymbolBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_typesymbol_binding_type_id;
}




