/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodemethodbinding.h>
#include <vala/valacreationmethod.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaclasstype.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>
#include <vala/valainterface.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valastruct.h>
#include <vala/valainterfacetype.h>
#include <vala/valavaluetype.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodestruct.h>
#include <vala/valatypeparameter.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valamethodtype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeMethodBindingPrivate {
	ValaMethod* _method;
};
#define VALA_CCODE_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingPrivate))
enum  {
	VALA_CCODE_METHOD_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_METHOD_BINDING_METHOD,
	VALA_CCODE_METHOD_BINDING_HAS_WRAPPER
};
static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base);
static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition);
static ValaTypesymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym);
static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params);
static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl);
static gpointer vala_ccode_method_binding_parent_class = NULL;
static void vala_ccode_method_binding_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCCodeGenerator* codegen, ValaMethod* method) {
	ValaCCodeMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_METHOD_BINDING, 0, NULL);
	vala_ccode_method_binding_set_method (self, method);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMethodBinding * self;
	ValaMethod* _tmp0;
	ValaMethod* m;
	ValaMethod* _tmp1;
	ValaMethod* old_method;
	ValaDataType* _tmp2;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp4;
	ValaMethod* _tmp3;
	ValaMethod* _tmp6;
	ValaMethod* _tmp5;
	ValaDataType* _tmp8;
	ValaDataType* _tmp7;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp9;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp19;
	ValaSymbol* _tmp18;
	ValaMethod* _tmp21;
	ValaMethod* _tmp20;
	ValaDataType* _tmp23;
	ValaDataType* _tmp22;
	ValaCCodeFunction* _tmp27;
	char* _tmp26;
	char* _tmp25;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CCODE_METHOD_BINDING (base);
	_tmp0 = NULL;
	m = (_tmp0 = self->priv->_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_method = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_return_type = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	old_method_inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	old_next_temp_var_id = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp4 = VALA_SYMBOL ((_tmp3 = m, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp6 = (_tmp5 = m, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp8 = (_tmp7 = vala_method_get_return_type (m), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp8);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = FALSE;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp9 = NULL;
	creturn_type = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp11;
		ValaTypesymbol* _tmp10;
		ValaClass* cl;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = TRUE;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cl = (_tmp11 = (_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (VALA_IS_CLASS (_tmp10) ? ((ValaClass*) _tmp10) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (cl != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type)) {
			in_gtypeinstance_creation_method = TRUE;
			if (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp12;
			_tmp12 = NULL;
			creturn_type = (_tmp12 = VALA_DATA_TYPE (vala_class_type_new (cl)), (creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL))), _tmp12);
		}
		(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			GeeCollection* _tmp15;
			cblock = vala_ccode_block_new ();
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (stmt_it)));
					{
						ValaProperty* _tmp13;
						gboolean _tmp14;
						_tmp13 = NULL;
						if ((_tmp14 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp13 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			_tmp15 = NULL;
			vala_ccode_method_binding_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size ((_tmp15 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0);
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (stmt_it)));
					{
						ValaProperty* _tmp16;
						gboolean _tmp17;
						_tmp16 = NULL;
						if ((_tmp17 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp16 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), _tmp17)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = FALSE;
	}
	inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp19 = (_tmp18 = vala_symbol_get_parent_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp19);
	_tmp21 = NULL;
	_tmp20 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp21 = (_tmp20 = old_method, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp21);
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp23 = (_tmp22 = old_return_type, (_tmp22 == NULL ? NULL : g_object_ref (_tmp22))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp23);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = old_method_inner_error;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
		ValaInterface* _tmp24;
		ValaInterface* iface;
		_tmp24 = NULL;
		iface = (_tmp24 = VALA_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (_tmp27 = vala_ccode_function_new ((_tmp25 = vala_method_get_real_cname (m)), (_tmp26 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), NULL))), _tmp27);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp25 = (g_free (_tmp25), NULL);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	if (vala_method_get_instance (m) || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m))) {
		ValaTypesymbol* parent_type;
		ValaDataType* this_type;
		ValaCCodeFormalParameter* instance_param;
		parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
		this_type = NULL;
		if (VALA_IS_CLASS (parent_type)) {
			ValaDataType* _tmp28;
			_tmp28 = NULL;
			this_type = (_tmp28 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp28);
		} else {
			if (VALA_IS_INTERFACE (parent_type)) {
				ValaDataType* _tmp29;
				_tmp29 = NULL;
				this_type = (_tmp29 = VALA_DATA_TYPE (vala_interface_type_new (VALA_INTERFACE (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp29);
			} else {
				ValaDataType* _tmp30;
				_tmp30 = NULL;
				this_type = (_tmp30 = VALA_DATA_TYPE (vala_value_type_new (parent_type)), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp30);
			}
		}
		instance_param = NULL;
		if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
			ValaInterfaceType* base_type;
			ValaCCodeFormalParameter* _tmp32;
			char* _tmp31;
			base_type = vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))));
			_tmp32 = NULL;
			_tmp31 = NULL;
			instance_param = (_tmp32 = vala_ccode_formal_parameter_new ("base", (_tmp31 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type), FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp32);
			_tmp31 = (g_free (_tmp31), NULL);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaClassType* base_type;
				ValaCCodeFormalParameter* _tmp34;
				char* _tmp33;
				base_type = vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))));
				_tmp34 = NULL;
				_tmp33 = NULL;
				instance_param = (_tmp34 = vala_ccode_formal_parameter_new ("base", (_tmp33 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type), FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp34);
				_tmp33 = (g_free (_tmp33), NULL);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))) {
					ValaCCodeFormalParameter* _tmp36;
					char* _tmp35;
					_tmp36 = NULL;
					_tmp35 = NULL;
					instance_param = (_tmp36 = vala_ccode_formal_parameter_new ("*self", (_tmp35 = vala_data_type_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp36);
					_tmp35 = (g_free (_tmp35), NULL);
				} else {
					ValaCCodeFormalParameter* _tmp38;
					char* _tmp37;
					_tmp38 = NULL;
					_tmp37 = NULL;
					instance_param = (_tmp38 = vala_ccode_formal_parameter_new ("self", (_tmp37 = vala_data_type_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp38);
					_tmp37 = (g_free (_tmp37), NULL);
				}
			}
		}
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* _tmp39;
			ValaCCodeDeclaration* _tmp40;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp41;
			_tmp39 = NULL;
			_tmp40 = NULL;
			vdecl = (_tmp40 = vala_ccode_declaration_new ((_tmp39 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp39 = (g_free (_tmp39), NULL)), _tmp40);
			_tmp41 = NULL;
			vdeclarator = (_tmp41 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), _tmp41);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, vdecl);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	}
	if (in_fundamental_creation_method) {
		ValaCCodeFormalParameter* _tmp42;
		_tmp42 = NULL;
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), (_tmp42 = vala_ccode_formal_parameter_new ("type", "GType")));
		(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	}
	if (in_gobject_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) gee_iterator_get (type_param_it));
				{
					ValaCCodeFormalParameter* _tmp45;
					char* _tmp44;
					char* _tmp43;
					ValaCCodeFormalParameter* _tmp48;
					char* _tmp47;
					char* _tmp46;
					ValaCCodeFormalParameter* _tmp51;
					char* _tmp50;
					char* _tmp49;
					_tmp45 = NULL;
					_tmp44 = NULL;
					_tmp43 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.01, FALSE)), (_tmp45 = vala_ccode_formal_parameter_new ((_tmp44 = g_strdup_printf ("%s_type", (_tmp43 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GType")));
					(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
					_tmp44 = (g_free (_tmp44), NULL);
					_tmp43 = (g_free (_tmp43), NULL);
					_tmp48 = NULL;
					_tmp47 = NULL;
					_tmp46 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.02, FALSE)), (_tmp48 = vala_ccode_formal_parameter_new ((_tmp47 = g_strdup_printf ("%s_dup_func", (_tmp46 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
					_tmp47 = (g_free (_tmp47), NULL);
					_tmp46 = (g_free (_tmp46), NULL);
					_tmp51 = NULL;
					_tmp50 = NULL;
					_tmp49 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.03, FALSE)), (_tmp51 = vala_ccode_formal_parameter_new ((_tmp50 = g_strdup_printf ("%s_destroy_func", (_tmp49 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GDestroyNotify")));
					(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
					_tmp50 = (g_free (_tmp50), NULL);
					_tmp49 = (g_free (_tmp49), NULL);
					type_param_index++;
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
	}
	vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, GEE_MAP (cparam_map), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vdeclarator);
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp52;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp52 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp52 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		} else {
			ValaCCodeFunction* _tmp53;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp53 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp53 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
			vala_ccode_node_set_line (VALA_CCODE_NODE (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
				ValaClass* _tmp54;
				ValaClass* cl;
				_tmp54 = NULL;
				cl = (_tmp54 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaClassType* self_target_type;
					ValaCCodeIdentifier* _tmp61;
					ValaCCodeExpression* _tmp62;
					ValaCCodeExpression* cself;
					char* _tmp64;
					char* _tmp63;
					ValaCCodeDeclaration* _tmp65;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp66;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp56;
						ValaMethod* _tmp55;
						ValaReferenceType* _tmp57;
						_tmp56 = NULL;
						_tmp55 = NULL;
						base_method = (_tmp56 = (_tmp55 = vala_method_get_base_method (m), (_tmp55 == NULL ? NULL : g_object_ref (_tmp55))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp56);
						_tmp57 = NULL;
						base_expression_type = (_tmp57 = VALA_REFERENCE_TYPE (vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp57);
					} else {
						ValaMethod* _tmp59;
						ValaMethod* _tmp58;
						ValaReferenceType* _tmp60;
						_tmp59 = NULL;
						_tmp58 = NULL;
						base_method = (_tmp59 = (_tmp58 = vala_method_get_base_interface_method (m), (_tmp58 == NULL ? NULL : g_object_ref (_tmp58))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp59);
						_tmp60 = NULL;
						base_expression_type = (_tmp60 = VALA_REFERENCE_TYPE (vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp60);
					}
					self_target_type = vala_class_type_new (cl);
					_tmp61 = NULL;
					_tmp62 = NULL;
					cself = (_tmp62 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ("base"))), VALA_DATA_TYPE (base_expression_type), VALA_DATA_TYPE (self_target_type)), (_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL))), _tmp62);
					_tmp64 = NULL;
					_tmp63 = NULL;
					_tmp65 = NULL;
					cdecl_ = (_tmp65 = vala_ccode_declaration_new ((_tmp64 = g_strdup_printf ("%s *", (_tmp63 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp64 = (g_free (_tmp64), NULL)), (_tmp63 = (g_free (_tmp63), NULL)), _tmp65);
					_tmp66 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp66 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (g_object_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, VALA_TYPESYMBOL (cl), TRUE, "self");
						vala_ccode_node_set_line (VALA_CCODE_NODE (ccheckstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (ccheckstmt));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (g_object_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_method_get_parameters (m);
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) gee_iterator_get (param_it));
					{
						ValaTypesymbol* _tmp67;
						ValaTypesymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							break;
						}
						_tmp67 = NULL;
						t = (_tmp67 = vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)), (_tmp67 == NULL ? NULL : g_object_ref (_tmp67)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) && !vala_data_type_get_nullable (vala_formal_parameter_get_type_reference (param))), vala_symbol_get_name (VALA_SYMBOL (param)));
								if (type_check != NULL) {
									vala_ccode_node_set_line (VALA_CCODE_NODE (type_check), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
								}
								(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp70;
								ValaCCodeUnaryExpression* _tmp69;
								ValaCCodeIdentifier* _tmp68;
								ValaCCodeAssignment* _tmp71;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp72;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp70 = NULL;
								_tmp69 = NULL;
								_tmp68 = NULL;
								_tmp71 = NULL;
								a = (_tmp71 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))), VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), _tmp71);
								_tmp72 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp72 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (a)))));
								(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
								(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp74;
				ValaCCodeConstant* _tmp73;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp74 = NULL;
				_tmp73 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp74 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_constant_new ("NULL")))))));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* _tmp75;
				_tmp75 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp75 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
			}
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					GeeCollection* _tmp76;
					gboolean _tmp77;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp76 = NULL;
					if ((_tmp77 = n_params > 0 || gee_collection_get_size ((_tmp76 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0, (_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL))), _tmp77)) {
						ValaCCodeIdentifier* _tmp78;
						ValaCCodeFunctionCall* _tmp79;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp80;
						ValaCCodeConstant* _tmp83;
						char* _tmp82;
						GeeCollection* _tmp81;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp84;
						ValaCCodeDeclaration* _tmp85;
						ValaCCodeVariableDeclarator* _tmp87;
						ValaCCodeIdentifier* _tmp86;
						/* declare construction parameter array*/
						_tmp78 = NULL;
						_tmp79 = NULL;
						cparamsinit = (_tmp79 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ("g_new0")))), (_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL))), _tmp79);
						_tmp80 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
						_tmp83 = NULL;
						_tmp82 = NULL;
						_tmp81 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_constant_new ((_tmp82 = g_strdup_printf ("%i", (n_params + 3 * gee_collection_get_size ((_tmp81 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))))))))));
						(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
						_tmp82 = (g_free (_tmp82), NULL);
						(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp84 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp84 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp85 = NULL;
						cdecl_ = (_tmp85 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp85);
						_tmp87 = NULL;
						_tmp86 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp87 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ("__params")))))));
						(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
						(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeCollection* type_param_collection;
						GeeIterator* type_param_it;
						type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
						type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							type_param = ((ValaTypeParameter*) gee_iterator_get (type_param_it));
							{
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp90;
								char* _tmp89;
								char* _tmp88;
								ValaCCodeIdentifier* _tmp93;
								char* _tmp92;
								char* _tmp91;
								ValaCCodeExpressionStatement* _tmp96;
								ValaCCodeExpression* _tmp95;
								ValaValueType* _tmp94;
								ValaCCodeConstant* _tmp99;
								char* _tmp98;
								char* _tmp97;
								ValaCCodeIdentifier* _tmp102;
								char* _tmp101;
								char* _tmp100;
								ValaCCodeExpressionStatement* _tmp106;
								ValaCCodeExpression* _tmp105;
								ValaPointerType* _tmp104;
								ValaVoidType* _tmp103;
								ValaCCodeConstant* _tmp109;
								char* _tmp108;
								char* _tmp107;
								ValaCCodeIdentifier* _tmp112;
								char* _tmp111;
								char* _tmp110;
								ValaCCodeExpressionStatement* _tmp116;
								ValaCCodeExpression* _tmp115;
								ValaPointerType* _tmp114;
								ValaVoidType* _tmp113;
								prop_name = NULL;
								param_name = NULL;
								_tmp90 = NULL;
								_tmp89 = NULL;
								_tmp88 = NULL;
								prop_name = (_tmp90 = vala_ccode_constant_new ((_tmp89 = g_strdup_printf ("\"%s-type\"", (_tmp88 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp90);
								_tmp89 = (g_free (_tmp89), NULL);
								_tmp88 = (g_free (_tmp88), NULL);
								_tmp93 = NULL;
								_tmp92 = NULL;
								_tmp91 = NULL;
								param_name = (_tmp93 = vala_ccode_identifier_new ((_tmp92 = g_strdup_printf ("%s_type", (_tmp91 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp93);
								_tmp92 = (g_free (_tmp92), NULL);
								_tmp91 = (g_free (_tmp91), NULL);
								_tmp96 = NULL;
								_tmp95 = NULL;
								_tmp94 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp96 = vala_ccode_expression_statement_new ((_tmp95 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp94 = vala_value_type_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtype_type))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
								(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
								(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
								_tmp99 = NULL;
								_tmp98 = NULL;
								_tmp97 = NULL;
								prop_name = (_tmp99 = vala_ccode_constant_new ((_tmp98 = g_strdup_printf ("\"%s-dup-func\"", (_tmp97 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp99);
								_tmp98 = (g_free (_tmp98), NULL);
								_tmp97 = (g_free (_tmp97), NULL);
								_tmp102 = NULL;
								_tmp101 = NULL;
								_tmp100 = NULL;
								param_name = (_tmp102 = vala_ccode_identifier_new ((_tmp101 = g_strdup_printf ("%s_dup_func", (_tmp100 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp102);
								_tmp101 = (g_free (_tmp101), NULL);
								_tmp100 = (g_free (_tmp100), NULL);
								_tmp106 = NULL;
								_tmp105 = NULL;
								_tmp104 = NULL;
								_tmp103 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp106 = vala_ccode_expression_statement_new ((_tmp105 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp104 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp103 = vala_void_type_new ()))))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
								(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
								(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
								(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
								_tmp109 = NULL;
								_tmp108 = NULL;
								_tmp107 = NULL;
								prop_name = (_tmp109 = vala_ccode_constant_new ((_tmp108 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp107 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp109);
								_tmp108 = (g_free (_tmp108), NULL);
								_tmp107 = (g_free (_tmp107), NULL);
								_tmp112 = NULL;
								_tmp111 = NULL;
								_tmp110 = NULL;
								param_name = (_tmp112 = vala_ccode_identifier_new ((_tmp111 = g_strdup_printf ("%s_destroy_func", (_tmp110 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp112);
								_tmp111 = (g_free (_tmp111), NULL);
								_tmp110 = (g_free (_tmp110), NULL);
								_tmp116 = NULL;
								_tmp115 = NULL;
								_tmp114 = NULL;
								_tmp113 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp116 = vala_ccode_expression_statement_new ((_tmp115 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp114 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp113 = vala_void_type_new ()))))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
								(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
								(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
								(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL)));
								(param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
					}
				} else {
					if (in_fundamental_creation_method) {
						ValaClass* _tmp117;
						ValaClass* cl;
						char* _tmp119;
						char* _tmp118;
						ValaCCodeDeclaration* _tmp120;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp121;
						ValaCCodeFunctionCall* _tmp122;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp123;
						ValaCCodeVariableDeclarator* _tmp127;
						ValaCCodeCastExpression* _tmp126;
						char* _tmp125;
						char* _tmp124;
						_tmp117 = NULL;
						cl = (_tmp117 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp117 == NULL ? NULL : g_object_ref (_tmp117)));
						_tmp119 = NULL;
						_tmp118 = NULL;
						_tmp120 = NULL;
						cdecl_ = (_tmp120 = vala_ccode_declaration_new ((_tmp119 = g_strconcat ((_tmp118 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp119 = (g_free (_tmp119), NULL)), (_tmp118 = (g_free (_tmp118), NULL)), _tmp120);
						_tmp121 = NULL;
						_tmp122 = NULL;
						ccall = (_tmp122 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_identifier_new ("g_type_create_instance")))), (_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL))), _tmp122);
						_tmp123 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_identifier_new ("type"))));
						(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
						_tmp127 = NULL;
						_tmp126 = NULL;
						_tmp125 = NULL;
						_tmp124 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp127 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp125 = g_strconcat ((_tmp124 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))))))));
						(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
						(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
						_tmp125 = (g_free (_tmp125), NULL);
						_tmp124 = (g_free (_tmp124), NULL);
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						if (in_gtypeinstance_creation_method) {
							ValaClass* _tmp128;
							ValaClass* cl;
							char* _tmp130;
							char* _tmp129;
							ValaCCodeDeclaration* _tmp131;
							ValaCCodeDeclaration* cdecl_;
							ValaClass* fundamental_class;
							ValaCCodeIdentifier* _tmp133;
							char* _tmp132;
							ValaCCodeFunctionCall* _tmp134;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp136;
							char* _tmp135;
							ValaCCodeVariableDeclarator* _tmp137;
							_tmp128 = NULL;
							cl = (_tmp128 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp128 == NULL ? NULL : g_object_ref (_tmp128)));
							_tmp130 = NULL;
							_tmp129 = NULL;
							_tmp131 = NULL;
							cdecl_ = (_tmp131 = vala_ccode_declaration_new ((_tmp130 = g_strconcat ((_tmp129 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp130 = (g_free (_tmp130), NULL)), (_tmp129 = (g_free (_tmp129), NULL)), _tmp131);
							fundamental_class = vala_ccode_method_binding_find_fundamental_class (self, cl);
							_tmp133 = NULL;
							_tmp132 = NULL;
							_tmp134 = NULL;
							ccall = (_tmp134 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp133 = vala_ccode_identifier_new ((_tmp132 = vala_method_get_cname (vala_class_get_default_construction_method (fundamental_class))))))), (_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL))), (_tmp132 = (g_free (_tmp132), NULL)), _tmp134);
							_tmp136 = NULL;
							_tmp135 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp136 = vala_ccode_identifier_new ((_tmp135 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
							(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
							_tmp135 = (g_free (_tmp135), NULL);
							_tmp137 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp137 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
							(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
							(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							(fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						} else {
							if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
								ValaClass* _tmp138;
								ValaClass* cl;
								char* _tmp140;
								char* _tmp139;
								ValaCCodeDeclaration* _tmp141;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeIdentifier* _tmp142;
								ValaCCodeFunctionCall* _tmp143;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp145;
								char* _tmp144;
								ValaCCodeVariableDeclarator* _tmp146;
								_tmp138 = NULL;
								cl = (_tmp138 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp138 == NULL ? NULL : g_object_ref (_tmp138)));
								_tmp140 = NULL;
								_tmp139 = NULL;
								_tmp141 = NULL;
								cdecl_ = (_tmp141 = vala_ccode_declaration_new ((_tmp140 = g_strconcat ((_tmp139 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp140 = (g_free (_tmp140), NULL)), (_tmp139 = (g_free (_tmp139), NULL)), _tmp141);
								_tmp142 = NULL;
								_tmp143 = NULL;
								ccall = (_tmp143 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp142 == NULL ? NULL : (_tmp142 = (g_object_unref (_tmp142), NULL))), _tmp143);
								_tmp145 = NULL;
								_tmp144 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_identifier_new ((_tmp144 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
								(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
								_tmp144 = (g_free (_tmp144), NULL);
								_tmp146 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp146 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
								(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
								(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							} else {
								ValaStruct* _tmp147;
								ValaStruct* st;
								ValaCCodeIdentifier* _tmp148;
								ValaCCodeFunctionCall* _tmp149;
								ValaCCodeFunctionCall* czero;
								ValaCCodeIdentifier* _tmp150;
								ValaCCodeConstant* _tmp151;
								ValaCCodeIdentifier* _tmp154;
								char* _tmp153;
								char* _tmp152;
								ValaCCodeExpressionStatement* _tmp155;
								_tmp147 = NULL;
								st = (_tmp147 = VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp147 == NULL ? NULL : g_object_ref (_tmp147)));
								/* memset needs string.h*/
								vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
								_tmp148 = NULL;
								_tmp149 = NULL;
								czero = (_tmp149 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ("memset")))), (_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL))), _tmp149);
								_tmp150 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_identifier_new ("self"))));
								(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
								_tmp151 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_constant_new ("0"))));
								(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
								_tmp154 = NULL;
								_tmp153 = NULL;
								_tmp152 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_identifier_new ((_tmp153 = g_strdup_printf ("sizeof (%s)", (_tmp152 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))))));
								(_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL)));
								_tmp153 = (g_free (_tmp153), NULL);
								_tmp152 = (g_free (_tmp152), NULL);
								_tmp155 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp155 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							}
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) == m && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment));
			}
			{
				GeeCollection* precondition_collection;
				GeeIterator* precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
				while (gee_iterator_next (precondition_it)) {
					ValaExpression* precondition;
					precondition = ((ValaExpression*) gee_iterator_get (precondition_it));
					{
						ValaCCodeStatement* _tmp156;
						_tmp156 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp156 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
						(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
						(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
				(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp158;
		char* _tmp157;
		ValaCCodeFunction* _tmp159;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		GeeHashMap* _tmp162;
		GeeHashMap* carg_map;
		char* _tmp163;
		ValaCCodeFormalParameter* _tmp164;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp176;
		ValaCCodeMemberAccess* _tmp177;
		ValaCCodeFunctionCall* _tmp178;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp179;
		GeeCollection* params;
		GeeCollection* _tmp200;
		gboolean _tmp201;
		gint last_pos;
		gint min_pos;
		ValaCCodeStatement* cstmt;
		GeeCollection* _tmp214;
		gboolean _tmp215;
		_tmp158 = NULL;
		_tmp157 = NULL;
		_tmp159 = NULL;
		vfunc = (_tmp159 = vala_ccode_function_new ((_tmp157 = vala_method_get_cname (m)), (_tmp158 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp158 = (g_free (_tmp158), NULL)), (_tmp157 = (g_free (_tmp157), NULL)), _tmp159);
		vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaReferenceType* _tmp160;
			_tmp160 = NULL;
			this_type = (_tmp160 = VALA_REFERENCE_TYPE (vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp160);
		} else {
			ValaReferenceType* _tmp161;
			_tmp161 = NULL;
			this_type = (_tmp161 = VALA_REFERENCE_TYPE (vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp161);
		}
		_tmp162 = NULL;
		cparam_map = (_tmp162 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), _tmp162);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp163 = NULL;
		_tmp164 = NULL;
		cparam = (_tmp164 = vala_ccode_formal_parameter_new ("self", (_tmp163 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type), FALSE, FALSE))), (_tmp163 = (g_free (_tmp163), NULL)), _tmp164);
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeCollection* precondition_collection;
			GeeIterator* precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
			while (gee_iterator_next (precondition_it)) {
				ValaExpression* precondition;
				precondition = ((ValaExpression*) gee_iterator_get (precondition_it));
				{
					ValaCCodeStatement* _tmp165;
					_tmp165 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp165 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
					(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
					(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
			(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaInterface* _tmp166;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp170;
			ValaCCodeIdentifier* _tmp169;
			char* _tmp168;
			char* _tmp167;
			_tmp166 = NULL;
			iface = (_tmp166 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp166 == NULL ? NULL : g_object_ref (_tmp166)));
			_tmp170 = NULL;
			_tmp169 = NULL;
			_tmp168 = NULL;
			_tmp167 = NULL;
			vcast = (_tmp170 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp169 = vala_ccode_identifier_new ((_tmp168 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp167 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp170);
			(_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL)));
			_tmp168 = (g_free (_tmp168), NULL);
			_tmp167 = (g_free (_tmp167), NULL);
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* _tmp171;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp175;
			ValaCCodeIdentifier* _tmp174;
			char* _tmp173;
			char* _tmp172;
			_tmp171 = NULL;
			cl = (_tmp171 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp171 == NULL ? NULL : g_object_ref (_tmp171)));
			_tmp175 = NULL;
			_tmp174 = NULL;
			_tmp173 = NULL;
			_tmp172 = NULL;
			vcast = (_tmp175 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_identifier_new ((_tmp173 = g_strdup_printf ("%s_GET_CLASS", (_tmp172 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp175);
			(_tmp174 == NULL ? NULL : (_tmp174 = (g_object_unref (_tmp174), NULL)));
			_tmp173 = (g_free (_tmp173), NULL);
			_tmp172 = (g_free (_tmp172), NULL);
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		_tmp176 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp176 = vala_ccode_identifier_new ("self"))));
		(_tmp176 == NULL ? NULL : (_tmp176 = (g_object_unref (_tmp176), NULL)));
		_tmp177 = NULL;
		_tmp178 = NULL;
		vcall = (_tmp178 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL))), _tmp178);
		_tmp179 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), (_tmp179 = vala_ccode_identifier_new ("self")));
		(_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL)));
		params = vala_method_get_parameters (m);
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = params;
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) gee_iterator_get (param_it));
				{
					ValaCCodeIdentifier* _tmp185;
					if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
						ValaArrayType* _tmp180;
						ValaArrayType* array_type;
						char* length_ctype;
						_tmp180 = NULL;
						array_type = (_tmp180 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp180 == NULL ? NULL : g_object_ref (_tmp180)));
						length_ctype = g_strdup ("int");
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							char* _tmp181;
							_tmp181 = NULL;
							length_ctype = (_tmp181 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp181);
						}
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								char* _tmp182;
								ValaCCodeFormalParameter* _tmp183;
								ValaCCodeFormalParameter* cparam;
								ValaCCodeIdentifier* _tmp184;
								_tmp182 = NULL;
								_tmp183 = NULL;
								cparam = (_tmp183 = vala_ccode_formal_parameter_new ((_tmp182 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp182 = (g_free (_tmp182), NULL)), _tmp183);
								gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
								_tmp184 = NULL;
								gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp184 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
								(_tmp184 == NULL ? NULL : (_tmp184 = (g_object_unref (_tmp184), NULL)));
								(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
							}
						}
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						length_ctype = (g_free (length_ctype), NULL);
					}
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					_tmp185 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), (_tmp185 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))));
					(_tmp185 == NULL ? NULL : (_tmp185 = (g_object_unref (_tmp185), NULL)));
					if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
						ValaDelegateType* _tmp186;
						ValaDelegateType* deleg_type;
						ValaDelegate* _tmp187;
						ValaDelegate* d;
						_tmp186 = NULL;
						deleg_type = (_tmp186 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp186 == NULL ? NULL : g_object_ref (_tmp186)));
						_tmp187 = NULL;
						d = (_tmp187 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp187 == NULL ? NULL : g_object_ref (_tmp187)));
						if (vala_delegate_get_instance (d)) {
							char* _tmp188;
							ValaCCodeFormalParameter* _tmp189;
							ValaCCodeFormalParameter* cparam;
							ValaCCodeIdentifier* _tmp190;
							_tmp188 = NULL;
							_tmp189 = NULL;
							cparam = (_tmp189 = vala_ccode_formal_parameter_new ((_tmp188 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp188 = (g_free (_tmp188), NULL)), _tmp189);
							gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
							_tmp190 = NULL;
							gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp190 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp190 == NULL ? NULL : (_tmp190 = (g_object_unref (_tmp190), NULL)));
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
						(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
						(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		/* return array length if appropriate*/
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
			ValaArrayType* _tmp191;
			ValaArrayType* array_type;
			_tmp191 = NULL;
			array_type = (_tmp191 = VALA_ARRAY_TYPE (creturn_type), (_tmp191 == NULL ? NULL : g_object_ref (_tmp191)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp192;
					ValaCCodeFormalParameter* _tmp193;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp194;
					_tmp192 = NULL;
					_tmp193 = NULL;
					cparam = (_tmp193 = vala_ccode_formal_parameter_new ((_tmp192 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp192 = (g_free (_tmp192), NULL)), _tmp193);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), cparam);
					_tmp194 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), (_tmp194 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp194 == NULL ? NULL : (_tmp194 = (g_object_unref (_tmp194), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp195;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp196;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp195 = NULL;
				deleg_type = (_tmp195 = VALA_DELEGATE_TYPE (creturn_type), (_tmp195 == NULL ? NULL : g_object_ref (_tmp195)));
				_tmp196 = NULL;
				d = (_tmp196 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp196 == NULL ? NULL : g_object_ref (_tmp196)));
				if (vala_delegate_get_instance (d)) {
					char* _tmp197;
					ValaCCodeFormalParameter* _tmp198;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp199;
					_tmp197 = NULL;
					_tmp198 = NULL;
					cparam = (_tmp198 = vala_ccode_formal_parameter_new ((_tmp197 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp197 = (g_free (_tmp197), NULL)), _tmp198);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					_tmp199 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (_tmp199 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp199 == NULL ? NULL : (_tmp199 = (g_object_unref (_tmp199), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
		_tmp200 = NULL;
		if ((_tmp201 = gee_collection_get_size ((_tmp200 = vala_method_get_error_domains (m))) > 0, (_tmp200 == NULL ? NULL : (_tmp200 = (g_object_unref (_tmp200), NULL))), _tmp201)) {
			ValaCCodeFormalParameter* cparam;
			ValaCCodeIdentifier* _tmp202;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), cparam);
			_tmp202 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), (_tmp202 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
			(_tmp202 == NULL ? NULL : (_tmp202 = (g_object_unref (_tmp202), NULL)));
			(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		}
		/* append C parameters and arguments in the right order*/
		last_pos = -1;
		min_pos = 0;
		while (TRUE) {
			ValaCCodeFormalParameter* _tmp203;
			ValaCCodeExpression* _tmp204;
			min_pos = -1;
			{
				GeeSet* pos_collection;
				GeeIterator* pos_it;
				pos_collection = gee_map_get_keys (GEE_MAP (cparam_map));
				pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
				while (gee_iterator_next (pos_it)) {
					gint pos;
					pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
					{
						if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
							min_pos = pos;
						}
					}
				}
				(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
				(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			}
			if (min_pos == -1) {
				break;
			}
			_tmp203 = NULL;
			vala_ccode_function_add_parameter (vfunc, (_tmp203 = ((ValaCCodeFormalParameter*) gee_map_get (GEE_MAP (cparam_map), GINT_TO_POINTER (min_pos)))));
			(_tmp203 == NULL ? NULL : (_tmp203 = (g_object_unref (_tmp203), NULL)));
			_tmp204 = NULL;
			vala_ccode_function_call_add_argument (vcall, (_tmp204 = ((ValaCCodeExpression*) gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos)))));
			(_tmp204 == NULL ? NULL : (_tmp204 = (g_object_unref (_tmp204), NULL)));
			last_pos = min_pos;
		}
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp205;
			_tmp205 = NULL;
			cstmt = (_tmp205 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp205);
		} else {
			GeeCollection* _tmp206;
			gboolean _tmp207;
			_tmp206 = NULL;
			if ((_tmp207 = gee_collection_get_size ((_tmp206 = vala_method_get_postconditions (m))) == 0, (_tmp206 == NULL ? NULL : (_tmp206 = (g_object_unref (_tmp206), NULL))), _tmp207)) {
				ValaCCodeStatement* _tmp208;
				/* pass method return value */
				_tmp208 = NULL;
				cstmt = (_tmp208 = VALA_CCODE_STATEMENT (vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp208);
			} else {
				char* _tmp209;
				ValaCCodeDeclaration* _tmp210;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp211;
				ValaCCodeStatement* _tmp213;
				ValaCCodeDeclaration* _tmp212;
				/* store method return value for postconditions */
				_tmp209 = NULL;
				_tmp210 = NULL;
				cdecl_ = (_tmp210 = vala_ccode_declaration_new ((_tmp209 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp209 = (g_free (_tmp209), NULL)), _tmp210);
				_tmp211 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp211 = vala_ccode_variable_declarator_new_with_initializer ("result", VALA_CCODE_EXPRESSION (vcall)))));
				(_tmp211 == NULL ? NULL : (_tmp211 = (g_object_unref (_tmp211), NULL)));
				_tmp213 = NULL;
				_tmp212 = NULL;
				cstmt = (_tmp213 = VALA_CCODE_STATEMENT ((_tmp212 = cdecl_, (_tmp212 == NULL ? NULL : g_object_ref (_tmp212)))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp213);
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
		vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
		_tmp214 = NULL;
		if ((_tmp215 = gee_collection_get_size ((_tmp214 = vala_method_get_postconditions (m))) > 0, (_tmp214 == NULL ? NULL : (_tmp214 = (g_object_unref (_tmp214), NULL))), _tmp215)) {
			{
				GeeCollection* postcondition_collection;
				GeeIterator* postcondition_it;
				postcondition_collection = vala_method_get_postconditions (m);
				postcondition_it = gee_iterable_iterator (GEE_ITERABLE (postcondition_collection));
				while (gee_iterator_next (postcondition_it)) {
					ValaExpression* postcondition;
					postcondition = ((ValaExpression*) gee_iterator_get (postcondition_it));
					{
						ValaCCodeStatement* _tmp216;
						_tmp216 = NULL;
						vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp216 = vala_ccode_method_binding_create_postcondition_statement (self, postcondition))));
						(_tmp216 == NULL ? NULL : (_tmp216 = (g_object_unref (_tmp216), NULL)));
						(postcondition == NULL ? NULL : (postcondition = (g_object_unref (postcondition), NULL)));
					}
				}
				(postcondition_collection == NULL ? NULL : (postcondition_collection = (g_object_unref (postcondition_collection), NULL)));
				(postcondition_it == NULL ? NULL : (postcondition_it = (g_object_unref (postcondition_it), NULL)));
			}
			if (!(VALA_IS_VOID_TYPE (creturn_type))) {
				ValaCCodeIdentifier* _tmp217;
				ValaCCodeReturnStatement* _tmp218;
				ValaCCodeReturnStatement* cret_stmt;
				_tmp217 = NULL;
				_tmp218 = NULL;
				cret_stmt = (_tmp218 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp217 = vala_ccode_identifier_new ("result")))), (_tmp217 == NULL ? NULL : (_tmp217 = (g_object_unref (_tmp217), NULL))), _tmp218);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
				vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cret_stmt));
				(cret_stmt == NULL ? NULL : (cret_stmt = (g_object_unref (cret_stmt), NULL)));
			}
		}
		if (visible) {
			ValaCCodeFunction* _tmp219;
			_tmp219 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp219 = vala_ccode_function_copy (vfunc))));
			(_tmp219 == NULL ? NULL : (_tmp219 = (g_object_unref (_tmp219), NULL)));
		} else {
			ValaCCodeFunction* _tmp220;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp220 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp220 = vala_ccode_function_copy (vfunc))));
			(_tmp220 == NULL ? NULL : (_tmp220 = (g_object_unref (_tmp220), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
			ValaCCodeComment* _tmp221;
			_tmp221 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp221 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
			(_tmp221 == NULL ? NULL : (_tmp221 = (g_object_unref (_tmp221), NULL)));
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeCollection* _tmp222;
		gboolean _tmp223;
		_tmp222 = NULL;
		if ((_tmp223 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size ((_tmp222 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0), (_tmp222 == NULL ? NULL : (_tmp222 = (g_object_unref (_tmp222), NULL))), _tmp223)) {
			ValaCCodeIdentifier* _tmp225;
			ValaCCodeIdentifier* _tmp224;
			ValaCCodeBinaryExpression* _tmp226;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp229;
			ValaCCodeUnaryExpression* _tmp228;
			ValaCCodeIdentifier* _tmp227;
			ValaCCodeIdentifier* _tmp230;
			ValaCCodeFunctionCall* _tmp231;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp234;
			ValaCCodeMemberAccess* _tmp233;
			ValaCCodeIdentifier* _tmp232;
			ValaCCodeExpressionStatement* _tmp235;
			ValaCCodeWhileStatement* _tmp236;
			ValaCCodeIdentifier* _tmp237;
			ValaCCodeFunctionCall* _tmp238;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp239;
			ValaCCodeExpressionStatement* _tmp240;
			_tmp225 = NULL;
			_tmp224 = NULL;
			_tmp226 = NULL;
			ccond = (_tmp226 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp224 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp225 = vala_ccode_identifier_new ("__params")))), (_tmp225 == NULL ? NULL : (_tmp225 = (g_object_unref (_tmp225), NULL))), (_tmp224 == NULL ? NULL : (_tmp224 = (g_object_unref (_tmp224), NULL))), _tmp226);
			cdofreeparam = vala_ccode_block_new ();
			_tmp229 = NULL;
			_tmp228 = NULL;
			_tmp227 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp229 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp228 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp227 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp229 == NULL ? NULL : (_tmp229 = (g_object_unref (_tmp229), NULL)));
			(_tmp228 == NULL ? NULL : (_tmp228 = (g_object_unref (_tmp228), NULL)));
			(_tmp227 == NULL ? NULL : (_tmp227 = (g_object_unref (_tmp227), NULL)));
			_tmp230 = NULL;
			_tmp231 = NULL;
			cunsetcall = (_tmp231 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp230 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp230 == NULL ? NULL : (_tmp230 = (g_object_unref (_tmp230), NULL))), _tmp231);
			_tmp234 = NULL;
			_tmp233 = NULL;
			_tmp232 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp234 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp233 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp232 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp234 == NULL ? NULL : (_tmp234 = (g_object_unref (_tmp234), NULL)));
			(_tmp233 == NULL ? NULL : (_tmp233 = (g_object_unref (_tmp233), NULL)));
			(_tmp232 == NULL ? NULL : (_tmp232 = (g_object_unref (_tmp232), NULL)));
			_tmp235 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp235 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp235 == NULL ? NULL : (_tmp235 = (g_object_unref (_tmp235), NULL)));
			_tmp236 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp236 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp236 == NULL ? NULL : (_tmp236 = (g_object_unref (_tmp236), NULL)));
			_tmp237 = NULL;
			_tmp238 = NULL;
			cfreeparams = (_tmp238 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp237 = vala_ccode_identifier_new ("g_free")))), (_tmp237 == NULL ? NULL : (_tmp237 = (g_object_unref (_tmp237), NULL))), _tmp238);
			_tmp239 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp239 = vala_ccode_identifier_new ("__params"))));
			(_tmp239 == NULL ? NULL : (_tmp239 = (g_object_unref (_tmp239), NULL)));
			_tmp240 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp240 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp240 == NULL ? NULL : (_tmp240 = (g_object_unref (_tmp240), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
			ValaCCodeReturnStatement* creturn;
			ValaCCodeIdentifier* _tmp241;
			creturn = vala_ccode_return_statement_new (NULL);
			_tmp241 = NULL;
			vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((_tmp241 = vala_ccode_identifier_new ("self"))));
			(_tmp241 == NULL ? NULL : (_tmp241 = (g_object_unref (_tmp241), NULL)));
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (creturn));
			(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_method_binding_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp242;
		ValaCCodeFormalParameter* _tmp243;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp249;
		ValaCCodeIdentifier* _tmp248;
		ValaCCodeExpressionStatement* _tmp250;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp251;
		ValaCCodeFunctionCall* _tmp252;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (VALA_CCODE_NODE (cmain), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		_tmp242 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp242 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp242 == NULL ? NULL : (_tmp242 = (g_object_unref (_tmp242), NULL)));
		_tmp243 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp243 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp243 == NULL ? NULL : (_tmp243 = (g_object_unref (_tmp243), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context)) {
			ValaCCodeIdentifier* _tmp244;
			ValaCCodeFunctionCall* _tmp245;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp246;
			ValaCCodeExpressionStatement* _tmp247;
			_tmp244 = NULL;
			_tmp245 = NULL;
			thread_init_call = (_tmp245 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp244 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp244 == NULL ? NULL : (_tmp244 = (g_object_unref (_tmp244), NULL))), _tmp245);
			vala_ccode_node_set_line (VALA_CCODE_NODE (thread_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			_tmp246 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp246 = vala_ccode_constant_new ("NULL"))));
			(_tmp246 == NULL ? NULL : (_tmp246 = (g_object_unref (_tmp246), NULL)));
			_tmp247 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp247 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp247 == NULL ? NULL : (_tmp247 = (g_object_unref (_tmp247), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		_tmp249 = NULL;
		_tmp248 = NULL;
		_tmp250 = NULL;
		type_init_call = (_tmp250 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp249 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp248 = vala_ccode_identifier_new ("g_type_init"))))))), (_tmp249 == NULL ? NULL : (_tmp249 = (g_object_unref (_tmp249), NULL))), (_tmp248 == NULL ? NULL : (_tmp248 = (g_object_unref (_tmp248), NULL))), _tmp250);
		vala_ccode_node_set_line (VALA_CCODE_NODE (type_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (type_init_call));
		_tmp251 = NULL;
		_tmp252 = NULL;
		main_call = (_tmp252 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp251 = vala_ccode_identifier_new (vala_ccode_function_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))))), (_tmp251 == NULL ? NULL : (_tmp251 = (g_object_unref (_tmp251), NULL))), _tmp252);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp253;
			ValaCCodeIdentifier* _tmp254;
			_tmp253 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp253 = vala_ccode_identifier_new ("argv"))));
			(_tmp253 == NULL ? NULL : (_tmp253 = (g_object_unref (_tmp253), NULL)));
			_tmp254 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp254 = vala_ccode_identifier_new ("argc"))));
			(_tmp254 == NULL ? NULL : (_tmp254 = (g_object_unref (_tmp254), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp255;
			ValaCCodeReturnStatement* _tmp256;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			_tmp255 = NULL;
			_tmp256 = NULL;
			ret_stmt = (_tmp256 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp255 = vala_ccode_constant_new ("0")))), (_tmp255 == NULL ? NULL : (_tmp255 = (g_object_unref (_tmp255), NULL))), _tmp256);
			vala_ccode_node_set_line (VALA_CCODE_NODE (ret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (ret_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (g_object_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (g_object_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
}


void vala_ccode_method_binding_generate_cparameters (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* creturn_type, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator) {
	GeeCollection* _tmp17;
	gboolean _tmp18;
	gint last_pos;
	gint min_pos;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_METHOD (m));
	g_return_if_fail (VALA_IS_DATA_TYPE (creturn_type));
	g_return_if_fail (GEE_IS_MAP (cparam_map));
	g_return_if_fail (VALA_IS_CCODE_FUNCTION (func));
	g_return_if_fail (vdeclarator == NULL || VALA_IS_CCODE_FUNCTION_DECLARATOR (vdeclarator));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaArrayType* _tmp0;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp0 = NULL;
					array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp1;
						_tmp1 = NULL;
						length_ctype = (_tmp1 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp1);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp2;
							ValaCCodeFormalParameter* _tmp3;
							ValaCCodeFormalParameter* cparam;
							_tmp2 = NULL;
							_tmp3 = NULL;
							cparam = (_tmp3 = vala_ccode_formal_parameter_new ((_tmp2 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaDelegateType* _tmp4;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp5;
					ValaDelegate* d;
					_tmp4 = NULL;
					deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
					_tmp5 = NULL;
					d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
					if (vala_delegate_get_instance (d)) {
						char* _tmp6;
						ValaCCodeFormalParameter* _tmp7;
						ValaCCodeFormalParameter* cparam;
						_tmp6 = NULL;
						_tmp7 = NULL;
						cparam = (_tmp7 = vala_ccode_formal_parameter_new ((_tmp6 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
				} else {
					if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_type_reference (param))) {
						char* _tmp8;
						ValaCCodeFormalParameter* _tmp9;
						ValaCCodeFormalParameter* cparam;
						_tmp8 = NULL;
						_tmp9 = NULL;
						cparam = (_tmp9 = vala_ccode_formal_parameter_new ((_tmp8 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (creturn_type), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp11;
				ValaCCodeFormalParameter* _tmp12;
				ValaCCodeFormalParameter* cparam;
				_tmp11 = NULL;
				_tmp12 = NULL;
				cparam = (_tmp12 = vala_ccode_formal_parameter_new ((_tmp11 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
			ValaDelegateType* _tmp13;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp14;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp13 = NULL;
			deleg_type = (_tmp13 = VALA_DELEGATE_TYPE (creturn_type), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			_tmp14 = NULL;
			d = (_tmp14 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
			if (vala_delegate_get_instance (d)) {
				char* _tmp15;
				ValaCCodeFormalParameter* _tmp16;
				ValaCCodeFormalParameter* cparam;
				_tmp15 = NULL;
				_tmp16 = NULL;
				cparam = (_tmp16 = vala_ccode_formal_parameter_new ((_tmp15 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp15 = (g_free (_tmp15), NULL)), _tmp16);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	_tmp17 = NULL;
	if ((_tmp18 = gee_collection_get_size ((_tmp17 = vala_method_get_error_domains (m))) > 0, (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp19;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (cparam_map);
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp19 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp19 = ((ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp20;
			_tmp20 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, (_tmp20 = ((ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		}
		last_pos = min_pos;
	}
}


static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_generator_create_type_check_statement (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CODE_NODE (m), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (precondition), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (precondition))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeExpressionStatement* _tmp3;
			ValaCCodeExpressionStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp4 = (_tmp3 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("0")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp4));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp5 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp5));
}


static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeExpressionStatement* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (postcondition), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_assert")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (postcondition))));
	_tmp2 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp2 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)), (cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL))), _tmp2));
}


static ValaTypesymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypesymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeCollection* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp7;
	ValaArrayType* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (VALA_SYMBOL (m)) == NULL || _vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (m)), "main") != 0) {
		/* method must be called "main"*/
		return FALSE;
	}
	if (vala_method_get_instance (m)) {
		/* method must be static*/
		return FALSE;
	}
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type)) {
			(*return_value) = TRUE;
		} else {
			/* return type must be void or int*/
			return FALSE;
		}
	}
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (params) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (params) > 1) {
		gboolean _tmp4;
		/* method must not have more than one parameter*/
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	}
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = ((ValaFormalParameter*) gee_iterator_get (params_it));
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		gboolean _tmp5;
		/* parameter must not be an out parameter*/
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp5);
	}
	if (!(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)))) {
		gboolean _tmp6;
		/* parameter must be an array*/
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp6);
	}
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
		gboolean _tmp8;
		/* parameter must be an array of strings*/
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp8);
	}
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if (has_params) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeConstant* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("__params_it - __params"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("__params"))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	} else {
		ValaCCodeConstant* _tmp7;
		ValaCCodeConstant* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdeclaration = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl) {
	ValaClass* _tmp0;
	ValaClass* fundamental_class;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	_tmp0 = NULL;
	fundamental_class = (_tmp0 = cl, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	while (fundamental_class != NULL && VALA_TYPESYMBOL (vala_class_get_base_class (fundamental_class)) != vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type) {
		ValaClass* _tmp2;
		ValaClass* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		fundamental_class = (_tmp2 = (_tmp1 = vala_class_get_base_class (fundamental_class), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL))), _tmp2);
	}
	return fundamental_class;
}


ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	return self->priv->_method;
}


void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL))), _tmp2);
}


gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self) {
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static void vala_ccode_method_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		g_value_set_object (value, vala_ccode_method_binding_get_method (self));
		break;
		case VALA_CCODE_METHOD_BINDING_HAS_WRAPPER:
		g_value_set_boolean (value, vala_ccode_method_binding_get_has_wrapper (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		vala_ccode_method_binding_set_method (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_class_init (ValaCCodeMethodBindingClass * klass) {
	vala_ccode_method_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMethodBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_method_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_method_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_method_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_method_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_METHOD, g_param_spec_object ("method", "method", "method", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_HAS_WRAPPER, g_param_spec_boolean ("has-wrapper", "has-wrapper", "has-wrapper", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_ccode_method_binding_init (ValaCCodeMethodBinding * self) {
	self->priv = VALA_CCODE_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_method_binding_dispose (GObject * obj) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (obj);
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL)));
	G_OBJECT_CLASS (vala_ccode_method_binding_parent_class)->dispose (obj);
}


GType vala_ccode_method_binding_get_type (void) {
	static GType vala_ccode_method_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_method_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodBinding), 0, (GInstanceInitFunc) vala_ccode_method_binding_init };
		vala_ccode_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_method_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




