/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEINVOCATIONEXPRESSIONBINDING_H__
#define __GOBJECT_VALACCODEINVOCATIONEXPRESSIONBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valainvocationexpression.h>
#include <gobject/valaccodeexpressionbinding.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING (vala_ccode_invocation_expression_binding_get_type ())
#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBinding))
#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingClass))
#define VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING))
#define VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING))
#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingClass))

typedef struct _ValaCCodeInvocationExpressionBinding ValaCCodeInvocationExpressionBinding;
typedef struct _ValaCCodeInvocationExpressionBindingClass ValaCCodeInvocationExpressionBindingClass;
typedef struct _ValaCCodeInvocationExpressionBindingPrivate ValaCCodeInvocationExpressionBindingPrivate;

struct _ValaCCodeInvocationExpressionBinding {
	ValaCCodeExpressionBinding parent_instance;
	ValaCCodeInvocationExpressionBindingPrivate * priv;
};
struct _ValaCCodeInvocationExpressionBindingClass {
	ValaCCodeExpressionBindingClass parent_class;
};

ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression);
ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self);
void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value);
GType vala_ccode_invocation_expression_binding_get_type (void);


G_END_DECLS

#endif
