/* valaccodedynamicmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicmethodbinding.h>
#include <ccode/valaccodefunction.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeblock.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/collection.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valavoidtype.h>
#include <vala/valamethodtype.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_DYNAMIC_METHOD_BINDING_DUMMY_PROPERTY
};
static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block);
static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_array_type (ValaCCodeDynamicMethodBinding* self, ValaArrayType* array_type);
static gpointer vala_ccode_dynamic_method_binding_parent_class = NULL;



ValaCCodeDynamicMethodBinding* vala_ccode_dynamic_method_binding_new (ValaCCodeGenerator* codegen, ValaDynamicMethod* method) {
	ValaCCodeDynamicMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, 0, NULL);
	vala_ccode_method_binding_set_method (VALA_CCODE_METHOD_BINDING (self), VALA_METHOD (method));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


void vala_ccode_dynamic_method_binding_generate_wrapper (ValaCCodeDynamicMethodBinding* self) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* instance_param;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp6;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	func = (_tmp3 = vala_ccode_function_new ((_tmp1 = vala_method_get_cname (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp2 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE, FALSE))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	instance_param = vala_ccode_formal_parameter_new ("obj", "gpointer");
	gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE)), instance_param);
	vala_ccode_method_binding_generate_cparameters (VALA_CCODE_METHOD_BINDING (self), vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)), vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), GEE_MAP (cparam_map), func, NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
		vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (self, block);
	} else {
		char* _tmp5;
		char* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp5 = g_strdup_printf ("dynamic methods are not supported for `%s'", (_tmp4 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_method_get_dynamic_type (dynamic_method)))))));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp4 = (g_free (_tmp4), NULL);
	}
	/* append to C source file*/
	_tmp6 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp6 = vala_ccode_function_copy (func))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
	(func == NULL ? NULL : (func = (g_object_unref (func), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
}


static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	ValaInvocationExpression* _tmp1;
	ValaInvocationExpression* expr;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp8;
	char* _tmp7;
	ValaCCodeIdentifier* _tmp63;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	ccall = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("dbus_g_proxy_begin_call")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("obj"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeCollection* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = ((ValaExpression*) gee_iterator_get (arg_it));
			{
				if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
					ValaExpression* _tmp6;
					ValaExpression* _tmp5;
					/* callback*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "only one reply callback may be specified in invocation of DBus method");
						vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
						(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
						(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
						(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
						return;
					} else {
						if (found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
					}
					_tmp6 = NULL;
					_tmp5 = NULL;
					callback = (_tmp6 = (_tmp5 = arg, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL))), _tmp6);
					callback_index = arg_index;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
						/* out arg*/
						if (callback != NULL) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
						found_out = TRUE;
					} else {
						/* in arg*/
						if (callback != NULL || found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "in argument must not follow out argument or reply callback in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
					}
				}
				arg_index++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ((_tmp7 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp7 = (g_free (_tmp7), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp9;
		ValaMethod* reply_method;
		char* _tmp11;
		char* _tmp10;
		ValaCCodeFunction* _tmp12;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp13;
		ValaCCodeFormalParameter* _tmp14;
		ValaCCodeFormalParameter* _tmp15;
		ValaCCodeBlock* _tmp16;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp18;
		ValaCCodeConstant* _tmp17;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeFunctionCall* _tmp20;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp21;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeUnaryExpression* _tmp24;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeFunctionCall* creply_call;
		ValaCCodeIdentifier* _tmp25;
		GeeCollection* _tmp26;
		gint _tmp27;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp49;
		ValaCCodeExpressionStatement* _tmp50;
		ValaCCodeIdentifier* _tmp51;
		ValaCCodeExpressionStatement* _tmp52;
		ValaCCodeIdentifier* _tmp53;
		ValaCCodeConstant* _tmp55;
		char* _tmp54;
		ValaCCodeConstant* _tmp56;
		_tmp9 = NULL;
		reply_method = (_tmp9 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		cb_fun = (_tmp12 = vala_ccode_function_new ((_tmp11 = g_strdup_printf ("_%s_cb", (_tmp10 = vala_method_get_cname (reply_method)))), "void"), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp13 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp13 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp14 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp14 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp15 = vala_ccode_formal_parameter_new ("user_data", "void*")));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		_tmp16 = NULL;
		vala_ccode_function_set_block (cb_fun, (_tmp16 = vala_ccode_block_new ()));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, VALA_CCODE_DECLARATOR ((_tmp18 = vala_ccode_variable_declarator_new_with_initializer ("error", VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL")))))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cerrdecl));
		_tmp19 = NULL;
		_tmp20 = NULL;
		cend_call = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("dbus_g_proxy_end_call")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("proxy"))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("call"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("error")))))));
		(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (callback))));
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("user_data"))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		_tmp26 = NULL;
		param_count = (_tmp27 = gee_collection_get_size ((_tmp26 = vala_method_get_parameters (reply_method))), (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27);
		i = 0;
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = vala_method_get_parameters (reply_method);
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) gee_iterator_get (param_it));
				{
					if (((i = i + 1)) == param_count) {
						/* error parameter*/
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						break;
					}
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))))) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaArrayType* _tmp28;
						ValaArrayType* array_type;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp29;
						ValaCCodeExpression* _tmp30;
						ValaCCodeUnaryExpression* _tmp32;
						ValaCCodeIdentifier* _tmp31;
						ValaCCodeMemberAccess* _tmp34;
						ValaCCodeIdentifier* _tmp33;
						ValaCCodeMemberAccess* _tmp36;
						ValaCCodeIdentifier* _tmp35;
						_tmp28 = NULL;
						array_type = (_tmp28 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
						cdecl_ = vala_ccode_declaration_new ("GArray*");
						_tmp29 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp29 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						_tmp30 = NULL;
						vala_ccode_function_call_add_argument (cend_call, (_tmp30 = vala_ccode_dynamic_method_binding_get_dbus_array_type (self, array_type)));
						(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
						_tmp32 = NULL;
						_tmp31 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
						(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
						_tmp34 = NULL;
						_tmp33 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "data"))));
						(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
						(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
						_tmp36 = NULL;
						_tmp35 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "len"))));
						(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
						(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					} else {
						char* _tmp37;
						ValaCCodeDeclaration* _tmp38;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp39;
						ValaCCodeUnaryExpression* _tmp47;
						ValaCCodeIdentifier* _tmp46;
						ValaCCodeIdentifier* _tmp48;
						_tmp37 = NULL;
						_tmp38 = NULL;
						cdecl_ = (_tmp38 = vala_ccode_declaration_new ((_tmp37 = vala_data_type_get_cname (vala_formal_parameter_get_type_reference (param), FALSE, FALSE))), (_tmp37 = (g_free (_tmp37), NULL)), _tmp38);
						_tmp39 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp39 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp40;
							ValaCCodeIdentifier* _tmp41;
							ValaCCodeFunctionCall* _tmp42;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp43;
							/* special case string array*/
							_tmp40 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
							(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
							_tmp41 = NULL;
							_tmp42 = NULL;
							cstrvlen = (_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), _tmp42);
							_tmp43 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
							vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION (cstrvlen));
							(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp45;
							char* _tmp44;
							_tmp45 = NULL;
							_tmp44 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ((_tmp44 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
							(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
							_tmp44 = (g_free (_tmp44), NULL);
						}
						_tmp47 = NULL;
						_tmp46 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
						(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
						_tmp48 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		_tmp49 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		_tmp50 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp50 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cend_call)))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		_tmp51 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("error"))));
		(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		_tmp52 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp52 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (creply_call)))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cb_fun));
		_tmp53 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun)))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		_tmp55 = NULL;
		_tmp54 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_constant_new ((_tmp54 = g_strdup_printf ("param%d_target", callback_index))))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
		_tmp54 = (g_free (_tmp54), NULL);
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_constant_new ("NULL"))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		(reply_method == NULL ? NULL : (reply_method = (g_object_unref (reply_method), NULL)));
		(cb_fun == NULL ? NULL : (cb_fun = (g_object_unref (cb_fun), NULL)));
		(cerrdecl == NULL ? NULL : (cerrdecl = (g_object_unref (cerrdecl), NULL)));
		(cend_call == NULL ? NULL : (cend_call = (g_object_unref (cend_call), NULL)));
		(creply_call == NULL ? NULL : (creply_call = (g_object_unref (creply_call), NULL)));
	} else {
		if (found_out || !(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeIdentifier* _tmp58;
			_tmp57 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("dbus_g_proxy_call"))));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
			_tmp58 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ("error"))));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp59;
			_tmp59 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply"))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
		}
	}
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)));
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				ValaCCodeIdentifier* _tmp61;
				char* _tmp60;
				ValaCCodeIdentifier* _tmp62;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_type_reference (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				_tmp61 = NULL;
				_tmp60 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ((_tmp60 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
				(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
				_tmp60 = (g_free (_tmp60), NULL);
				_tmp62 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
				(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp63 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
		ValaArrayType* _tmp65;
		ValaDataType* _tmp64;
		ValaArrayType* array_type;
		/* synchronous D-Bus method call with reply*/
		_tmp65 = NULL;
		_tmp64 = NULL;
		array_type = (_tmp65 = (_tmp64 = vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (VALA_IS_ARRAY_TYPE (_tmp64) ? ((ValaArrayType*) _tmp64) : NULL)), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
		if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeExpression* _tmp66;
			ValaDataType* garray_type_reference;
			char* _tmp67;
			ValaCCodeDeclaration* _tmp68;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp69;
			ValaCCodeUnaryExpression* _tmp71;
			ValaCCodeIdentifier* _tmp70;
			ValaCCodeIdentifier* _tmp72;
			ValaCCodeExpressionStatement* _tmp73;
			ValaCCodeReturnStatement* _tmp76;
			ValaCCodeMemberAccess* _tmp75;
			ValaCCodeIdentifier* _tmp74;
			/* non-string arrays (use GArray)*/
			_tmp66 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp66 = vala_ccode_dynamic_method_binding_get_dbus_array_type (self, array_type)));
			(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
			garray_type_reference = vala_ccode_generator_get_data_type_for_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->garray_type);
			_tmp67 = NULL;
			_tmp68 = NULL;
			cdecl_ = (_tmp68 = vala_ccode_declaration_new ((_tmp67 = vala_data_type_get_cname (garray_type_reference, FALSE, FALSE))), (_tmp67 = (g_free (_tmp67), NULL)), _tmp68);
			_tmp69 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp69 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp71 = NULL;
			_tmp70 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ("result")))))));
			(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
			(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
			_tmp72 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
			_tmp73 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp73 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
			_tmp76 = NULL;
			_tmp75 = NULL;
			_tmp74 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp76 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ("result"))), "data")))))));
			(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
			(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
			(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
			if (!vala_method_get_no_array_length (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))) {
				ValaCCodeMemberAccess* _tmp78;
				ValaCCodeIdentifier* _tmp77;
				_tmp78 = NULL;
				_tmp77 = NULL;
				vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_identifier_new ("result"))), "len"))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
			} else {
				ValaCCodeConstant* _tmp79;
				_tmp79 = NULL;
				vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_constant_new ("-1"))));
				(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
			}
			(garray_type_reference == NULL ? NULL : (garray_type_reference = (g_object_unref (garray_type_reference), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		} else {
			char* _tmp83;
			ValaCCodeDeclaration* _tmp84;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp85;
			ValaCCodeUnaryExpression* _tmp87;
			ValaCCodeIdentifier* _tmp86;
			ValaCCodeIdentifier* _tmp88;
			ValaCCodeExpressionStatement* _tmp89;
			ValaCCodeReturnStatement* _tmp91;
			ValaCCodeIdentifier* _tmp90;
			/* string arrays or other datatypes*/
			if (VALA_IS_ARRAY_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))) {
				ValaCCodeIdentifier* _tmp80;
				/* string arrays*/
				_tmp80 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
				(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp82;
				char* _tmp81;
				/* other types*/
				_tmp82 = NULL;
				_tmp81 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ((_tmp81 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))));
				(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
				_tmp81 = (g_free (_tmp81), NULL);
			}
			_tmp83 = NULL;
			_tmp84 = NULL;
			cdecl_ = (_tmp84 = vala_ccode_declaration_new ((_tmp83 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE, FALSE))), (_tmp83 = (g_free (_tmp83), NULL)), _tmp84);
			_tmp85 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp85 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp87 = NULL;
			_tmp86 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ("result")))))));
			(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
			(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
			_tmp88 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
			_tmp89 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp89 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
			_tmp91 = NULL;
			_tmp90 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp91 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new ("result")))))));
			(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
			(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
			if (array_type != NULL) {
				/* special case string array*/
				if (!vala_method_get_no_array_length (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))) {
					ValaCCodeIdentifier* _tmp92;
					ValaCCodeFunctionCall* _tmp93;
					ValaCCodeFunctionCall* cstrvlen;
					ValaCCodeIdentifier* _tmp94;
					_tmp92 = NULL;
					_tmp93 = NULL;
					cstrvlen = (_tmp93 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL))), _tmp93);
					_tmp94 = NULL;
					vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new ("result"))));
					(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (cstrvlen));
					(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
				} else {
					ValaCCodeConstant* _tmp95;
					_tmp95 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_constant_new ("-1"))));
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
				}
			}
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp96;
		_tmp96 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp96 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
	}
	(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
}


static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_array_type (ValaCCodeDynamicMethodBinding* self, ValaArrayType* array_type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* carray_type;
	ValaCCodeConstant* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (array_type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	carray_type = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"GArray\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type))))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	return VALA_CCODE_EXPRESSION (carray_type);
}


static void vala_ccode_dynamic_method_binding_class_init (ValaCCodeDynamicMethodBindingClass * klass) {
	vala_ccode_dynamic_method_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_dynamic_method_binding_init (ValaCCodeDynamicMethodBinding * self) {
}


GType vala_ccode_dynamic_method_binding_get_type (void) {
	static GType vala_ccode_dynamic_method_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_dynamic_method_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicMethodBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_method_binding_init };
		vala_ccode_dynamic_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_BINDING, "ValaCCodeDynamicMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_method_binding_type_id;
}




