/* valaccodecreationmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODECREATIONMETHODBINDING_H__
#define __GOBJECT_VALACCODECREATIONMETHODBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacreationmethod.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_CREATION_METHOD_BINDING (vala_ccode_creation_method_binding_get_type ())
#define VALA_CCODE_CREATION_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CREATION_METHOD_BINDING, ValaCCodeCreationMethodBinding))
#define VALA_CCODE_CREATION_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CREATION_METHOD_BINDING, ValaCCodeCreationMethodBindingClass))
#define VALA_IS_CCODE_CREATION_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CREATION_METHOD_BINDING))
#define VALA_IS_CCODE_CREATION_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CREATION_METHOD_BINDING))
#define VALA_CCODE_CREATION_METHOD_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CREATION_METHOD_BINDING, ValaCCodeCreationMethodBindingClass))

typedef struct _ValaCCodeCreationMethodBinding ValaCCodeCreationMethodBinding;
typedef struct _ValaCCodeCreationMethodBindingClass ValaCCodeCreationMethodBindingClass;
typedef struct _ValaCCodeCreationMethodBindingPrivate ValaCCodeCreationMethodBindingPrivate;

/**
 * The link between a creation method and generated code.
 */
struct _ValaCCodeCreationMethodBinding {
	ValaCCodeMethodBinding parent_instance;
	ValaCCodeCreationMethodBindingPrivate * priv;
};
struct _ValaCCodeCreationMethodBindingClass {
	ValaCCodeMethodBindingClass parent_class;
};

ValaCCodeCreationMethodBinding* vala_ccode_creation_method_binding_new (ValaCCodeGenerator* codegen, ValaCreationMethod* creation_method);
ValaCreationMethod* vala_ccode_creation_method_binding_get_creation_method (ValaCCodeCreationMethodBinding* self);
void vala_ccode_creation_method_binding_set_creation_method (ValaCCodeCreationMethodBinding* self, ValaCreationMethod* value);
GType vala_ccode_creation_method_binding_get_type (void);


G_END_DECLS

#endif
