/* valaccodearraycreationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodearraycreationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valalocalvariable.h>
#include <vala/valasymbol.h>
#include <gee/list.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valainitializerlist.h>
#include <ccode/valaccodeelementaccess.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeArrayCreationExpressionBindingPrivate {
	ValaArrayCreationExpression* _array_creation_expression;
};
#define VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING, ValaCCodeArrayCreationExpressionBindingPrivate))
enum  {
	VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_ARRAY_CREATION_EXPRESSION
};
static void vala_ccode_array_creation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_array_creation_expression_binding_parent_class = NULL;
static void vala_ccode_array_creation_expression_binding_dispose (GObject * obj);



ValaCCodeArrayCreationExpressionBinding* vala_ccode_array_creation_expression_binding_new (ValaCCodeGenerator* codegen, ValaArrayCreationExpression* array_creation_expression) {
	ValaCCodeArrayCreationExpressionBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (array_creation_expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING, 0, NULL);
	vala_ccode_array_creation_expression_binding_set_array_creation_expression (self, array_creation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_array_creation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeArrayCreationExpressionBinding * self;
	ValaArrayCreationExpression* _tmp0;
	ValaArrayCreationExpression* expr;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	gboolean first;
	ValaCCodeExpression* cexpr;
	self = VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_array_creation_expression, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	_tmp1 = NULL;
	_tmp2 = NULL;
	gnew = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_new0")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	first = TRUE;
	cexpr = NULL;
	{
		GeeList* size_collection;
		GeeIterator* size_it;
		size_collection = vala_array_creation_expression_get_sizes (expr);
		size_it = gee_iterable_iterator (GEE_ITERABLE (size_collection));
		while (gee_iterator_next (size_it)) {
			ValaExpression* size;
			size = ((ValaExpression*) gee_iterator_get (size_it));
			{
				ValaCCodeExpression* _tmp5;
				ValaCCodeExpression* csize;
				_tmp5 = NULL;
				csize = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
				if (!vala_ccode_generator_is_pure_ccode_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), csize)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* name_cnode;
					ValaCCodeExpression* _tmp7;
					ValaCCodeAssignment* _tmp6;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, FALSE, VALA_CODE_NODE (expr));
					name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (size), VALA_CCODE_NODE (name_cnode));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp7 = NULL;
					_tmp6 = NULL;
					csize = (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), csize, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))), (csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL))), _tmp7);
					(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
				}
				if (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)))) {
					ValaCCodeExpression* _tmp9;
					ValaCCodeConstant* _tmp8;
					/* add extra item to have array NULL-terminated for all reference types*/
					_tmp9 = NULL;
					_tmp8 = NULL;
					csize = (_tmp9 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, csize, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("1"))))), (csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL))), _tmp9);
					(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				}
				if (first) {
					ValaCCodeExpression* _tmp11;
					ValaCCodeExpression* _tmp10;
					_tmp11 = NULL;
					_tmp10 = NULL;
					cexpr = (_tmp11 = (_tmp10 = csize, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp11);
					first = FALSE;
				} else {
					ValaCCodeExpression* _tmp12;
					_tmp12 = NULL;
					cexpr = (_tmp12 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp12);
				}
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
				(csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL)));
			}
		}
		(size_collection == NULL ? NULL : (size_collection = (g_object_unref (size_collection), NULL)));
		(size_it == NULL ? NULL : (size_it = (g_object_unref (size_it), NULL)));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp13;
		/* FIXME rank > 1 not supported yet*/
		if (vala_array_creation_expression_get_rank (expr) > 1) {
			vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Creating arrays with rank greater than 1 with initializers is not supported yet");
		}
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE, VALA_CODE_NODE (expr));
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
		i = 0;
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
		_tmp13 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		{
			GeeCollection* e_collection;
			GeeIterator* e_it;
			e_collection = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			e_it = gee_iterable_iterator (GEE_ITERABLE (e_collection));
			while (gee_iterator_next (e_it)) {
				ValaExpression* e;
				e = ((ValaExpression*) gee_iterator_get (e_it));
				{
					ValaCCodeAssignment* _tmp17;
					ValaCCodeElementAccess* _tmp16;
					ValaCCodeConstant* _tmp15;
					char* _tmp14;
					_tmp17 = NULL;
					_tmp16 = NULL;
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strdup_printf ("%i", i)))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
					(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					_tmp14 = (g_free (_tmp14), NULL);
					i++;
					(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
				}
			}
			(e_collection == NULL ? NULL : (e_collection = (g_object_unref (e_collection), NULL)));
			(e_it == NULL ? NULL : (e_it = (g_object_unref (e_it), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ce));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (gnew));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
	(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
}


ValaArrayCreationExpression* vala_ccode_array_creation_expression_binding_get_array_creation_expression (ValaCCodeArrayCreationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_array_creation_expression;
}


void vala_ccode_array_creation_expression_binding_set_array_creation_expression (ValaCCodeArrayCreationExpressionBinding* self, ValaArrayCreationExpression* value) {
	ValaArrayCreationExpression* _tmp2;
	ValaArrayCreationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_array_creation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_array_creation_expression == NULL ? NULL : (self->priv->_array_creation_expression = (g_object_unref (self->priv->_array_creation_expression), NULL))), _tmp2);
}


static void vala_ccode_array_creation_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeArrayCreationExpressionBinding * self;
	self = VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_ARRAY_CREATION_EXPRESSION:
		g_value_set_object (value, vala_ccode_array_creation_expression_binding_get_array_creation_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_array_creation_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeArrayCreationExpressionBinding * self;
	self = VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_ARRAY_CREATION_EXPRESSION:
		vala_ccode_array_creation_expression_binding_set_array_creation_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_array_creation_expression_binding_class_init (ValaCCodeArrayCreationExpressionBindingClass * klass) {
	vala_ccode_array_creation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeArrayCreationExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_array_creation_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_array_creation_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_array_creation_expression_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_array_creation_expression_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_ARRAY_CREATION_EXPRESSION, g_param_spec_object ("array-creation-expression", "array-creation-expression", "array-creation-expression", VALA_TYPE_ARRAY_CREATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_array_creation_expression_binding_init (ValaCCodeArrayCreationExpressionBinding * self) {
	self->priv = VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_array_creation_expression_binding_dispose (GObject * obj) {
	ValaCCodeArrayCreationExpressionBinding * self;
	self = VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (obj);
	(self->priv->_array_creation_expression == NULL ? NULL : (self->priv->_array_creation_expression = (g_object_unref (self->priv->_array_creation_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_array_creation_expression_binding_parent_class)->dispose (obj);
}


GType vala_ccode_array_creation_expression_binding_get_type (void) {
	static GType vala_ccode_array_creation_expression_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_array_creation_expression_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayCreationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_creation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayCreationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_array_creation_expression_binding_init };
		vala_ccode_array_creation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeArrayCreationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_array_creation_expression_binding_type_id;
}




