/* valaccodeconditionalexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODECONDITIONALEXPRESSION_H__
#define __CCODE_VALACCODECONDITIONALEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION (vala_ccode_conditional_expression_get_type ())
#define VALA_CCODE_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION, ValaCCodeConditionalExpression))
#define VALA_CCODE_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION, ValaCCodeConditionalExpressionClass))
#define VALA_IS_CCODE_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CCODE_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION))
#define VALA_CCODE_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION, ValaCCodeConditionalExpressionClass))

typedef struct _ValaCCodeConditionalExpression ValaCCodeConditionalExpression;
typedef struct _ValaCCodeConditionalExpressionClass ValaCCodeConditionalExpressionClass;
typedef struct _ValaCCodeConditionalExpressionPrivate ValaCCodeConditionalExpressionPrivate;

/**
 * Represents a conditional expression in C code.
 */
struct _ValaCCodeConditionalExpression {
	ValaCCodeExpression parent_instance;
	ValaCCodeConditionalExpressionPrivate * priv;
};
struct _ValaCCodeConditionalExpressionClass {
	ValaCCodeExpressionClass parent_class;
};

ValaCCodeConditionalExpression* vala_ccode_conditional_expression_new (ValaCCodeExpression* cond, ValaCCodeExpression* true_expr, ValaCCodeExpression* false_expr);
ValaCCodeExpression* vala_ccode_conditional_expression_get_condition (ValaCCodeConditionalExpression* self);
void vala_ccode_conditional_expression_set_condition (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value);
ValaCCodeExpression* vala_ccode_conditional_expression_get_true_expression (ValaCCodeConditionalExpression* self);
void vala_ccode_conditional_expression_set_true_expression (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value);
ValaCCodeExpression* vala_ccode_conditional_expression_get_false_expression (ValaCCodeConditionalExpression* self);
void vala_ccode_conditional_expression_set_false_expression (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value);
GType vala_ccode_conditional_expression_get_type (void);


G_END_DECLS

#endif
