/* valaccodeassignment.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEASSIGNMENT_H__
#define __CCODE_VALACCODEASSIGNMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ASSIGNMENT (vala_ccode_assignment_get_type ())
#define VALA_CCODE_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignment))
#define VALA_CCODE_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignmentClass))
#define VALA_IS_CCODE_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT))
#define VALA_IS_CCODE_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT))
#define VALA_CCODE_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignmentClass))

typedef struct _ValaCCodeAssignment ValaCCodeAssignment;
typedef struct _ValaCCodeAssignmentClass ValaCCodeAssignmentClass;
typedef struct _ValaCCodeAssignmentPrivate ValaCCodeAssignmentPrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_OPERATOR (vala_ccode_assignment_operator_get_type ())

/**
 * Represents an assignment expression in the C code.
 */
struct _ValaCCodeAssignment {
	ValaCCodeExpression parent_instance;
	ValaCCodeAssignmentPrivate * priv;
};
struct _ValaCCodeAssignmentClass {
	ValaCCodeExpressionClass parent_class;
};
typedef enum  {
	VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE,
	VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR,
	VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND,
	VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR,
	VALA_CCODE_ASSIGNMENT_OPERATOR_ADD,
	VALA_CCODE_ASSIGNMENT_OPERATOR_SUB,
	VALA_CCODE_ASSIGNMENT_OPERATOR_MUL,
	VALA_CCODE_ASSIGNMENT_OPERATOR_DIV,
	VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT,
	VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT,
	VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT
} ValaCCodeAssignmentOperator;


ValaCCodeAssignment* vala_ccode_assignment_new (ValaCCodeExpression* l, ValaCCodeExpression* r, ValaCCodeAssignmentOperator op);
ValaCCodeExpression* vala_ccode_assignment_get_left (ValaCCodeAssignment* self);
ValaCCodeAssignmentOperator vala_ccode_assignment_get_operator (ValaCCodeAssignment* self);
void vala_ccode_assignment_set_operator (ValaCCodeAssignment* self, ValaCCodeAssignmentOperator value);
ValaCCodeExpression* vala_ccode_assignment_get_right (ValaCCodeAssignment* self);
GType vala_ccode_assignment_get_type (void);
GType vala_ccode_assignment_operator_get_type (void);


G_END_DECLS

#endif
