# Note that this is NOT a relocatable package
%define name		trilobite
%define ver		1.0.3
%define RELEASE		0_cvs_0
%define rel		%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix		/usr
%define sysconfdir	/etc

Name:		%name
Vendor:		GNOME
Distribution:	CVS
Summary:	Trilobite is component framework for services
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group:		User Interface/Desktop
Source: 	%{name}-%{ver}.tar.gz
URL: 		http://nautilus.eazel.com/
BuildRoot:	/var/tmp/%{name}-%{ver}-root
Docdir: 	%{prefix}/doc
Requires:	glib >= 1.2.9
Requires:	gtk+ >= 1.2.9
Requires:	imlib >= 1.9.8
Requires:	libxml >= 1.8.10
Requires:	gnome-libs >= 1.2.11
Requires:	GConf >= 0.12
Requires:	ORBit >= 0.5.6
Requires:	oaf >= 0.6.2
Requires:	gnome-vfs >= 1.0.1
Requires:	gdk-pixbuf >= 0.10.0
Requires:	bonobo >= 0.33
Requires:	popt >= 1.5
Requires:	freetype >= 2.0.1
Requires:	medusa >= 0.5.1
Requires:	esound >= 0.2
Requires:	libghttp >= 1.0.9
Requires:	libpng
Requires:	control-center >= 1.2.3
Requires:	librsvg >= 1.0.0
Requires:	eel >= 1.0
Requires:	ammonite >= 1.0.2
Requires:	nautilus >= 1.0.3
Requires:	rpm >= 4.0.2
Requires:	usermode >= 1.35
Obsoletes:	nautilus-trilobite

BuildRequires:	glib-devel >= 1.2.9
BuildRequires:	gtk+-devel >= 1.2.9
BuildRequires:	libxml-devel >= 1.8.10
BuildRequires:	gnome-libs-devel >= 1.2.11
BuildRequires:	GConf-devel >= 0.12
BuildRequires:	ORBit-devel >= 0.5.6
BuildRequires:	oaf-devel >= 0.6.2
BuildRequires:	gnome-vfs-devel >= 1.0.1
BuildRequires:	bonobo-devel >= 0.33
BuildRequires:	eel-devel >= 1.0
BuildRequires:	nautilus-devel >= 1.0.3

%description
This is a framework library for service components in Nautilus.  It is
required by all Eazel Services, including the package installer, and
can be used to develop new services.

%package devel
Summary:	Libraries and include files for developing Trilobite components
Group:		Development/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description devel
Libraries and include files for developing Trilobite components

Wed Apr 11 02:52:14 PDT 2001
%changelog
* Wed Apr 11 2001 Ramiro Estrugo <ramiro@eazel.com>
- created this thing

%prep
%setup

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

LC_ALL=""
LINGUAS=""
LANG=""
export LC_ALL LINGUAS LANG

## Warning!  Make sure there are no spaces or tabs after the \ 
## continuation character, or else the rpm demons will eat you.
CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%{prefix} \
	--enable-more-warnings \
	--sysconfdir=%{sysconfdir}

make -k
make check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make -k prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install
for FILE in "$RPM_BUILD_ROOT/bin/*"; do
	file "$FILE" | grep -q not\ stripped && strip $FILE
done

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
	echo "%{prefix}/lib" >> /etc/ld.so.conf
fi
/sbin/ldconfig

%postun -p /sbin/ldconfig

%files

%defattr(0555, bin, bin)
%doc AUTHORS COPYING COPYING.LIB TRADEMARK_NOTICE ChangeLog NEWS README
%{prefix}/bin/nautilus-change-password-view
%{prefix}/bin/nautilus-inventory-view
%{prefix}/bin/nautilus-package-view
%{prefix}/bin/nautilus-install-view
%{prefix}/bin/nautilus-summary-view
%{prefix}/bin/trilobite-gen-xml
%{prefix}/bin/trilobite-helper
%{prefix}/bin/trilobite-install
%{prefix}/bin/trilobite-install-service
%{prefix}/bin/trilobite-inventory-client
%{prefix}/bin/trilobite-inventory-service
%{prefix}/lib/libtrilobite-install.so
%{prefix}/lib/libtrilobite-install.so.0
%{prefix}/lib/libtrilobite-install.so.0.0.0
%{prefix}/lib/libtrilobite-inventory*so*
%{prefix}/lib/libtrilobite-service.so
%{prefix}/lib/libtrilobite-service.so.0
%{prefix}/lib/libtrilobite-service.so.0.0.0
%{prefix}/lib/libtrilobite-ups-rpm*.so
%{prefix}/lib/libtrilobite-ups-rpm*.so.0
%{prefix}/lib/libtrilobite-ups-rpm*.so.0.0.0
%{prefix}/lib/libtrilobite-ups.so
%{prefix}/lib/libtrilobite-ups.so.0
%{prefix}/lib/libtrilobite-ups.so.0.0.0
%{prefix}/lib/libtrilobite.so
%{prefix}/lib/libtrilobite.so.0
%{prefix}/lib/libtrilobite.so.0.0.0

%defattr (0444, bin, bin)
%config %{sysconfdir}/pam.d/trilobite-helper
%config %{sysconfdir}/security/console.apps/trilobite-helper
%{prefix}/share/gnome/ui/*.xml
%{prefix}/share/locale/*/LC_MESSAGES/*.mo
%{prefix}/share/pixmaps/*.png
%{prefix}/share/pixmaps/nautilus/gray_tab_pieces/*.png
%{prefix}/share/oaf/Nautilus_View_install.oaf
%{prefix}/share/oaf/Trilobite_Service_install.oaf
%{prefix}/share/oaf/Nautilus_View_change-password.oaf
%{prefix}/share/oaf/Nautilus_View_services-summary.oaf
%{prefix}/share/oaf/Trilobite_Service_inventory.oaf
%{prefix}/share/oaf/Nautilus_View_inventory.oaf
%{prefix}/share/oaf/Nautilus_View_package.oaf

%files devel
%defattr(0555, bin, bin)
%{prefix}/lib/*.la
%{prefix}/lib/*.sh
%{prefix}/bin/trilobite-config

%defattr(0444, bin, bin)
%{prefix}/include/libtrilobite/*.h
%{prefix}/include/libtrilobite-ups/*.h
%{prefix}/include/libtrilobite-install/*.h
%{prefix}/include/libtrilobite-inventory/*.h
%{prefix}/share/idl/*.idl
