
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_UTILS (tracker_utils_get_type ())
#define TRACKER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_UTILS, TrackerUtils))
#define TRACKER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_UTILS, TrackerUtilsClass))
#define IS_TRACKER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_UTILS))
#define IS_TRACKER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_UTILS))
#define TRACKER_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_UTILS, TrackerUtilsClass))

typedef struct _TrackerUtils TrackerUtils;
typedef struct _TrackerUtilsClass TrackerUtilsClass;
typedef struct _TrackerUtilsPrivate TrackerUtilsPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _ParamSpecTrackerUtils ParamSpecTrackerUtils;

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Music,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerUtilsPrivate * priv;
};

struct _TrackerUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerUtils *self);
};

struct _ParamSpecTrackerUtils {
	GParamSpec parent_instance;
};


static gpointer tracker_utils_parent_class = NULL;

GType categories_get_type (void);
gpointer tracker_utils_ref (gpointer instance);
void tracker_utils_unref (gpointer instance);
GParamSpec* param_spec_tracker_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tracker_utils (GValue* value, gpointer v_object);
gpointer value_get_tracker_utils (const GValue* value);
GType tracker_utils_get_type (void);
enum  {
	TRACKER_UTILS_DUMMY_PROPERTY
};
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard);
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir);
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen);
TrackerUtils* tracker_utils_new (void);
TrackerUtils* tracker_utils_construct (GType object_type);
static void tracker_utils_finalize (TrackerUtils* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType categories_get_type (void) {
	static GType categories_type_id = 0;
	if (G_UNLIKELY (categories_type_id == 0)) {
		static const GEnumValue values[] = {{CATEGORIES_Application, "CATEGORIES_Application", "application"}, {CATEGORIES_Contact, "CATEGORIES_Contact", "contact"}, {CATEGORIES_Email, "CATEGORIES_Email", "email"}, {CATEGORIES_EmailAttachment, "CATEGORIES_EmailAttachment", "emailattachment"}, {CATEGORIES_File, "CATEGORIES_File", "file"}, {CATEGORIES_Folder, "CATEGORIES_Folder", "folder"}, {CATEGORIES_Music, "CATEGORIES_Music", "music"}, {CATEGORIES_Video, "CATEGORIES_Video", "video"}, {CATEGORIES_Image, "CATEGORIES_Image", "image"}, {CATEGORIES_Document, "CATEGORIES_Document", "document"}, {CATEGORIES_Text, "CATEGORIES_Text", "text"}, {CATEGORIES_Development, "CATEGORIES_Development", "development"}, {CATEGORIES_Web, "CATEGORIES_Web", "web"}, {CATEGORIES_WebHistory, "CATEGORIES_WebHistory", "webhistory"}, {0, NULL, NULL}};
		categories_type_id = g_enum_register_static ("Categories", values);
	}
	return categories_type_id;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


#line 54 "tracker-utils.gs"
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard) {
#line 112 "tracker-utils.c"
	char* result;
	GString* str;
	glong len;
	gchar* p;
#line 54 "tracker-utils.gs"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 119 "tracker-utils.c"
	str = g_string_new ("");
#line 57 "tracker-utils.gs"
	if (sparql == NULL) {
#line 123 "tracker-utils.c"
		result = g_strdup ("");
		_g_string_free0 (str);
		return result;
	}
	len = string_get_length (sparql);
#line 62 "tracker-utils.gs"
	if (len < 3) {
#line 131 "tracker-utils.c"
		result = g_strdup (sparql);
		_g_string_free0 (str);
		return result;
	}
	p = sparql;
#line 67 "tracker-utils.gs"
	while (TRUE) {
#line 67 "tracker-utils.gs"
		if (!((*p) != '\0')) {
#line 67 "tracker-utils.gs"
			break;
#line 143 "tracker-utils.c"
		}
#line 68 "tracker-utils.gs"
		if ((*p) == '"') {
#line 69 "tracker-utils.gs"
			g_string_append (str, "\\\"");
#line 149 "tracker-utils.c"
		} else {
#line 70 "tracker-utils.gs"
			if ((*p) == '\\') {
#line 71 "tracker-utils.gs"
				g_string_append (str, "\\\\");
#line 155 "tracker-utils.c"
			} else {
#line 73 "tracker-utils.gs"
				g_string_append_c (str, *p);
#line 159 "tracker-utils.c"
			}
		}
#line 74 "tracker-utils.gs"
		p++;
#line 164 "tracker-utils.c"
	}
#line 76 "tracker-utils.gs"
	if (add_wildcard) {
#line 77 "tracker-utils.gs"
		p--;
#line 78 "tracker-utils.gs"
		if ((*p) != ' ') {
#line 79 "tracker-utils.gs"
			g_string_append_c (str, '*');
#line 174 "tracker-utils.c"
		}
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
	return result;
}


#line 87 "tracker-utils.gs"
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir) {
#line 185 "tracker-utils.c"
	gboolean result;
	GError * _inner_error_;
	char* command;
	GAppInfo* app_info;
	GFile* file;
	gboolean _tmp2_;
#line 87 "tracker-utils.gs"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 194 "tracker-utils.c"
	_inner_error_ = NULL;
	command = NULL;
	app_info = NULL;
	file = g_file_new_for_uri (uri);
	{
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
		_tmp0_ = g_file_query_default_handler (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
#line 94 "tracker-utils.gs"
		app_info = (_tmp1_ = _tmp0_, _g_object_unref0 (app_info), _tmp1_);
#line 209 "tracker-utils.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not get application info for %s\nError: %s\n"), uri, e->message));
#line 98 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 222 "tracker-utils.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (msg);
			_g_free0 (command);
			_g_object_unref0 (app_info);
			_g_object_unref0 (file);
			return result;
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		_g_object_unref0 (app_info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = FALSE;
#line 101 "tracker-utils.gs"
	if (is_dir == TRUE) {
#line 101 "tracker-utils.gs"
		_tmp2_ = _vala_strcmp0 (g_app_info_get_executable (app_info), "nautilus") == 0;
#line 246 "tracker-utils.c"
	} else {
#line 101 "tracker-utils.gs"
		_tmp2_ = FALSE;
#line 250 "tracker-utils.c"
	}
#line 101 "tracker-utils.gs"
	if (_tmp2_) {
#line 254 "tracker-utils.c"
		char* _tmp4_;
		char* _tmp3_;
#line 102 "tracker-utils.gs"
		command = (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat ("nautilus --sm-disable --no-desktop --no-default-window '", uri, NULL), "'", NULL), _g_free0 (command), _tmp4_);
#line 259 "tracker-utils.c"
		_g_free0 (_tmp3_);
	} else {
		char* _tmp7_;
		char* _tmp6_;
		char* _tmp5_;
#line 104 "tracker-utils.gs"
		command = (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (g_app_info_get_executable (app_info), " '", NULL), uri, NULL), "'", NULL), _g_free0 (command), _tmp7_);
#line 267 "tracker-utils.c"
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
	}
	{
#line 107 "tracker-utils.gs"
		g_spawn_command_line_async (command, &_inner_error_);
#line 274 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
			goto __finally8;
		}
		result = TRUE;
		_g_free0 (command);
		_g_object_unref0 (app_info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not lauch %s\nError: %s\n"), uri, e->message));
#line 112 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 296 "tracker-utils.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (msg);
			_g_free0 (command);
			_g_object_unref0 (app_info);
			_g_object_unref0 (file);
			return result;
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		_g_object_unref0 (app_info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (command);
	_g_object_unref0 (app_info);
	_g_object_unref0 (file);
}


#line 116 "tracker-utils.gs"
inline GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen) {
#line 323 "tracker-utils.c"
	GdkPixbuf* result;
	GThemedIcon* icon;
#line 116 "tracker-utils.gs"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 116 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 330 "tracker-utils.c"
	icon = (GThemedIcon*) g_themed_icon_new (icon_name);
	result = tracker_utils_GetThemeIconPixbuf ((GIcon*) icon, size, screen);
	_g_object_unref0 (icon);
	return result;
}


#line 123 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen) {
#line 340 "tracker-utils.c"
	GdkPixbuf* result;
	GError * _inner_error_;
	GdkPixbuf* pixbuf;
	char* thumbpath;
#line 123 "tracker-utils.gs"
	g_return_val_if_fail (info != NULL, NULL);
#line 123 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 349 "tracker-utils.c"
	_inner_error_ = NULL;
	pixbuf = NULL;
	thumbpath = g_strdup (g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH));
#line 129 "tracker-utils.gs"
	if (thumbpath != NULL) {
#line 355 "tracker-utils.c"
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = gdk_pixbuf_new_from_file_at_size (thumbpath, thumb_size, thumb_size, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_free0 (thumbpath);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 130 "tracker-utils.gs"
		pixbuf = (_tmp1_ = _tmp0_, _g_object_unref0 (pixbuf), _tmp1_);
#line 368 "tracker-utils.c"
	}
#line 132 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 372 "tracker-utils.c"
		GdkPixbuf* _tmp2_;
#line 133 "tracker-utils.gs"
		pixbuf = (_tmp2_ = tracker_utils_GetThemeIconPixbuf (g_file_info_get_icon (info), icon_size, screen), _g_object_unref0 (pixbuf), _tmp2_);
#line 376 "tracker-utils.c"
	}
#line 135 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 380 "tracker-utils.c"
		GdkPixbuf* _tmp3_;
#line 136 "tracker-utils.gs"
		pixbuf = (_tmp3_ = tracker_utils_GetThemePixbufByName ("text-x-generic", icon_size, screen), _g_object_unref0 (pixbuf), _tmp3_);
#line 384 "tracker-utils.c"
	}
	result = pixbuf;
	_g_free0 (thumbpath);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 141 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen) {
#line 399 "tracker-utils.c"
	GdkPixbuf* result;
	GError * _inner_error_;
	GtkIconInfo* icon_info;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 141 "tracker-utils.gs"
	g_return_val_if_fail (icon != NULL, NULL);
#line 141 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 410 "tracker-utils.c"
	_inner_error_ = NULL;
	icon_info = NULL;
	theme = _g_object_ref0 (gtk_icon_theme_get_for_screen (screen));
#line 147 "tracker-utils.gs"
	icon_info = (_tmp0_ = gtk_icon_theme_lookup_by_gicon (theme, icon, size, GTK_ICON_LOOKUP_USE_BUILTIN), _gtk_icon_info_free0 (icon_info), _tmp0_);
#line 416 "tracker-utils.c"
	_tmp1_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
	if (_inner_error_ != NULL) {
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _g_object_ref0 (_tmp1_);
	_gtk_icon_info_free0 (icon_info);
	_g_object_unref0 (theme);
	return result;
}


#line 51 "tracker-utils.gs"
TrackerUtils* tracker_utils_construct (GType object_type) {
#line 434 "tracker-utils.c"
	TrackerUtils* self;
	self = (TrackerUtils*) g_type_create_instance (object_type);
	return self;
}


#line 51 "tracker-utils.gs"
TrackerUtils* tracker_utils_new (void) {
#line 51 "tracker-utils.gs"
	return tracker_utils_construct (TYPE_TRACKER_UTILS);
#line 445 "tracker-utils.c"
}


static void value_tracker_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tracker_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_utils_unref (value->data[0].v_pointer);
	}
}


static void value_tracker_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tracker_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tracker_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tracker_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tracker_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTrackerUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TRACKER_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tracker_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRACKER_UTILS), NULL);
	return value->data[0].v_pointer;
}


void value_set_tracker_utils (GValue* value, gpointer v_object) {
	TrackerUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRACKER_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRACKER_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_utils_unref (old);
	}
}


static void tracker_utils_class_init (TrackerUtilsClass * klass) {
	tracker_utils_parent_class = g_type_class_peek_parent (klass);
	TRACKER_UTILS_CLASS (klass)->finalize = tracker_utils_finalize;
}


static void tracker_utils_instance_init (TrackerUtils * self) {
	self->ref_count = 1;
}


static void tracker_utils_finalize (TrackerUtils* obj) {
	TrackerUtils * self;
	self = TRACKER_UTILS (obj);
}


GType tracker_utils_get_type (void) {
	static GType tracker_utils_type_id = 0;
	if (tracker_utils_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_tracker_utils_init, value_tracker_utils_free_value, value_tracker_utils_copy_value, value_tracker_utils_peek_pointer, "p", value_tracker_utils_collect_value, "p", value_tracker_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerUtils), 0, (GInstanceInitFunc) tracker_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		tracker_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return tracker_utils_type_id;
}


gpointer tracker_utils_ref (gpointer instance) {
	TrackerUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_utils_unref (gpointer instance) {
	TrackerUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




