/* rygel-media-export-item.c generated by valac, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM (rygel_media_export_media_export_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM, RygelMediaExportMediaExportItem))
#define RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM, RygelMediaExportMediaExportItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_EXPORT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_EXPORT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM))
#define RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM, RygelMediaExportMediaExportItemClass))

typedef struct _RygelMediaExportMediaExportItem RygelMediaExportMediaExportItem;
typedef struct _RygelMediaExportMediaExportItemClass RygelMediaExportMediaExportItemClass;
typedef struct _RygelMediaExportMediaExportItemPrivate RygelMediaExportMediaExportItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaExportMediaExportItem {
	RygelMediaItem parent_instance;
	RygelMediaExportMediaExportItemPrivate * priv;
};

struct _RygelMediaExportMediaExportItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_media_export_media_export_item_parent_class = NULL;

GType rygel_media_export_media_export_item_get_type (void);
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH "rygel-width"
#define RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_WIDTH RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT "rygel-height"
#define RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_HEIGHT RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME "rygel-mime"
static RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_new (RygelMediaContainer* parent, const char* id, GFile* file, GstTagList* tag_list, const char* upnp_class);
static RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_construct (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GstTagList* tag_list, const char* upnp_class);
RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_create_from_taglist (RygelMediaContainer* parent, GFile* file, GstTagList* tag_list);
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH "rygel-depth"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS "rygel-channels"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE "rygel-rate"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE "rygel-size"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME "rygel-mtime"
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 34 "rygel-media-export-item.vala"
RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_create_from_taglist (RygelMediaContainer* parent, GFile* file, GstTagList* tag_list) {
#line 85 "rygel-media-export-item.c"
	RygelMediaExportMediaExportItem* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* id;
	gint width;
	gint height;
	char* class_guessed;
#line 34 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 34 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 34 "rygel-media-export-item.vala"
	g_return_val_if_fail (tag_list != NULL, NULL);
#line 37 "rygel-media-export-item.vala"
	id = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (file), -1), _g_free0 (_tmp0_), _tmp1_);
#line 39 "rygel-media-export-item.vala"
	width = -1;
#line 40 "rygel-media-export-item.vala"
	height = -1;
#line 41 "rygel-media-export-item.vala"
	class_guessed = NULL;
#line 43 "rygel-media-export-item.vala"
	if (tag_list != NULL) {
#line 109 "rygel-media-export-item.c"
		char* codec;
		char* _tmp4_;
		gboolean _tmp3_;
		char* _tmp2_ = NULL;
		codec = NULL;
#line 46 "rygel-media-export-item.vala"
		if (!(_tmp3_ = gst_tag_list_get_string (tag_list, GST_TAG_VIDEO_CODEC, &_tmp2_), codec = (_tmp4_ = _tmp2_, _g_free0 (codec), _tmp4_), _tmp3_)) {
#line 117 "rygel-media-export-item.c"
			char* _tmp7_;
			gboolean _tmp6_;
			char* _tmp5_ = NULL;
#line 47 "rygel-media-export-item.vala"
			if (!(_tmp6_ = gst_tag_list_get_string (tag_list, GST_TAG_AUDIO_CODEC, &_tmp5_), codec = (_tmp7_ = _tmp5_, _g_free0 (codec), _tmp7_), _tmp6_)) {
#line 123 "rygel-media-export-item.c"
				gboolean _tmp8_ = FALSE;
#line 48 "rygel-media-export-item.vala"
				if (gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_WIDTH, &width)) {
#line 48 "rygel-media-export-item.vala"
					_tmp8_ = TRUE;
#line 129 "rygel-media-export-item.c"
				} else {
#line 49 "rygel-media-export-item.vala"
					_tmp8_ = gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_HEIGHT, &height);
#line 133 "rygel-media-export-item.c"
				}
#line 48 "rygel-media-export-item.vala"
				if (_tmp8_) {
#line 137 "rygel-media-export-item.c"
					char* _tmp9_;
#line 50 "rygel-media-export-item.vala"
					class_guessed = (_tmp9_ = g_strdup (RYGEL_MEDIA_ITEM_PHOTO_CLASS), _g_free0 (class_guessed), _tmp9_);
#line 141 "rygel-media-export-item.c"
				} else {
					gint64 duration = 0LL;
#line 56 "rygel-media-export-item.vala"
					if (gst_tag_list_get_int64 (tag_list, GST_TAG_DURATION, &duration)) {
#line 146 "rygel-media-export-item.c"
						char* _tmp10_;
#line 58 "rygel-media-export-item.vala"
						class_guessed = (_tmp10_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (class_guessed), _tmp10_);
#line 150 "rygel-media-export-item.c"
					} else {
						char* content_type;
						char* _tmp12_;
						char* _tmp11_ = NULL;
						char* _tmp13_;
						content_type = NULL;
#line 61 "rygel-media-export-item.vala"
						gst_tag_list_get_string (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, &_tmp11_);
#line 61 "rygel-media-export-item.vala"
						content_type = (_tmp12_ = _tmp11_, _g_free0 (content_type), _tmp12_);
#line 63 "rygel-media-export-item.vala"
						g_warning (_ ("File '%s' is of unknown format/type."), _tmp13_ = g_file_get_uri (file));
#line 163 "rygel-media-export-item.c"
						_g_free0 (_tmp13_);
#line 65 "rygel-media-export-item.vala"
						g_warning (_ ("Trying to guess from content type %s"), content_type);
#line 67 "rygel-media-export-item.vala"
						if (g_str_has_prefix (content_type, "video/")) {
#line 169 "rygel-media-export-item.c"
							char* _tmp14_;
#line 68 "rygel-media-export-item.vala"
							class_guessed = (_tmp14_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (class_guessed), _tmp14_);
#line 173 "rygel-media-export-item.c"
						} else {
#line 69 "rygel-media-export-item.vala"
							if (g_str_has_prefix (content_type, "audio/")) {
#line 177 "rygel-media-export-item.c"
								char* _tmp15_;
#line 70 "rygel-media-export-item.vala"
								class_guessed = (_tmp15_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (class_guessed), _tmp15_);
#line 181 "rygel-media-export-item.c"
							} else {
#line 71 "rygel-media-export-item.vala"
								if (g_str_has_prefix (content_type, "image/")) {
#line 185 "rygel-media-export-item.c"
									char* _tmp16_;
#line 72 "rygel-media-export-item.vala"
									class_guessed = (_tmp16_ = g_strdup (RYGEL_MEDIA_ITEM_PHOTO_CLASS), _g_free0 (class_guessed), _tmp16_);
#line 189 "rygel-media-export-item.c"
								}
							}
						}
#line 75 "rygel-media-export-item.vala"
						if (class_guessed == NULL) {
#line 195 "rygel-media-export-item.c"
							char* _tmp17_;
							char* _tmp18_;
#line 76 "rygel-media-export-item.vala"
							class_guessed = (_tmp17_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (class_guessed), _tmp17_);
#line 77 "rygel-media-export-item.vala"
							g_warning (_ ("Failed to detect UPnP class for '%s', assuming '%s'"), _tmp18_ = g_file_get_uri (file), class_guessed);
#line 202 "rygel-media-export-item.c"
							_g_free0 (_tmp18_);
						}
						_g_free0 (content_type);
					}
				}
			} else {
				gboolean _tmp19_ = FALSE;
#line 87 "rygel-media-export-item.vala"
				if (gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_WIDTH, &width)) {
#line 87 "rygel-media-export-item.vala"
					_tmp19_ = TRUE;
#line 214 "rygel-media-export-item.c"
				} else {
#line 88 "rygel-media-export-item.vala"
					_tmp19_ = gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_HEIGHT, &height);
#line 218 "rygel-media-export-item.c"
				}
#line 87 "rygel-media-export-item.vala"
				if (_tmp19_) {
#line 222 "rygel-media-export-item.c"
					char* _tmp20_;
#line 89 "rygel-media-export-item.vala"
					class_guessed = (_tmp20_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (class_guessed), _tmp20_);
#line 226 "rygel-media-export-item.c"
				} else {
					char* _tmp21_;
#line 91 "rygel-media-export-item.vala"
					class_guessed = (_tmp21_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (class_guessed), _tmp21_);
#line 231 "rygel-media-export-item.c"
				}
			}
		} else {
			char* _tmp22_;
#line 95 "rygel-media-export-item.vala"
			class_guessed = (_tmp22_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (class_guessed), _tmp22_);
#line 238 "rygel-media-export-item.c"
		}
		_g_free0 (codec);
	} else {
		char* _tmp23_;
#line 99 "rygel-media-export-item.vala"
		g_warning (_ ("Got empty taglist for file %s"), _tmp23_ = g_file_get_uri (file));
#line 245 "rygel-media-export-item.c"
		_g_free0 (_tmp23_);
		result = NULL;
		_g_free0 (id);
		_g_free0 (class_guessed);
#line 101 "rygel-media-export-item.vala"
		return result;
#line 252 "rygel-media-export-item.c"
	}
	result = rygel_media_export_media_export_item_new (parent, id, file, tag_list, class_guessed);
	_g_free0 (id);
	_g_free0 (class_guessed);
#line 104 "rygel-media-export-item.vala"
	return result;
#line 259 "rygel-media-export-item.c"
}


#line 111 "rygel-media-export-item.vala"
static RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_construct (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GstTagList* tag_list, const char* upnp_class) {
#line 265 "rygel-media-export-item.c"
	RygelMediaExportMediaExportItem * self;
	char* title;
	gboolean _tmp0_ = FALSE;
	guint64 duration = 0ULL;
	glong _tmp6_ = 0L;
	char* _tmp8_;
	char* _tmp7_ = NULL;
	char* _tmp10_;
	char* _tmp9_ = NULL;
	guint tmp = 0U;
	gint64 size = 0LL;
	guint64 mtime = 0ULL;
	GDate* date = NULL;
	GDate* _tmp13_;
	gboolean _tmp12_;
	GDate* _tmp11_ = NULL;
	char* _tmp19_;
	char* _tmp18_ = NULL;
	char* _tmp20_;
#line 111 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 111 "rygel-media-export-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 111 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 111 "rygel-media-export-item.vala"
	g_return_val_if_fail (tag_list != NULL, NULL);
#line 111 "rygel-media-export-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 116 "rygel-media-export-item.vala"
	title = NULL;
#line 117 "rygel-media-export-item.vala"
	if (_vala_strcmp0 (upnp_class, RYGEL_MEDIA_ITEM_AUDIO_CLASS) == 0) {
#line 117 "rygel-media-export-item.vala"
		_tmp0_ = TRUE;
#line 301 "rygel-media-export-item.c"
	} else {
#line 118 "rygel-media-export-item.vala"
		_tmp0_ = _vala_strcmp0 (upnp_class, RYGEL_MEDIA_ITEM_MUSIC_CLASS) == 0;
#line 305 "rygel-media-export-item.c"
	}
#line 117 "rygel-media-export-item.vala"
	if (_tmp0_) {
#line 309 "rygel-media-export-item.c"
		char* _tmp3_;
		gboolean _tmp2_;
		char* _tmp1_ = NULL;
#line 120 "rygel-media-export-item.vala"
		if (!(_tmp2_ = gst_tag_list_get_string (tag_list, GST_TAG_TITLE, &_tmp1_), title = (_tmp3_ = _tmp1_, _g_free0 (title), _tmp3_), _tmp2_)) {
#line 315 "rygel-media-export-item.c"
			char* _tmp4_;
#line 121 "rygel-media-export-item.vala"
			title = (_tmp4_ = g_file_get_basename (file), _g_free0 (title), _tmp4_);
#line 319 "rygel-media-export-item.c"
		}
	} else {
		char* _tmp5_;
#line 125 "rygel-media-export-item.vala"
		title = (_tmp5_ = g_file_get_basename (file), _g_free0 (title), _tmp5_);
#line 325 "rygel-media-export-item.c"
	}
#line 127 "rygel-media-export-item.vala"
	self = (RygelMediaExportMediaExportItem*) rygel_media_item_construct (object_type, id, parent, title, upnp_class);
#line 129 "rygel-media-export-item.vala"
	gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_WIDTH, &((RygelMediaItem*) self)->width);
#line 130 "rygel-media-export-item.vala"
	gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_MEDIA_EXPORT_ITEM_TAG_HEIGHT, &((RygelMediaItem*) self)->height);
#line 131 "rygel-media-export-item.vala"
	gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH, &((RygelMediaItem*) self)->color_depth);
#line 134 "rygel-media-export-item.vala"
	gst_tag_list_get_uint64 (tag_list, GST_TAG_DURATION, &duration);
#line 135 "rygel-media-export-item.vala"
	if (duration == (-1)) {
#line 135 "rygel-media-export-item.vala"
		_tmp6_ = (glong) (-1);
#line 341 "rygel-media-export-item.c"
	} else {
#line 135 "rygel-media-export-item.vala"
		_tmp6_ = (glong) (duration / 1000000000);
#line 345 "rygel-media-export-item.c"
	}
#line 135 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->duration = _tmp6_;
#line 137 "rygel-media-export-item.vala"
	gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS, &((RygelMediaItem*) self)->n_audio_channels);
#line 140 "rygel-media-export-item.vala"
	gst_tag_list_get_string (tag_list, GST_TAG_ARTIST, &_tmp7_);
#line 140 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->author = (_tmp8_ = _tmp7_, _g_free0 (((RygelMediaItem*) self)->author), _tmp8_);
#line 141 "rygel-media-export-item.vala"
	gst_tag_list_get_string (tag_list, GST_TAG_ALBUM, &_tmp9_);
#line 141 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->album = (_tmp10_ = _tmp9_, _g_free0 (((RygelMediaItem*) self)->album), _tmp10_);
#line 144 "rygel-media-export-item.vala"
	gst_tag_list_get_uint (tag_list, GST_TAG_TRACK_NUMBER, &tmp);
#line 145 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->track_number = (gint) tmp;
#line 146 "rygel-media-export-item.vala"
	gst_tag_list_get_uint (tag_list, GST_TAG_BITRATE, &tmp);
#line 147 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->bitrate = ((gint) tmp) / 8;
#line 148 "rygel-media-export-item.vala"
	gst_tag_list_get_int (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE, &((RygelMediaItem*) self)->sample_freq);
#line 153 "rygel-media-export-item.vala"
	gst_tag_list_get_int64 (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE, &size);
#line 155 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->size = (glong) size;
#line 158 "rygel-media-export-item.vala"
	gst_tag_list_get_uint64 (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME, &mtime);
#line 160 "rygel-media-export-item.vala"
	((RygelMediaObject*) self)->modified = (guint64) ((gint64) mtime);
#line 163 "rygel-media-export-item.vala"
	if ((_tmp12_ = gst_tag_list_get_date (tag_list, GST_TAG_DATE, &_tmp11_), date = (_tmp13_ = _tmp11_, _g_free0 (date), _tmp13_), _tmp12_)) {
#line 379 "rygel-media-export-item.c"
		gchar* _tmp14_;
		gint _datestr_size_;
		gint datestr_length1;
		gchar* datestr;
		char* _tmp15_;
		datestr = (_tmp14_ = g_new0 (gchar, 30), datestr_length1 = 30, _datestr_size_ = datestr_length1, _tmp14_);
#line 165 "rygel-media-export-item.vala"
		g_date_strftime (datestr, datestr_length1, "%F", date);
#line 166 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->date = (_tmp15_ = g_strdup ((const char*) datestr), _g_free0 (((RygelMediaItem*) self)->date), _tmp15_);
#line 390 "rygel-media-export-item.c"
		datestr = (g_free (datestr), NULL);
	} else {
		GTimeVal _tmp16_ = {0};
		GTimeVal tv;
		char* _tmp17_;
#line 168 "rygel-media-export-item.vala"
		tv = (_tmp16_.tv_sec = (glong) mtime, _tmp16_.tv_usec = (glong) 0, _tmp16_);
#line 169 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->date = (_tmp17_ = g_time_val_to_iso8601 (&tv), _g_free0 (((RygelMediaItem*) self)->date), _tmp17_);
#line 400 "rygel-media-export-item.c"
	}
#line 173 "rygel-media-export-item.vala"
	gst_tag_list_get_string (tag_list, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, &_tmp18_);
#line 173 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->mime_type = (_tmp19_ = _tmp18_, _g_free0 (((RygelMediaItem*) self)->mime_type), _tmp19_);
#line 176 "rygel-media-export-item.vala"
	rygel_media_item_add_uri ((RygelMediaItem*) self, _tmp20_ = g_file_get_uri (file), NULL);
#line 408 "rygel-media-export-item.c"
	_g_free0 (_tmp20_);
	_g_free0 (title);
	_g_free0 (date);
	return self;
}


#line 111 "rygel-media-export-item.vala"
static RygelMediaExportMediaExportItem* rygel_media_export_media_export_item_new (RygelMediaContainer* parent, const char* id, GFile* file, GstTagList* tag_list, const char* upnp_class) {
#line 111 "rygel-media-export-item.vala"
	return rygel_media_export_media_export_item_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_EXPORT_ITEM, parent, id, file, tag_list, upnp_class);
#line 420 "rygel-media-export-item.c"
}


static void rygel_media_export_media_export_item_class_init (RygelMediaExportMediaExportItemClass * klass) {
	rygel_media_export_media_export_item_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_export_media_export_item_instance_init (RygelMediaExportMediaExportItem * self) {
}


GType rygel_media_export_media_export_item_get_type (void) {
	static volatile gsize rygel_media_export_media_export_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_export_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaExportItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_export_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaExportItem), 0, (GInstanceInitFunc) rygel_media_export_media_export_item_instance_init, NULL };
		GType rygel_media_export_media_export_item_type_id;
		rygel_media_export_media_export_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMediaExportMediaExportItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_export_item_type_id__volatile, rygel_media_export_media_export_item_type_id);
	}
	return rygel_media_export_media_export_item_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




