/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <gnome.h>

#include <pan/debug.h>
#include <pan/globals.h>
#include <pan/newsrc-port.h>
#include <pan/newsrc-ui.h>
#include <pan/util.h>
#include <pan/util-file.h>

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

static void
newsrc_import_dialog_clicked_cb (GnomeDialog * dialog, gint num, gpointer data)
{
	Server * server = SERVER(data);

	g_return_if_fail (server != NULL);

	if (num == 0)
	{
		GnomeFileEntry * gfe = gtk_object_get_data (
			GTK_OBJECT(dialog), "file_entry");
		const char * filename = gnome_file_entry_get_full_path (gfe, 0);
		newsrc_import (server, filename, FALSE);
	}

        gtk_widget_destroy (GTK_WIDGET(dialog));
}

void
newsrc_import_dialog (Server * server)
{
	GtkWidget * hbox;
	GtkWidget * dialog;
	GtkWidget * w;
	GtkWidget * file_entry;
	gchar * s;

	pan_lock ();

	dialog = gnome_dialog_new (_("Import .newsrc File"),
	                           GNOME_STOCK_BUTTON_OK,
	                           GNOME_STOCK_BUTTON_CANCEL,
	                           NULL);

	hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);

	s = _("Select .newsrc File to Read:");
	w = gtk_label_new (s);
	gtk_box_pack_start (GTK_BOX(hbox), w, FALSE, FALSE, 0);
	file_entry = gnome_file_entry_new ("newsrc", s);
	gnome_file_entry_set_default_path (GNOME_FILE_ENTRY(file_entry),
	                                   g_get_home_dir());
	gtk_signal_connect (GTK_OBJECT(dialog), "clicked",
	                    GTK_SIGNAL_FUNC (newsrc_import_dialog_clicked_cb),
	                    server);
	gtk_box_pack_start (GTK_BOX(hbox), file_entry, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, 0, 0, 0);
	gtk_object_set_data (GTK_OBJECT(dialog), "file_entry", file_entry);
	gnome_dialog_set_parent (GNOME_DIALOG(dialog), GTK_WINDOW(Pan.window));
	gtk_widget_show_all (dialog);
	pan_unlock();
}

/*****
******
*****/

static void
newsrc_export_dialog_clicked_cb (GnomeDialog * dialog, int num, gpointer data)
{
	Server * server = SERVER(data);

	g_return_if_fail (server != NULL);

	if (num == 0)
	{
		GnomeFileEntry * gfe = gtk_object_get_data (
			GTK_OBJECT(dialog), "file_entry");
		const char * filename = gnome_file_entry_get_full_path (gfe, 0);
		newsrc_export (server, filename, FALSE, TRUE);
	}

        gtk_widget_destroy (GTK_WIDGET(dialog));
}
void
newsrc_export_dialog (Server * server)
{
	GtkWidget * hbox;
	GtkWidget * dialog;
	GtkWidget * w;
	GtkWidget * file_entry;
	gchar * s;

	pan_lock ();

	dialog = gnome_dialog_new (_("Export .newsrc File"),
	                           GNOME_STOCK_BUTTON_OK,
	                           GNOME_STOCK_BUTTON_CANCEL,
	                           NULL);

	hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);

	s = _("Select .newsrc File to Write:");
	w = gtk_label_new (s);
	gtk_box_pack_start (GTK_BOX(hbox), w, FALSE, FALSE, 0);
	file_entry = gnome_file_entry_new ("newsrc", s);
	gnome_file_entry_set_default_path (GNOME_FILE_ENTRY(file_entry),
	                                   g_get_home_dir());
	gtk_signal_connect (GTK_OBJECT(dialog), "clicked",
	                    GTK_SIGNAL_FUNC (newsrc_export_dialog_clicked_cb),
	                    server);
	gtk_box_pack_start (GTK_BOX(hbox), file_entry, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, 0, 0, 0);
	gtk_object_set_data (GTK_OBJECT(dialog), "file_entry", file_entry);
	gnome_dialog_set_parent (GNOME_DIALOG(dialog), GTK_WINDOW(Pan.window));
	gtk_widget_show_all (dialog);
	pan_unlock();
}
