/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (C) Copyright 2009 Novell, Inc.
 */

#ifndef NM_GSM_PIN_REQUEST_ITEM_H
#define NM_GSM_PIN_REQUEST_ITEM_H

#include <glib-object.h>
#include <gio/gio.h>
#include <nm-gsm-device.h>
#include <nm-list-item.h>

G_BEGIN_DECLS

#define NM_TYPE_GSM_PIN_REQUEST_ITEM            (nm_gsm_pin_request_item_get_type ())
#define NM_GSM_PIN_REQUEST_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_TYPE_GSM_PIN_REQUEST_ITEM, NMGsmPinRequestItem))
#define NM_GSM_PIN_REQUEST_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_TYPE_GSM_PIN_REQUEST_ITEM, NMGsmPinRequestItemClass))
#define NM_IS_GSM_PIN_REQUEST_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_TYPE_GSM_PIN_REQUEST_ITEM))
#define NM_IS_GSM_PIN_REQUEST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NM_TYPE_GSM_PIN_REQUEST_ITEM))
#define NM_GSM_PIN_REQUEST_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_TYPE_GSM_PIN_REQUEST_ITEM, NMGsmPinRequestItemClass))

typedef struct {
    NMListItem parent;
} NMGsmPinRequestItem;

typedef struct {
    NMListItemClass parent_class;

    /* Signals */
    void (*unlocked) (NMGsmPinRequestItem *self);
} NMGsmPinRequestItemClass;

GType nm_gsm_pin_request_item_get_type (void);

NMListItem *nm_gsm_pin_request_item_new    (NMGsmDevice *device);
void        nm_gsm_pin_request_item_unlock (NMGsmPinRequestItem *self,
                                            const char *pin,
                                            gboolean disable_pin);

G_END_DECLS

#endif /* NM_GSM_PIN_REQUEST_ITEM_H */
