/* InputParser.c generated by valac, the Vala compiler
 * generated from InputParser.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};


static gpointer input_parser_parent_class = NULL;

GQuark hex_parse_error_quark (void);
GType input_parser_get_type (void);
enum  {
	INPUT_PARSER_DUMMY_PROPERTY
};
char* input_parser_statusReplace (const char* oldString);
static gchar input_parser_xtoi (gunichar c);
guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error);
InputParser* input_parser_new (void);
InputParser* input_parser_construct (GType object_type);



GQuark hex_parse_error_quark (void) {
	return g_quark_from_static_string ("hex_parse_error-quark");
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


char* input_parser_statusReplace (const char* oldString) {
	char* result;
	g_return_val_if_fail (oldString != NULL, NULL);
	result = string_replace (oldString, "\\r", "\\n");
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error) {
	guchar* result;
	GError * _inner_error_;
	glong len;
	guchar* _tmp0_;
	gint r_size;
	gint r_length1;
	guchar* r;
	guchar* _tmp2_;
	g_return_val_if_fail (s != NULL, NULL);
	_inner_error_ = NULL;
	len = string_get_length (s);
	r = (_tmp0_ = g_new0 (guchar, (len + 1) / 2), r_length1 = (len + 1) / 2, r_size = r_length1, _tmp0_);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gunichar c = 0U;
				gint i = 0;
				gint temp = 0;
				if (!_tmp1_) {
					x++;
				}
				_tmp1_ = FALSE;
				if (!(x < ((len + 1) / 2))) {
					break;
				}
				c = g_utf8_get_char (s);
				if (len > 1) {
					i = input_parser_xtoi (c) * 16;
					if (i < 0) {
						_inner_error_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
						{
							if (_inner_error_->domain == HEX_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								r = (g_free (r), NULL);
								return NULL;
							} else {
								r = (g_free (r), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
					s = g_utf8_next_char (s);
					c = g_utf8_get_char (s);
					temp = (gint) input_parser_xtoi (c);
					if (temp < 0) {
						_inner_error_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
						{
							if (_inner_error_->domain == HEX_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								r = (g_free (r), NULL);
								return NULL;
							} else {
								r = (g_free (r), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
					i = i + temp;
				} else {
					i = (gint) input_parser_xtoi (c);
					if (i < 0) {
						_inner_error_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
						{
							if (_inner_error_->domain == HEX_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								r = (g_free (r), NULL);
								return NULL;
							} else {
								r = (g_free (r), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
				s = g_utf8_next_char (s);
				r[x] = (guchar) i;
			}
		}
	}
	result = (_tmp2_ = r, *result_length1 = r_length1, _tmp2_);
	return result;
	r = (g_free (r), NULL);
}


static gchar input_parser_xtoi (gunichar c) {
	gchar result;
	gchar i;
	i = (gchar) (-1);
	switch (c) {
		case '0':
		{
			i = (gchar) 0;
			break;
		}
		case '1':
		{
			i = (gchar) 1;
			break;
		}
		case '2':
		{
			i = (gchar) 2;
			break;
		}
		case '3':
		{
			i = (gchar) 3;
			break;
		}
		case '4':
		{
			i = (gchar) 4;
			break;
		}
		case '5':
		{
			i = (gchar) 5;
			break;
		}
		case '6':
		{
			i = (gchar) 6;
			break;
		}
		case '7':
		{
			i = (gchar) 7;
			break;
		}
		case '8':
		{
			i = (gchar) 8;
			break;
		}
		case '9':
		{
			i = (gchar) 9;
			break;
		}
		case 'a':
		{
			i = (gchar) 10;
			break;
		}
		case 'b':
		{
			i = (gchar) 11;
			break;
		}
		case 'c':
		{
			i = (gchar) 12;
			break;
		}
		case 'd':
		{
			i = (gchar) 13;
			break;
		}
		case 'e':
		{
			i = (gchar) 14;
			break;
		}
		case 'f':
		{
			i = (gchar) 15;
			break;
		}
		case 'A':
		{
			i = (gchar) 10;
			break;
		}
		case 'B':
		{
			i = (gchar) 11;
			break;
		}
		case 'C':
		{
			i = (gchar) 12;
			break;
		}
		case 'D':
		{
			i = (gchar) 13;
			break;
		}
		case 'E':
		{
			i = (gchar) 14;
			break;
		}
		case 'F':
		{
			i = (gchar) 15;
			break;
		}
	}
	result = i;
	return result;
}


InputParser* input_parser_construct (GType object_type) {
	InputParser * self;
	self = (InputParser*) g_object_new (object_type, NULL);
	return self;
}


InputParser* input_parser_new (void) {
	return input_parser_construct (TYPE_INPUT_PARSER);
}


static void input_parser_class_init (InputParserClass * klass) {
	input_parser_parent_class = g_type_class_peek_parent (klass);
}


static void input_parser_instance_init (InputParser * self) {
}


GType input_parser_get_type (void) {
	static GType input_parser_type_id = 0;
	if (input_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
		input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
	}
	return input_parser_type_id;
}




