
#include <src/SendProgressDialog.h>
#include <glib/gi18n-lib.h>




struct _moserialSendProgressDialogPrivate {
	GtkBuilder* _builder;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkLabel* status;
	GtkProgressBar* progressBar;
};

#define MOSERIAL_SEND_PROGRESS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogPrivate))
enum  {
	MOSERIAL_SEND_PROGRESS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER
};
static void moserial_send_progress_dialog_set_builder (moserialSendProgressDialog* self, GtkBuilder* value);
static void _moserial_send_progress_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _moserial_send_progress_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self);
static GObject * moserial_send_progress_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_send_progress_dialog_parent_class = NULL;
static void moserial_send_progress_dialog_finalize (GObject* obj);



moserialSendProgressDialog* moserial_send_progress_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialSendProgressDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialSendProgressDialog* moserial_send_progress_dialog_new (GtkBuilder* builder) {
	return moserial_send_progress_dialog_construct (MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, builder);
}


void moserial_send_progress_dialog_show (moserialSendProgressDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	gtk_label_set_text (self->priv->status, _ ("Waiting for remote host"));
}


gboolean moserial_send_progress_dialog_hide (moserialSendProgressDialog* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	return TRUE;
}


void moserial_send_progress_dialog_updateStatus (moserialSendProgressDialog* self, GObject* o, const char* newStatus) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (newStatus != NULL);
	gtk_label_set_text (self->priv->status, newStatus);
	gtk_progress_bar_pulse (self->priv->progressBar);
}


void moserial_send_progress_dialog_cancel (moserialSendProgressDialog* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	/*TODO: make canceling transfers actually work*/
	g_signal_emit_by_name (self, "transfer-canceled");
}


GtkBuilder* moserial_send_progress_dialog_get_builder (moserialSendProgressDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_send_progress_dialog_set_builder (moserialSendProgressDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


static void _moserial_send_progress_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_send_progress_dialog_cancel (self, _sender);
}


static gboolean _moserial_send_progress_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self) {
	return moserial_send_progress_dialog_hide (self);
}


static GObject * moserial_send_progress_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialSendProgressDialogClass * klass;
	GObjectClass * parent_class;
	moserialSendProgressDialog * self;
	klass = MOSERIAL_SEND_PROGRESS_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_SEND_PROGRESS_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SEND_PROGRESS_DIALOG (obj);
	{
		GtkDialog* _tmp1;
		GtkDialog* _tmp0;
		GtkButton* _tmp3;
		GtkButton* _tmp2;
		GtkLabel* _tmp5;
		GtkLabel* _tmp4;
		GtkProgressBar* _tmp7;
		GtkProgressBar* _tmp6;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->dialog = (_tmp1 = (_tmp0 = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "send_progress_dialog")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->cancelButton = (_tmp3 = (_tmp2 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "send_progress_cancel")), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp3);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_send_progress_dialog_cancel_gtk_button_clicked, self, 0);
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->priv->status = (_tmp5 = (_tmp4 = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "send_statusbox")), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->status == NULL) ? NULL : (self->priv->status = (g_object_unref (self->priv->status), NULL)), _tmp5);
		_tmp7 = NULL;
		_tmp6 = NULL;
		self->priv->progressBar = (_tmp7 = (_tmp6 = GTK_PROGRESS_BAR (gtk_builder_get_object (self->priv->_builder, "send_progressbar")), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)), (self->priv->progressBar == NULL) ? NULL : (self->priv->progressBar = (g_object_unref (self->priv->progressBar), NULL)), _tmp7);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_send_progress_dialog_hide_gtk_widget_delete_event, self, 0);
	}
	return obj;
}


static void moserial_send_progress_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSendProgressDialog * self;
	gpointer boxed;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_send_progress_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_send_progress_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSendProgressDialog * self;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER:
		moserial_send_progress_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_send_progress_dialog_class_init (moserialSendProgressDialogClass * klass) {
	moserial_send_progress_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSendProgressDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_send_progress_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_send_progress_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_send_progress_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_send_progress_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_canceled", MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void moserial_send_progress_dialog_instance_init (moserialSendProgressDialog * self) {
	self->priv = MOSERIAL_SEND_PROGRESS_DIALOG_GET_PRIVATE (self);
}


static void moserial_send_progress_dialog_finalize (GObject* obj) {
	moserialSendProgressDialog * self;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->status == NULL) ? NULL : (self->priv->status = (g_object_unref (self->priv->status), NULL));
	(self->priv->progressBar == NULL) ? NULL : (self->priv->progressBar = (g_object_unref (self->priv->progressBar), NULL));
	G_OBJECT_CLASS (moserial_send_progress_dialog_parent_class)->finalize (obj);
}


GType moserial_send_progress_dialog_get_type (void) {
	static GType moserial_send_progress_dialog_type_id = 0;
	if (moserial_send_progress_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSendProgressDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_send_progress_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSendProgressDialog), 0, (GInstanceInitFunc) moserial_send_progress_dialog_instance_init, NULL };
		moserial_send_progress_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSendProgressDialog", &g_define_type_info, 0);
	}
	return moserial_send_progress_dialog_type_id;
}




