
#include <src/PreferencesDialog.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>




struct _moserialPreferencesDialogPrivate {
	GtkBuilder* _builder;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	GtkCheckButton* systemFont;
	GtkFontButton* fontButton;
	GtkColorButton* fontColorButton;
	GtkColorButton* backgroundColorButton;
	GtkColorButton* highlightColorButton;
	GtkCheckButton* recordLaunch;
	GtkCheckButton* enableTimeout;
	GtkSpinButton* timeout;
};

#define MOSERIAL_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogPrivate))
enum  {
	MOSERIAL_PREFERENCES_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_PREFERENCES_DIALOG_BUILDER
};
static void moserial_preferences_dialog_set_builder (moserialPreferencesDialog* self, GtkBuilder* value);
static void _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self);
static void _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self);
static void _moserial_preferences_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_preferences_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _moserial_preferences_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self);
static GObject * moserial_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_preferences_dialog_parent_class = NULL;
static void moserial_preferences_dialog_finalize (GObject* obj);



moserialPreferencesDialog* moserial_preferences_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialPreferencesDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialPreferencesDialog* moserial_preferences_dialog_new (GtkBuilder* builder) {
	return moserial_preferences_dialog_construct (MOSERIAL_TYPE_PREFERENCES_DIALOG, builder);
}


void moserial_preferences_dialog_ok (moserialPreferencesDialog* self, GtkButton* button) {
	gboolean pSystemFont;
	char* pFont;
	char* pFontColor;
	char* pBackgroundColor;
	char* pHighlightColor;
	gboolean pRecordLaunch;
	gboolean pEnableTimeout;
	gint pTimeout;
	char* _tmp1;
	const char* _tmp0;
	GdkColor c = {0};
	char* _tmp3;
	const char* _tmp2;
	char* _tmp5;
	const char* _tmp4;
	char* _tmp7;
	const char* _tmp6;
	Preferences* preferences;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	moserial_preferences_dialog_hide (self);
	pSystemFont = FALSE;
	pFont = NULL;
	pFontColor = NULL;
	pBackgroundColor = NULL;
	pHighlightColor = NULL;
	pRecordLaunch = FALSE;
	pEnableTimeout = FALSE;
	pTimeout = 0;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->systemFont)) {
		pSystemFont = TRUE;
	} else {
		pSystemFont = FALSE;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	pFont = (_tmp1 = (_tmp0 = gtk_font_button_get_font_name (self->priv->fontButton), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), pFont = (g_free (pFont), NULL), _tmp1);
	gtk_color_button_get_color (self->priv->fontColorButton, &c);
	_tmp3 = NULL;
	_tmp2 = NULL;
	pFontColor = (_tmp3 = (_tmp2 = gdk_color_to_string (&c), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), pFontColor = (g_free (pFontColor), NULL), _tmp3);
	gtk_color_button_get_color (self->priv->backgroundColorButton, &c);
	_tmp5 = NULL;
	_tmp4 = NULL;
	pBackgroundColor = (_tmp5 = (_tmp4 = gdk_color_to_string (&c), (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), pBackgroundColor = (g_free (pBackgroundColor), NULL), _tmp5);
	gtk_color_button_get_color (self->priv->highlightColorButton, &c);
	_tmp7 = NULL;
	_tmp6 = NULL;
	pHighlightColor = (_tmp7 = (_tmp6 = gdk_color_to_string (&c), (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), pHighlightColor = (g_free (pHighlightColor), NULL), _tmp7);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->recordLaunch)) {
		pRecordLaunch = TRUE;
	} else {
		pRecordLaunch = FALSE;
	}
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->enableTimeout)) {
		pEnableTimeout = TRUE;
	} else {
		pEnableTimeout = FALSE;
	}
	pTimeout = (gint) gtk_spin_button_get_value (self->priv->timeout);
	preferences = preferences_new (pSystemFont, pFont, pFontColor, pBackgroundColor, pHighlightColor, pRecordLaunch, pEnableTimeout, pTimeout);
	g_signal_emit_by_name (self, "update-preferences", preferences);
	pFont = (g_free (pFont), NULL);
	pFontColor = (g_free (pFontColor), NULL);
	pBackgroundColor = (g_free (pBackgroundColor), NULL);
	pHighlightColor = (g_free (pHighlightColor), NULL);
	(preferences == NULL) ? NULL : (preferences = (g_object_unref (preferences), NULL));
}


void moserial_preferences_dialog_show (moserialPreferencesDialog* self, Preferences* preferences, gboolean recording) {
	GdkColor _tmp0 = {0};
	GdkColor _tmp1 = {0};
	GdkColor _tmp2 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	if (preferences_get_useSystemMonospaceFont (preferences)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, FALSE);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->systemFont, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, TRUE);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->systemFont, FALSE);
	}
	gtk_font_button_set_font_name (self->priv->fontButton, preferences_get_font (preferences));
	gtk_color_button_set_color (self->priv->fontColorButton, (_tmp0 = preferences_getGdkColor (preferences_get_fontColor (preferences)), &_tmp0));
	gtk_color_button_set_color (self->priv->backgroundColorButton, (_tmp1 = preferences_getGdkColor (preferences_get_backgroundColor (preferences)), &_tmp1));
	gtk_color_button_set_color (self->priv->highlightColorButton, (_tmp2 = preferences_getGdkColor (preferences_get_highlightColor (preferences)), &_tmp2));
	if (preferences_get_recordLaunch (preferences)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->recordLaunch, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->recordLaunch, FALSE);
	}
	if (preferences_get_enableTimeout (preferences)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->enableTimeout, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->enableTimeout, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	}
	if (recording) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->enableTimeout, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->enableTimeout, TRUE);
	}
	gtk_spin_button_set_value (self->priv->timeout, (double) preferences_get_timeout (preferences));
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


void moserial_preferences_dialog_cancel (moserialPreferencesDialog* self, GtkWidget* w) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	/*currentPreferences=null;*/
	moserial_preferences_dialog_hide (self);
}


gboolean moserial_preferences_dialog_hide (moserialPreferencesDialog* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	return TRUE;
}


void moserial_preferences_dialog_systemFontToggled (moserialPreferencesDialog* self, GtkCheckButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, TRUE);
	}
}


void moserial_preferences_dialog_enableTimeoutToggled (moserialPreferencesDialog* self, GtkCheckButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	}
}


GtkBuilder* moserial_preferences_dialog_get_builder (moserialPreferencesDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_preferences_dialog_set_builder (moserialPreferencesDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


static void _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self) {
	moserial_preferences_dialog_systemFontToggled (self, _sender);
}


static void _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self) {
	moserial_preferences_dialog_enableTimeoutToggled (self, _sender);
}


static void _moserial_preferences_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_preferences_dialog_ok (self, _sender);
}


static void _moserial_preferences_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_preferences_dialog_cancel (self, _sender);
}


static gboolean _moserial_preferences_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self) {
	return moserial_preferences_dialog_hide (self);
}


static GObject * moserial_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialPreferencesDialogClass * klass;
	GObjectClass * parent_class;
	moserialPreferencesDialog * self;
	klass = MOSERIAL_PREFERENCES_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_PREFERENCES_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_PREFERENCES_DIALOG (obj);
	{
		GtkDialog* _tmp1;
		GtkDialog* _tmp0;
		GtkButton* _tmp3;
		GtkButton* _tmp2;
		GtkButton* _tmp5;
		GtkButton* _tmp4;
		GtkCheckButton* _tmp7;
		GtkCheckButton* _tmp6;
		GtkFontButton* _tmp9;
		GtkFontButton* _tmp8;
		GtkColorButton* _tmp11;
		GtkColorButton* _tmp10;
		GtkColorButton* _tmp13;
		GtkColorButton* _tmp12;
		GtkColorButton* _tmp15;
		GtkColorButton* _tmp14;
		GtkCheckButton* _tmp17;
		GtkCheckButton* _tmp16;
		GtkCheckButton* _tmp19;
		GtkCheckButton* _tmp18;
		GtkSpinButton* _tmp21;
		GtkSpinButton* _tmp20;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->dialog = (_tmp1 = (_tmp0 = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "preferences_dialog")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->okButton = (_tmp3 = (_tmp2 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_ok")), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL)), _tmp3);
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->priv->cancelButton = (_tmp5 = (_tmp4 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_cancel")), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp5);
		_tmp7 = NULL;
		_tmp6 = NULL;
		self->priv->systemFont = (_tmp7 = (_tmp6 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_use_system_font")), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)), (self->priv->systemFont == NULL) ? NULL : (self->priv->systemFont = (g_object_unref (self->priv->systemFont), NULL)), _tmp7);
		_tmp9 = NULL;
		_tmp8 = NULL;
		self->priv->fontButton = (_tmp9 = (_tmp8 = GTK_FONT_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_font_button")), (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8)), (self->priv->fontButton == NULL) ? NULL : (self->priv->fontButton = (g_object_unref (self->priv->fontButton), NULL)), _tmp9);
		_tmp11 = NULL;
		_tmp10 = NULL;
		self->priv->fontColorButton = (_tmp11 = (_tmp10 = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_font_color_button")), (_tmp10 == NULL) ? NULL : g_object_ref (_tmp10)), (self->priv->fontColorButton == NULL) ? NULL : (self->priv->fontColorButton = (g_object_unref (self->priv->fontColorButton), NULL)), _tmp11);
		_tmp13 = NULL;
		_tmp12 = NULL;
		self->priv->backgroundColorButton = (_tmp13 = (_tmp12 = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_background_color_button")), (_tmp12 == NULL) ? NULL : g_object_ref (_tmp12)), (self->priv->backgroundColorButton == NULL) ? NULL : (self->priv->backgroundColorButton = (g_object_unref (self->priv->backgroundColorButton), NULL)), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		self->priv->highlightColorButton = (_tmp15 = (_tmp14 = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_highlight_color_button")), (_tmp14 == NULL) ? NULL : g_object_ref (_tmp14)), (self->priv->highlightColorButton == NULL) ? NULL : (self->priv->highlightColorButton = (g_object_unref (self->priv->highlightColorButton), NULL)), _tmp15);
		_tmp17 = NULL;
		_tmp16 = NULL;
		self->priv->recordLaunch = (_tmp17 = (_tmp16 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_launch")), (_tmp16 == NULL) ? NULL : g_object_ref (_tmp16)), (self->priv->recordLaunch == NULL) ? NULL : (self->priv->recordLaunch = (g_object_unref (self->priv->recordLaunch), NULL)), _tmp17);
		_tmp19 = NULL;
		_tmp18 = NULL;
		self->priv->enableTimeout = (_tmp19 = (_tmp18 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_enable_timeout")), (_tmp18 == NULL) ? NULL : g_object_ref (_tmp18)), (self->priv->enableTimeout == NULL) ? NULL : (self->priv->enableTimeout = (g_object_unref (self->priv->enableTimeout), NULL)), _tmp19);
		_tmp21 = NULL;
		_tmp20 = NULL;
		self->priv->timeout = (_tmp21 = (_tmp20 = GTK_SPIN_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_timeout")), (_tmp20 == NULL) ? NULL : g_object_ref (_tmp20)), (self->priv->timeout == NULL) ? NULL : (self->priv->timeout = (g_object_unref (self->priv->timeout), NULL)), _tmp21);
		g_signal_connect_object ((GtkToggleButton*) self->priv->systemFont, "toggled", (GCallback) _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled, self, 0);
		g_signal_connect_object ((GtkToggleButton*) self->priv->enableTimeout, "toggled", (GCallback) _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled, self, 0);
		g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_preferences_dialog_ok_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_preferences_dialog_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_preferences_dialog_hide_gtk_widget_delete_event, self, 0);
	}
	return obj;
}


static void moserial_preferences_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialPreferencesDialog * self;
	gpointer boxed;
	self = MOSERIAL_PREFERENCES_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_PREFERENCES_DIALOG_BUILDER:
		g_value_set_object (value, moserial_preferences_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_preferences_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialPreferencesDialog * self;
	self = MOSERIAL_PREFERENCES_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_PREFERENCES_DIALOG_BUILDER:
		moserial_preferences_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_preferences_dialog_class_init (moserialPreferencesDialogClass * klass) {
	moserial_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialPreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_preferences_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_preferences_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_preferences_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_PREFERENCES_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_preferences", MOSERIAL_TYPE_PREFERENCES_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PREFERENCES);
}


static void moserial_preferences_dialog_instance_init (moserialPreferencesDialog * self) {
	self->priv = MOSERIAL_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void moserial_preferences_dialog_finalize (GObject* obj) {
	moserialPreferencesDialog * self;
	self = MOSERIAL_PREFERENCES_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL));
	(self->priv->systemFont == NULL) ? NULL : (self->priv->systemFont = (g_object_unref (self->priv->systemFont), NULL));
	(self->priv->fontButton == NULL) ? NULL : (self->priv->fontButton = (g_object_unref (self->priv->fontButton), NULL));
	(self->priv->fontColorButton == NULL) ? NULL : (self->priv->fontColorButton = (g_object_unref (self->priv->fontColorButton), NULL));
	(self->priv->backgroundColorButton == NULL) ? NULL : (self->priv->backgroundColorButton = (g_object_unref (self->priv->backgroundColorButton), NULL));
	(self->priv->highlightColorButton == NULL) ? NULL : (self->priv->highlightColorButton = (g_object_unref (self->priv->highlightColorButton), NULL));
	(self->priv->recordLaunch == NULL) ? NULL : (self->priv->recordLaunch = (g_object_unref (self->priv->recordLaunch), NULL));
	(self->priv->enableTimeout == NULL) ? NULL : (self->priv->enableTimeout = (g_object_unref (self->priv->enableTimeout), NULL));
	(self->priv->timeout == NULL) ? NULL : (self->priv->timeout = (g_object_unref (self->priv->timeout), NULL));
	G_OBJECT_CLASS (moserial_preferences_dialog_parent_class)->finalize (obj);
}


GType moserial_preferences_dialog_get_type (void) {
	static GType moserial_preferences_dialog_type_id = 0;
	if (moserial_preferences_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialPreferencesDialog), 0, (GInstanceInitFunc) moserial_preferences_dialog_instance_init, NULL };
		moserial_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialPreferencesDialog", &g_define_type_info, 0);
	}
	return moserial_preferences_dialog_type_id;
}




