
#ifndef __SRC_DEFAULTPATHS_H__
#define __SRC_DEFAULTPATHS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/Profile.h"

G_BEGIN_DECLS


#define TYPE_DEFAULT_PATHS (default_paths_get_type ())
#define DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_PATHS, DefaultPaths))
#define DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_PATHS, DefaultPathsClass))
#define IS_DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_PATHS))
#define IS_DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_PATHS))
#define DEFAULT_PATHS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_PATHS, DefaultPathsClass))

typedef struct _DefaultPaths DefaultPaths;
typedef struct _DefaultPathsClass DefaultPathsClass;
typedef struct _DefaultPathsPrivate DefaultPathsPrivate;

struct _DefaultPaths {
	GObject parent_instance;
	DefaultPathsPrivate * priv;
};

struct _DefaultPathsClass {
	GObjectClass parent_class;
};


DefaultPaths* default_paths_construct (GType object_type, const char* RecordTo, const char* ReceiveTo, const char* SendFrom);
DefaultPaths* default_paths_new (const char* RecordTo, const char* ReceiveTo, const char* SendFrom);
void default_paths_saveToProfile (DefaultPaths* self, Profile* profile);
DefaultPaths* default_paths_loadFromProfile (Profile* profile);
char* default_paths_getPath (Profile* profile, const char* group, const char* key);
const char* default_paths_get_recordTo (DefaultPaths* self);
void default_paths_set_recordTo (DefaultPaths* self, const char* value);
const char* default_paths_get_receiveTo (DefaultPaths* self);
void default_paths_set_receiveTo (DefaultPaths* self, const char* value);
const char* default_paths_get_sendFrom (DefaultPaths* self);
void default_paths_set_sendFrom (DefaultPaths* self, const char* value);
GType default_paths_get_type (void);


G_END_DECLS

#endif
