/*Class for communicating with the sz program*/

#ifndef __SRC_SZWRAPPER_H__
#define __SRC_SZWRAPPER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/SerialConnection.h"

G_BEGIN_DECLS


#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	moserialSerialConnection* sc;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;


GType moserial_szwrapper_protocol_get_type (void);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self);
const char* moserial_szwrapper_get_filename (moserialSzwrapper* self);
GType moserial_szwrapper_get_type (void);


G_END_DECLS

#endif
