
#ifndef __SRC_SETTINGS_H__
#define __SRC_SETTINGS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/Profile.h"

G_BEGIN_DECLS


#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;


GType settings_parity_get_type (void);
GType settings_handshake_get_type (void);
GType settings_access_mode_get_type (void);
extern char* settings_DEFAULT_DEVICEFILE;
extern gint settings_DEFAULT_BAUDRATE;
extern gint settings_DEFAULT_DATABITS;
extern gint settings_DEFAULT_STOPBITS;
extern SettingsParity settings_DEFAULT_PARITY;
extern SettingsHandshake settings_DEFAULT_HANDSHAKE;
extern SettingsAccessMode settings_DEFAULT_ACCESSMODE;
extern gboolean settings_DEFAULT_LOCAL_ECHO;
Settings* settings_construct (GType object_type, const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_new (const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
char* settings_parityToChar (Settings* self);
char* settings_getStatusbarString (Settings* self, gboolean open);
void settings_saveToProfile (Settings* self, Profile* profile);
Settings* settings_loadFromProfile (Profile* profile);
const char* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
SettingsParity settings_get_parity (Settings* self);
SettingsHandshake settings_get_handshake (Settings* self);
SettingsAccessMode settings_get_accessMode (Settings* self);
gboolean settings_get_localEcho (Settings* self);
GType settings_get_type (void);


G_END_DECLS

#endif
