
#include <src/RecordDialog.h>
#include "src/MoUtils.h"




struct _moserialRecordDialogPrivate {
	GtkBuilder* _builder;
	GtkFileChooserDialog* dialog;
	GtkButton* cancelButton;
	GtkComboBox* streamCombo;
	char* _fileName;
};

#define MOSERIAL_RECORD_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogPrivate))
enum  {
	MOSERIAL_RECORD_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_RECORD_DIALOG_BUILDER,
	MOSERIAL_RECORD_DIALOG_FILE_NAME
};
static void moserial_record_dialog_response (moserialRecordDialog* self, GtkWidget* w, gint r);
static void moserial_record_dialog_set_builder (moserialRecordDialog* self, GtkBuilder* value);
static void moserial_record_dialog_set_fileName (moserialRecordDialog* self, const char* value);
static gboolean _moserial_record_dialog_hide_gtk_widget_delete_event (GtkFileChooserDialog* _sender, const GdkEvent* event, gpointer self);
static void _moserial_record_dialog_response_gtk_dialog_response (GtkFileChooserDialog* _sender, gint response_id, gpointer self);
static GObject * moserial_record_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_record_dialog_parent_class = NULL;
static void moserial_record_dialog_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

moserialRecordDialog* moserial_record_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialRecordDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialRecordDialog* moserial_record_dialog_new (GtkBuilder* builder) {
	return moserial_record_dialog_construct (MOSERIAL_TYPE_RECORD_DIALOG, builder);
}


void moserial_record_dialog_show (moserialRecordDialog* self, const char* folder) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (folder != NULL) {
		_tmp0 = mo_utils_fileExists (folder);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) self->priv->dialog, folder);
	}
	gtk_dialog_run ((GtkDialog*) self->priv->dialog);
}


gboolean moserial_record_dialog_hide (moserialRecordDialog* self, GtkWidget* w) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	return TRUE;
}


static void moserial_record_dialog_response (moserialRecordDialog* self, GtkWidget* w, gint r) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	if (r == GTK_RESPONSE_CANCEL) {
		moserial_record_dialog_set_fileName (self, NULL);
		moserial_record_dialog_hide (self, w);
		g_signal_emit_by_name (self, "stop-recording");
	} else {
		if (r == GTK_RESPONSE_ACCEPT) {
			moserial_record_dialog_set_fileName (self, gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->dialog));
			switch (gtk_combo_box_get_active (self->priv->streamCombo)) {
				default:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING;
					break;
				}
				case 1:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING;
					break;
				}
				case 2:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
					break;
				}
			}
			moserial_record_dialog_hide (self, w);
			g_signal_emit_by_name (self, "start-recording", self->priv->_fileName, self->direction);
		} else {
			g_signal_emit_by_name (self, "stop-recording");
		}
	}
}


GtkBuilder* moserial_record_dialog_get_builder (moserialRecordDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_record_dialog_set_builder (moserialRecordDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


const char* moserial_record_dialog_get_fileName (moserialRecordDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_fileName;
}


static void moserial_record_dialog_set_fileName (moserialRecordDialog* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_fileName = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_fileName = (g_free (self->priv->_fileName), NULL), _tmp2);
	g_object_notify ((GObject *) self, "fileName");
}


static gboolean _moserial_record_dialog_hide_gtk_widget_delete_event (GtkFileChooserDialog* _sender, const GdkEvent* event, gpointer self) {
	return moserial_record_dialog_hide (self, _sender);
}


static void _moserial_record_dialog_response_gtk_dialog_response (GtkFileChooserDialog* _sender, gint response_id, gpointer self) {
	moserial_record_dialog_response (self, _sender, response_id);
}


static GObject * moserial_record_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialRecordDialogClass * klass;
	GObjectClass * parent_class;
	moserialRecordDialog * self;
	klass = MOSERIAL_RECORD_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_RECORD_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RECORD_DIALOG (obj);
	{
		GtkFileChooserDialog* _tmp1;
		GtkFileChooserDialog* _tmp0;
		GtkButton* _tmp3;
		GtkButton* _tmp2;
		GtkComboBox* _tmp5;
		GtkComboBox* _tmp4;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->dialog = (_tmp1 = (_tmp0 = GTK_FILE_CHOOSER_DIALOG (gtk_builder_get_object (self->priv->_builder, "record_dialog")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->cancelButton = (_tmp3 = (_tmp2 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "record_cancel")), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp3);
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->priv->streamCombo = (_tmp5 = (_tmp4 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "record_stream")), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->streamCombo == NULL) ? NULL : (self->priv->streamCombo = (g_object_unref (self->priv->streamCombo), NULL)), _tmp5);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_record_dialog_hide_gtk_widget_delete_event, self, 0);
		g_signal_connect_object ((GtkDialog*) self->priv->dialog, "response", (GCallback) _moserial_record_dialog_response_gtk_dialog_response, self, 0);
		gtk_dialog_add_buttons ((GtkDialog*) self->priv->dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
		gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) self->priv->dialog, TRUE);
		gtk_file_chooser_set_local_only ((GtkFileChooser*) self->priv->dialog, FALSE);
		gtk_combo_box_set_active (self->priv->streamCombo, 0);
		moserial_record_dialog_set_fileName (self, NULL);
	}
	return obj;
}


static void moserial_record_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRecordDialog * self;
	gpointer boxed;
	self = MOSERIAL_RECORD_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECORD_DIALOG_BUILDER:
		g_value_set_object (value, moserial_record_dialog_get_builder (self));
		break;
		case MOSERIAL_RECORD_DIALOG_FILE_NAME:
		g_value_set_string (value, moserial_record_dialog_get_fileName (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_record_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRecordDialog * self;
	self = MOSERIAL_RECORD_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECORD_DIALOG_BUILDER:
		moserial_record_dialog_set_builder (self, g_value_get_object (value));
		break;
		case MOSERIAL_RECORD_DIALOG_FILE_NAME:
		moserial_record_dialog_set_fileName (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_record_dialog_class_init (moserialRecordDialogClass * klass) {
	moserial_record_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRecordDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_record_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_record_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_record_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_record_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RECORD_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RECORD_DIALOG_FILE_NAME, g_param_spec_string ("fileName", "fileName", "fileName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("start_recording", MOSERIAL_TYPE_RECORD_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION);
	g_signal_new ("stop_recording", MOSERIAL_TYPE_RECORD_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void moserial_record_dialog_instance_init (moserialRecordDialog * self) {
	self->priv = MOSERIAL_RECORD_DIALOG_GET_PRIVATE (self);
}


static void moserial_record_dialog_finalize (GObject* obj) {
	moserialRecordDialog * self;
	self = MOSERIAL_RECORD_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->streamCombo == NULL) ? NULL : (self->priv->streamCombo = (g_object_unref (self->priv->streamCombo), NULL));
	self->priv->_fileName = (g_free (self->priv->_fileName), NULL);
	G_OBJECT_CLASS (moserial_record_dialog_parent_class)->finalize (obj);
}


GType moserial_record_dialog_get_type (void) {
	static GType moserial_record_dialog_type_id = 0;
	if (moserial_record_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRecordDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_record_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRecordDialog), 0, (GInstanceInitFunc) moserial_record_dialog_instance_init, NULL };
		moserial_record_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRecordDialog", &g_define_type_info, 0);
	}
	return moserial_record_dialog_type_id;
}



static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
}



