
#ifndef __SRC_INPUTPARSER_H__
#define __SRC_INPUTPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};


GQuark hex_parse_error_quark (void);
char* input_parser_statusReplace (const char* oldString);
guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error);
InputParser* input_parser_construct (GType object_type);
InputParser* input_parser_new (void);
GType input_parser_get_type (void);


G_END_DECLS

#endif
