/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView
 *
 *MlView is free software; you can redistribute it and/or 
 *modify it under the terms of 
 *the GNU General Public License as published 
 *by the Free Software Foundation; either version 2
 *or (at your option) any later version.
 *
 *MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView.
 *see the file COPYING. 
 *If not, write to the 
 *Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_GUI_H__
#define __MLVIEW_GUI_H__

#include <libgnomeui/libgnomeui.h>
#include "mlview-editor.h"

/**
 *@file 
 *the mlview application class definition.
 *It instanciates mlview's instance of  GnomeApp, 
 *fills it with an instance of MlViewEditor, builds the application menus
 *and toolbars and creates an instance of MlViewAppContext.
 */

#define MLVIEW_ROOTWINDOW_WIDTH 400
#define MLVIEW_ROOTWINDOW_HEIGHT 300
#define MLVIEW_MAINPANED_POSITION 400

G_BEGIN_DECLS
GnomeApp * mlview_app_new (const guchar * a_appname);

MlViewEditor *mlview_app_get_editor (GnomeApp * a_app_name);

void mlview_app_build_set_global_settings (MlViewAppContext * a_app_context);

G_END_DECLS
#endif
