/* gnome-db-entry-time.c
 *
 * Copyright (C) 2003 - 2006 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib/gi18n-lib.h>
#include "gnome-db-entry-time.h"
#include <libgda/gda-data-handler.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>

/* 
 * Main static functions 
 */
static void gnome_db_entry_time_class_init (GnomeDbEntryTimeClass * class);
static void gnome_db_entry_time_init (GnomeDbEntryTime * srv);
/* get a pointer to the parents to be able to call their destructor */
static GObjectClass  *parent_class = NULL;

GType
gnome_db_entry_time_get_type (void)
{
	static GType type = 0;

	if (G_UNLIKELY (type == 0)) {
		static const GTypeInfo info = {
			sizeof (GnomeDbEntryTimeClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_entry_time_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbEntryTime),
			0,
			(GInstanceInitFunc) gnome_db_entry_time_init
		};
	
		type = g_type_register_static (GNOME_DB_TYPE_ENTRY_COMMON_TIME, "GnomeDbEntryTime", &info, 0);
	}
	return type;
}

static void
gnome_db_entry_time_class_init (GnomeDbEntryTimeClass * class)
{
	GObjectClass   *object_class = G_OBJECT_CLASS (class);

	parent_class = g_type_class_peek_parent (class);
}

static void
gnome_db_entry_time_init (GnomeDbEntryTime * gnome_db_entry_time)
{
}

/**
 * gnome_db_entry_time_new
 * @dh: the data handler to be used by the new widget
 *
 * Creates a new widget which is mainly a GtkEntry
 *
 * Returns: the new widget
 */
GtkWidget *
gnome_db_entry_time_new (GdaDataHandler *dh)
{
	GObject *obj;

	g_return_val_if_fail (dh && GDA_IS_DATA_HANDLER (dh), NULL);
	g_return_val_if_fail (gda_data_handler_accepts_g_type (dh, GDA_TYPE_TIME), NULL);

	obj = g_object_new (GNOME_DB_TYPE_ENTRY_TIME, "handler", dh, "type", GDA_TYPE_TIME, NULL);

	return GTK_WIDGET (obj);
}
