/* Graph
 *
 * The GnomeDbCanvasDbRelation graph widget can be used to display
 * a database structure
 */

#include <libgnomedb/libgnomedb.h>
#include <libgnomedb-graph/libgnomedb-graph.h>

extern GdaDict *demo_dict;
static GtkWidget *window = NULL;

static void
auto_layout_clicked_cb (GtkButton *button, GtkWidget *canvas)
{
	gnome_db_canvas_perform_auto_layout (GNOME_DB_CANVAS (canvas), TRUE, GNOME_DB_CANVAS_LAYOUT_DEFAULT);
}

GtkWidget *
do_graph (GtkWidget *do_widget)
{  
	if (!window) {
		GtkWidget *vbox;
		GtkWidget *label;
		GtkWidget *sw;
		GtkWidget *graphwidget;
		GdaGraph *graph;
		
		window = gtk_dialog_new_with_buttons ("Graph",
						      GTK_WINDOW (do_widget),
						      0,
						      GTK_STOCK_CLOSE,
						      GTK_RESPONSE_NONE,
						      NULL);
		
		g_signal_connect (window, "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
		g_signal_connect (window, "destroy",
				  G_CALLBACK (gtk_widget_destroyed), &window);
		
		vbox = gtk_vbox_new (FALSE, 5);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), vbox, TRUE, TRUE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
		
		label = gtk_label_new ("The following GnomeDbCanvasDbRelation widget displays\n"
				       "the complete database structure: the graph has been defined\n"
				       "(its items and their positions) in the dictionary.");
		gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
		
		/* Create the demo widget */
		graph = (GdaGraph*) gda_dict_get_object_by_name (demo_dict, GDA_TYPE_GRAPH, "Global");
		graphwidget = gnome_db_canvas_db_relations_new (demo_dict, graph);
		sw = gnome_db_canvas_set_in_scrolled_window (GNOME_DB_CANVAS (graphwidget));
		gtk_widget_set_size_request (graphwidget, 320, 320);
		
		gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);

		/* button to perform auto layout */
		if (gnome_db_canvas_auto_layout_enabled (GNOME_DB_CANVAS (graphwidget))) {
			GtkWidget *button;
			button = gtk_button_new_with_label ("Auto layout");
			gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
			g_signal_connect (button, "clicked",
					  G_CALLBACK (auto_layout_clicked_cb), graphwidget);
		}
	}

	if (!GTK_WIDGET_VISIBLE (window))
		gtk_widget_show_all (window);
	else
		gtk_widget_destroy (window);

	return window;
}


