/* gnome-db-table.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_TABLE_H_
#define __GNOME_DB_TABLE_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TABLE_TYPE          (gnome_db_table_get_type())
#define GNOME_DB_TABLE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_table_get_type(), GnomeDbTable)
#define GNOME_DB_TABLE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_table_get_type (), GnomeDbTableClass)
#define IS_GNOME_DB_TABLE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_table_get_type ())


/* error reporting */
extern GQuark gnome_db_table_error_quark (void);
#define GNOME_DB_TABLE_ERROR gnome_db_table_error_quark ()

enum
{
	GNOME_DB_TABLE_XML_LOAD_ERROR,
	GNOME_DB_TABLE_META_DATA_UPDATE,
	GNOME_DB_TABLE_FIELDS_ERROR
};


/* struct for the object's data */
struct _GnomeDbTable
{
	GnomeDbBase                  object;
	GnomeDbTablePrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbTableClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbTable *obj);
};

GType           gnome_db_table_get_type          (void);
GObject        *gnome_db_table_new               (GnomeDbDict *dict);

GnomeDbDatabase     *gnome_db_table_get_database      (GnomeDbTable *table);
gboolean        gnome_db_table_is_view           (GnomeDbTable *table);
const GSList   *gnome_db_table_get_parents       (GnomeDbTable *table);
GSList         *gnome_db_table_get_constraints   (GnomeDbTable *table);
GnomeDbConstraint *gnome_db_table_get_pk_constraint (GnomeDbTable *table);

GnomeDbDict         *gnome_db_table_get_dict          (GnomeDbTable *table);

gboolean        gnome_db_table_update_dbms_data  (GnomeDbTable *table, GError **error);

G_END_DECLS

#endif
