/* gnome-db-grid.h
 *
 * Copyright (C) 2002 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GRID__
#define __GNOME_DB_GRID__

#include <gtk/gtk.h>
#include <libgda/gda-data-model.h>
#include "gnome-db-dict.h"
#include "gnome-db-enums.h"

G_BEGIN_DECLS

#define GNOME_DB_GRID_TYPE          (gnome_db_grid_get_type())
#define GNOME_DB_GRID(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_grid_get_type(), GnomeDbGrid)
#define GNOME_DB_GRID_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_grid_get_type (), GnomeDbGridClass)
#define IS_GNOME_DB_GRID(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_grid_get_type ())


typedef struct _GnomeDbGrid      GnomeDbGrid;
typedef struct _GnomeDbGridClass GnomeDbGridClass;
typedef struct _GnomeDbGridPriv  GnomeDbGridPriv;
typedef void (* GnomeDbGridForeachFunc) (GnomeDbGrid *grid, gint row, gpointer user_data);

/* struct for the object's data */
struct _GnomeDbGrid
{
	GtkVBox             object;

	GnomeDbGridPriv     *priv;
};

/* struct for the object's class */
struct _GnomeDbGridClass
{
	GtkVBoxClass       parent_class;

	void             (* selection_changed) (GnomeDbGrid *grid, gboolean row_selected);
	void             (* double_clicked)    (GnomeDbGrid *grid, gint row);
        void             (* create_popup_menu) (GnomeDbGrid *grid, GtkWidget *menu);
};

/* 
 * Generic widget's methods 
 */
GType             gnome_db_grid_get_type                  (void);

GtkWidget        *gnome_db_grid_new                       (void);
GtkWidget        *gnome_db_grid_new_with_gda_model        (GnomeDbDict *dict, GdaDataModel *model);
GtkWidget        *gnome_db_grid_new_with_select_query     (GnomeDbQuery *query, GnomeDbTarget *modified);

void              gnome_db_grid_set_sample_size           (GnomeDbGrid *grid, gint sample_size);
void              gnome_db_grid_set_sample_start          (GnomeDbGrid *grid, gint sample_start);

void              gnome_db_grid_get_selection_mode        (GnomeDbGrid *grid, GtkSelectionMode mode);
GList            *gnome_db_grid_get_selection             (GnomeDbGrid *grid);
void              gnome_db_grid_select_all                (GnomeDbGrid *grid);
void              gnome_db_grid_unselect_all              (GnomeDbGrid *grid);
void              gnome_db_grid_foreach_selected          (GnomeDbGrid *grid,
							   GnomeDbGridForeachFunc foreach_func, gpointer user_data);
G_END_DECLS

#endif



