/* gnome-db-graphviz.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_GRAPHVIZ_H_
#define __GNOME_DB_GRAPHVIZ_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"

G_BEGIN_DECLS

typedef struct _GnomeDbGraphviz GnomeDbGraphviz;
typedef struct _GnomeDbGraphvizClass GnomeDbGraphvizClass;
typedef struct _GnomeDbGraphvizPrivate GnomeDbGraphvizPrivate;

#define GNOME_DB_GRAPHVIZ_TYPE          (gnome_db_graphviz_get_type())
#define GNOME_DB_GRAPHVIZ(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_graphviz_get_type(), GnomeDbGraphviz)
#define GNOME_DB_GRAPHVIZ_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_graphviz_get_type (), GnomeDbGraphvizClass)
#define IS_GNOME_DB_GRAPHVIZ(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_graphviz_get_type ())

/* error reporting */
extern GQuark gnome_db_graphviz_error_quark (void);
#define GNOME_DB_GRAPHVIZ_ERROR gnome_db_graphviz_error_quark ()

enum
{
        GNOME_DB_GRAPHVIZ_SAVE_ERROR
};


/* struct for the object's data */
struct _GnomeDbGraphviz
{
	GnomeDbBase                   object;
	GnomeDbGraphvizPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbGraphvizClass
{
	GnomeDbBaseClass              class;
};

GType           gnome_db_graphviz_get_type         (void);
GObject        *gnome_db_graphviz_new              (GnomeDbDict *dict);

void            gnome_db_graphviz_add_to_graph     (GnomeDbGraphviz *graph, GObject *obj);
gboolean        gnome_db_graphviz_save_file        (GnomeDbGraphviz *graph, const gchar *filename, GError **error);
G_END_DECLS

#endif
