/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#if !defined(_LIBGNOME_DB_H_)
#  define _LIBGNOME_DB_H_

#include <libgda/libgda.h>

/* original libgnomedb objects */
#include <libgnomedb/gnome-db-combo.h>
#include <libgnomedb/gnome-db-config.h>
#include <libgnomedb/gnome-db-connection-properties.h>
#include <libgnomedb/gnome-db-data-source-selector.h>
#include <libgnomedb/gnome-db-dsn-config.h>
#include <libgnomedb/gnome-db-dsn-config-druid.h>
#include <libgnomedb/gnome-db-editor.h>
#include <libgnomedb/gnome-db-error.h>
#include <libgnomedb/gnome-db-error-dialog.h>
#include <libgnomedb/gnome-db-find-dialog.h>
#include <libgnomedb/gnome-db-gray-bar.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomedb/gnome-db-login.h>
#include <libgnomedb/gnome-db-login-dialog.h>
#include <libgnomedb/gnome-db-provider-selector.h>
#include <libgnomedb/gnome-db-report-editor.h>
#include <libgnomedb/gnome-db-stock.h>
#include <libgnomedb/gnome-db-table-editor.h>

/* enumerations */
#include <libgnomedb/gnome-db-enums.h>

/* objects */
#include <libgnomedb/gnome-db-dict.h>
#include <libgnomedb/gnome-db-base.h>
#include <libgnomedb/gnome-db-ref-base.h>

#include <libgnomedb/gnome-db-server.h>
#include <libgnomedb/gnome-db-server-data-type.h>
#include <libgnomedb/gnome-db-server-function.h>
#include <libgnomedb/gnome-db-server-aggregate.h>
#include <libgnomedb/gnome-db-result-set.h>

#include <libgnomedb/gnome-db-database.h>
#include <libgnomedb/gnome-db-table.h>
#include <libgnomedb/gnome-db-table-field.h>
#include <libgnomedb/gnome-db-constraint.h>

#include <libgnomedb/gnome-db-model-wrapper.h>
#include <libgnomedb/gnome-db-wrapper-field.h>
#include <libgnomedb/gnome-db-data-proxy.h>

/* queries */
#include <libgnomedb/gnome-db-data-set.h>
#include <libgnomedb/gnome-db-parameter.h>
#include <libgnomedb/gnome-db-query.h>
#include <libgnomedb/gnome-db-target.h>
#include <libgnomedb/gnome-db-qfield.h>
#include <libgnomedb/gnome-db-join.h>
#include <libgnomedb/gnome-db-condition.h>
#include <libgnomedb/gnome-db-qf-field.h>
#include <libgnomedb/gnome-db-qf-all.h>
#include <libgnomedb/gnome-db-qf-value.h>
#include <libgnomedb/gnome-db-qf-func.h>

/* interfaces */
#include <libgnomedb/gnome-db-xml-storage.h>
#include <libgnomedb/gnome-db-data-handler.h>
#include <libgnomedb/gnome-db-data-entry.h>
#include <libgnomedb/gnome-db-renderer.h>
#include <libgnomedb/gnome-db-referer.h>
#include <libgnomedb/gnome-db-entity.h>
#include <libgnomedb/gnome-db-field.h>
#include <libgnomedb/gnome-db-data-widget.h>
#include <libgnomedb/gnome-db-data-model.h>

/* data handlers widgets */
#include <libgnomedb/handlers/gnome-db-entry-shell.h>
#include <libgnomedb/handlers/gnome-db-entry-wrapper.h>
#include <libgnomedb/handlers/gnome-db-entry-string.h>
#include <libgnomedb/handlers/gnome-db-entry-boolean.h>
#include <libgnomedb/handlers/gnome-db-entry-none.h>
#include <libgnomedb/handlers/gnome-db-entry-time.h>
#include <libgnomedb/handlers/gnome-db-entry-combo.h>

/* widgets */
#include <libgnomedb/handlers/gnome-db-data-cell-renderer-textual.h>
#include <libgnomedb/handlers/gnome-db-data-cell-renderer-boolean.h>
#include <libgnomedb/handlers/gnome-db-data-cell-renderer-info.h>
#include <libgnomedb/handlers/gnome-db-data-cell-renderer-combo.h>
#include <libgnomedb/gnome-db-selector.h>
#include <libgnomedb/gnome-db-dbms-update-viewer.h>
#include <libgnomedb/gnome-db-basic-form.h>
#include <libgnomedb/gnome-db-form.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-matrix.h>

/* graphs */
#include <libgnomedb/graph/gnome-db-graph.h>
#include <libgnomedb/graph/gnome-db-graph-query.h>
#include <libgnomedb/graph/gnome-db-graph-item.h>
#include <libgnomedb/graph/gnome-db-canvas.h>
#include <libgnomedb/graph/gnome-db-canvas-item.h>
#include <libgnomedb/graph/gnome-db-canvas-join.h>
#include <libgnomedb/graph/gnome-db-canvas-tip.h>
#include <libgnomedb/graph/gnome-db-canvas-cursor.h>
#include <libgnomedb/graph/gnome-db-canvas-db-relations.h>
#include <libgnomedb/graph/gnome-db-canvas-query-struct.h>

/* layouts */
#include <libgnomedb/gnome-db-custom-layout.h>
#include <libgnomedb/gnome-db-layout.h>

/* misc */
#include <libgnomedb/gnome-db-graphviz.h>


G_BEGIN_DECLS

void         gnome_db_init             (const gchar *app_id, const gchar *version, gint nargs, gchar *args[]);
GnomeDbDict *gnome_db_get_default_dict (void);
void         gnome_db_main_run         (GdaInitFunc init_func, gpointer user_data);
void         gnome_db_main_quit        (void);

G_END_DECLS

#endif
