/* gnome-db-entry-none.c
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gnome-db-entry-none.h"
#include <libgnomedb/gnome-db-data-handler.h>

/* 
 * Main static functions 
 */
static void gnome_db_entry_none_class_init (GnomeDbEntryNoneClass * class);
static void gnome_db_entry_none_init (GnomeDbEntryNone * srv);
static void gnome_db_entry_none_dispose (GObject   * object);
static void gnome_db_entry_none_finalize (GObject   * object);

/* virtual functions */
static GtkWidget *create_entry (GnomeDbEntryWrapper *mgwrap);
static void       real_set_value (GnomeDbEntryWrapper *mgwrap, const GdaValue *value);
static GdaValue  *real_get_value (GnomeDbEntryWrapper *mgwrap);
static void       connect_signals(GnomeDbEntryWrapper *mgwrap, GCallback callback);
static gboolean   expand_in_layout (GnomeDbEntryWrapper *mgwrap);


/* get a pointer to the parents to be able to call their destructor */
static GObjectClass  *parent_class = NULL;

/* private structure */
struct _GnomeDbEntryNonePrivate
{
	gboolean dummy;
};


guint
gnome_db_entry_none_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbEntryNoneClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_entry_none_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbEntryNone),
			0,
			(GInstanceInitFunc) gnome_db_entry_none_init
		};
		
		type = g_type_register_static (GNOME_DB_ENTRY_WRAPPER_TYPE, "GnomeDbEntryNone", &info, 0);
	}
	return type;
}

static void
gnome_db_entry_none_class_init (GnomeDbEntryNoneClass * class)
{
	GObjectClass   *object_class = G_OBJECT_CLASS (class);

	parent_class = g_type_class_peek_parent (class);

	object_class->dispose = gnome_db_entry_none_dispose;
	object_class->finalize = gnome_db_entry_none_finalize;

	GNOME_DB_ENTRY_WRAPPER_CLASS (class)->create_entry = create_entry;
	GNOME_DB_ENTRY_WRAPPER_CLASS (class)->real_set_value = real_set_value;
	GNOME_DB_ENTRY_WRAPPER_CLASS (class)->real_get_value = real_get_value;
	GNOME_DB_ENTRY_WRAPPER_CLASS (class)->connect_signals = connect_signals;
	GNOME_DB_ENTRY_WRAPPER_CLASS (class)->expand_in_layout = expand_in_layout;
}

static void
gnome_db_entry_none_init (GnomeDbEntryNone * gnome_db_entry_none)
{
	gnome_db_entry_none->priv = g_new0 (GnomeDbEntryNonePrivate, 1);
}

/**
 * gnome_db_entry_none_new
 * @dh: the data handler to be used by the new widget
 * @type: the requested data type (compatible with @dh)
 *
 * Creates a new widget which is mainly a GtkEntry
 *
 * Returns: the new widget
 */
GtkWidget *
gnome_db_entry_none_new (GnomeDbDataHandler *dh, GdaValueType type)
{
	GObject *obj;
	GnomeDbEntryNone *mgnone;

	g_return_val_if_fail (dh && IS_GNOME_DB_DATA_HANDLER (dh), NULL);
	g_return_val_if_fail (type != GDA_VALUE_TYPE_UNKNOWN, NULL);
	g_return_val_if_fail (gnome_db_data_handler_accepts_gda_type (dh, type), NULL);

	obj = g_object_new (GNOME_DB_ENTRY_NONE_TYPE, "handler", dh, NULL);
	mgnone = GNOME_DB_ENTRY_NONE (obj);
	gnome_db_data_entry_set_value_type (GNOME_DB_DATA_ENTRY (mgnone), type);

	return GTK_WIDGET (obj);
}


static void
gnome_db_entry_none_dispose (GObject   * object)
{
	GnomeDbEntryNone *gnome_db_entry_none;

	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_GNOME_DB_ENTRY_NONE (object));

	gnome_db_entry_none = GNOME_DB_ENTRY_NONE (object);
	if (gnome_db_entry_none->priv) {

	}

	/* parent class */
	parent_class->dispose (object);
}

static void
gnome_db_entry_none_finalize (GObject   * object)
{
	GnomeDbEntryNone *gnome_db_entry_none;

	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_GNOME_DB_ENTRY_NONE (object));

	gnome_db_entry_none = GNOME_DB_ENTRY_NONE (object);
	if (gnome_db_entry_none->priv) {

		g_free (gnome_db_entry_none->priv);
		gnome_db_entry_none->priv = NULL;
	}

	/* parent class */
	parent_class->finalize (object);
}

static GtkWidget *
create_entry (GnomeDbEntryWrapper *mgwrap)
{
	GtkWidget *frame, *label;
	GnomeDbEntryNone *mgnone;

	g_return_val_if_fail (mgwrap && IS_GNOME_DB_ENTRY_NONE (mgwrap), NULL);
	mgnone = GNOME_DB_ENTRY_NONE (mgwrap);
	g_return_val_if_fail (mgnone->priv, NULL);

	frame = gtk_frame_new (NULL);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
	label = gtk_label_new (_("This data cannot be displayed or edited\n"
				 "because of its data type, a plugin needs to be\n"
				 "affected to that data type (or develop if none exists!)"));
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);

	gtk_container_add (GTK_CONTAINER (frame), label);
	gtk_widget_show (label);

	return frame;
}

static void
real_set_value (GnomeDbEntryWrapper *mgwrap, const GdaValue *value)
{
	GnomeDbEntryNone *mgnone;

	g_return_if_fail (mgwrap && IS_GNOME_DB_ENTRY_NONE (mgwrap));
	mgnone = GNOME_DB_ENTRY_NONE (mgwrap);
	g_return_if_fail (mgnone->priv);
}

static GdaValue *
real_get_value (GnomeDbEntryWrapper *mgwrap)
{
	GnomeDbEntryNone *mgnone;

	g_return_val_if_fail (mgwrap && IS_GNOME_DB_ENTRY_NONE (mgwrap), NULL);
	mgnone = GNOME_DB_ENTRY_NONE (mgwrap);
	g_return_val_if_fail (mgnone->priv, NULL);

	return gda_value_new_null ();
}

static void
connect_signals(GnomeDbEntryWrapper *mgwrap, GCallback callback)
{
	GnomeDbEntryNone *mgnone;

	g_return_if_fail (mgwrap && IS_GNOME_DB_ENTRY_NONE (mgwrap));
	mgnone = GNOME_DB_ENTRY_NONE (mgwrap);
	g_return_if_fail (mgnone->priv);
}

static gboolean
expand_in_layout (GnomeDbEntryWrapper *mgwrap)
{
	return FALSE;
}
