/* gnome-db-ref-base.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_REF_BASE_H_
#define __GNOME_DB_REF_BASE_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_REF_BASE_TYPE          (gnome_db_ref_base_get_type())
#define GNOME_DB_REF_BASE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_ref_base_get_type(), GnomeDbRefBase)
#define GNOME_DB_REF_BASE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_ref_base_get_type (), GnomeDbRefBaseClass)
#define IS_GNOME_DB_REF_BASE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_ref_base_get_type ())

typedef struct _GnomeDbRefBase GnomeDbRefBase;
typedef struct _GnomeDbRefBaseClass GnomeDbRefBaseClass;
typedef struct _GnomeDbRefBasePrivate GnomeDbRefBasePrivate;

/* error reporting */
extern GQuark gnome_db_ref_base_error_quark (void);
#define GNOME_DB_REF_BASE_ERROR gnome_db_ref_base_error_quark ()

typedef enum
{
	REFERENCE_BY_XML_ID,
	REFERENCE_BY_NAME
} GnomeDbRefBaseType;

enum
{
	GNOME_DB_REF_BASE_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbRefBase
{
	GnomeDbBase                  object;
	GnomeDbRefBasePrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbRefBaseClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*ref_found)           (GnomeDbRefBase *obj);
	void   (*ref_lost)            (GnomeDbRefBase *obj);
};

guint           gnome_db_ref_base_get_type           (void);
GObject        *gnome_db_ref_base_new                (GnomeDbDict *dict);
GObject        *gnome_db_ref_base_new_no_ref_count   (GnomeDbDict *dict);
GObject        *gnome_db_ref_base_new_copy           (GnomeDbRefBase *orig);

void            gnome_db_ref_base_set_ref_name       (GnomeDbRefBase *ref, GType ref_type, 
						      GnomeDbRefBaseType type, const gchar *name);
const gchar    *gnome_db_ref_base_get_ref_name       (GnomeDbRefBase *ref, GType *ref_type, GnomeDbRefBaseType *type);
GType           gnome_db_ref_base_get_ref_type       (GnomeDbRefBase *ref);

void            gnome_db_ref_base_set_ref_object     (GnomeDbRefBase *ref, GnomeDbBase *object);
void            gnome_db_ref_base_set_ref_object_type(GnomeDbRefBase *ref, GnomeDbBase *object, GType type);
void            gnome_db_ref_base_replace_ref_object (GnomeDbRefBase *ref, GHashTable *replacements);
GnomeDbBase    *gnome_db_ref_base_get_ref_object     (GnomeDbRefBase *ref);

gboolean        gnome_db_ref_base_activate           (GnomeDbRefBase *ref);
void            gnome_db_ref_base_deactivate         (GnomeDbRefBase *ref);
gboolean        gnome_db_ref_base_is_active          (GnomeDbRefBase *ref);

G_END_DECLS

#endif
