/* gnome-db-referer.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_REFERER_H_
#define __GNOME_DB_REFERER_H_

#include <glib-object.h>
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_REFERER_TYPE          (gnome_db_referer_get_type())
#define GNOME_DB_REFERER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_referer_get_type(), GnomeDbReferer)
#define IS_GNOME_DB_REFERER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_referer_get_type ())
#define GNOME_DB_REFERER_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_REFERER_TYPE, GnomeDbRefererIface))

struct _GnomeDbRefererContext
{
	gpointer fill_later;
};

/* struct for the interface */
struct _GnomeDbRefererIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	gboolean    (* activate)        (GnomeDbReferer *iface);
	void        (* deactivate)      (GnomeDbReferer *iface);
	gboolean    (* is_active)       (GnomeDbReferer *iface);
	GSList     *(* get_ref_objects) (GnomeDbReferer *iface);
	void        (* replace_refs)    (GnomeDbReferer *iface, GHashTable *replacements);

	/* signals */
	void        (* activated)       (GnomeDbReferer *iface);
	void        (* deactivated)     (GnomeDbReferer *iface);
};

GType       gnome_db_referer_get_type            (void) G_GNUC_CONST;

gboolean    gnome_db_referer_activate            (GnomeDbReferer *iface);
void        gnome_db_referer_deactivate          (GnomeDbReferer *iface);
gboolean    gnome_db_referer_is_active           (GnomeDbReferer *iface);
GSList     *gnome_db_referer_get_ref_objects     (GnomeDbReferer *iface);
void        gnome_db_referer_replace_refs        (GnomeDbReferer *iface, GHashTable *replacements);

G_END_DECLS

#endif
