/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:04 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Boxed;
import org.gnu.gtk.Window;
public class WindowIcon extends Boxed 
{
	// no instantiations
	private WindowIcon(){}
	
 	/**
 	 * Set an icon for a window.
 	 * @param window The window to set the icon.
 	 * @param filename The filename of the icon
 	 */
 	public static void setIcon(Window window, String filename) {
 		gnome_window_icon_set_from_file(window.getHandle(), filename);
 	}

	/**
	 * Sets the default icon to be used in all windows of the application
	 * @param filename The filename of the icon.
	 */
	public static void setDefaultIcon(String filename){
		gnome_window_icon_set_default_from_file( filename );
	}
 		
 	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected void gnome_window_icon_set_from_default (int window);
    native static final protected void gnome_window_icon_set_from_file (int window, String filename);
    native static final protected void gnome_window_icon_set_from_file_list (int window, 
        String[] filenames);
    native static final protected void gnome_window_icon_set_default_from_file (String filename);
    native static final protected void gnome_window_icon_set_default_from_file_list (
        String[] filenames);
    native static final protected void gnome_window_icon_init ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

